/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnumRange;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import java.util.Enumeration;
import java.util.regex.Pattern;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EnumTextRangeAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/EnumTextRangeAttributeControl.java";
    private Button radioPredefined = null;
    private Button radioUserdefined = null;
    private ExtCombo combo = null;
    private Text text = null;
    private static final int TEXT_ANY_LENGTH = -1;
    private AttrTypeFixedLengthStringEnumRange attrTypeStringEnumRange = null;
    private boolean enabled = true;
    private Object originalValue = null;

    public EnumTextRangeAttributeControl(final Trace t, Composite parent, int style, AttrType attrType, Object currentValue) {
        super(t, parent, style, attrType, currentValue);
        this.attrTypeStringEnumRange = (AttrTypeFixedLengthStringEnumRange)attrType;
        this.originalValue = currentValue;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.radioPredefined = new Button((Composite)this, 16);
        GridData gridData = new GridData();
        this.radioPredefined.setLayoutData((Object)gridData);
        this.radioPredefined.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                if (EnumTextRangeAttributeControl.this.radioPredefined.getSelection()) {
                    EnumTextRangeAttributeControl.this.predefinedSelected(tr);
                    EnumTextRangeAttributeControl.this.valueChanged(tr);
                }
            }
        });
        this.radioPredefined.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String label = EnumTextRangeAttributeControl.this.getAssociatedLabel().getText();
                String value = (String)EnumTextRangeAttributeControl.this.combo.getObject(EnumTextRangeAttributeControl.this.combo.getSelectionIndex());
                if (value != null) {
                    label = String.valueOf(label) + " " + value;
                }
                e.result = label;
            }
        });
        this.combo = new ExtCombo(this, 2060);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData(gridData);
        String strValue = "";
        if (currentValue instanceof String) {
            strValue = (String)currentValue;
        }
        String selectValue = strValue;
        String[] enumIds = this.attrTypeStringEnumRange.getEnumerationIds(t);
        int i = 0;
        while (i < enumIds.length) {
            String enumName = this.attrTypeStringEnumRange.getEnumeratedValue(t, enumIds[i]);
            this.combo.add(enumName);
            if (enumIds[i].compareToIgnoreCase(strValue) == 0) {
                selectValue = enumName;
                this.originalValue = enumIds[i];
            }
            ++i;
        }
        this.combo.sort();
        int index = this.combo.indexOfIgnoreCase(selectValue);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                EnumTextRangeAttributeControl.this.valueChanged(tr);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                EnumTextRangeAttributeControl.this.valueChanged(tr);
            }
        });
        this.radioUserdefined = new Button((Composite)this, 16);
        gridData = new GridData();
        this.radioUserdefined.setLayoutData((Object)gridData);
        this.radioUserdefined.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                if (EnumTextRangeAttributeControl.this.radioUserdefined.getSelection()) {
                    EnumTextRangeAttributeControl.this.userdefinedSelected(tr);
                    EnumTextRangeAttributeControl.this.valueChanged(tr);
                }
            }
        });
        this.radioUserdefined.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String label = EnumTextRangeAttributeControl.this.getAssociatedLabel().getText();
                e.result = String.valueOf(label) + " " + EnumTextRangeAttributeControl.this.text.getText();
            }
        });
        this.text = new Text((Composite)this, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.text.setLayoutData((Object)gridData);
        int maxLength = this.attrTypeStringEnumRange.getLength();
        if (maxLength != -1) {
            this.text.setTextLimit(maxLength);
        }
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                EnumTextRangeAttributeControl.this.valueChanged(tr);
            }
        });
        final Pattern p = this.attrTypeStringEnumRange.getRegularExpression();
        if (p != null) {
            this.text.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    String current = EnumTextRangeAttributeControl.this.text.getText();
                    StringValidation.verifyUsingRegularExpression(t, current, e, p);
                }
            });
        }
        if (index != -1) {
            this.combo.select(index);
            this.radioPredefined.setSelection(true);
            this.predefinedSelected(t);
        } else {
            this.text.setText(strValue);
            this.radioUserdefined.setSelection(true);
            this.userdefinedSelected(t);
        }
    }

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    private void predefinedSelected(Trace t) {
        this.combo.setEnabled(true);
        this.text.setEnabled(false);
    }

    private void userdefinedSelected(Trace t) {
        this.combo.setEnabled(false);
        this.text.setEnabled(true);
    }

    @Override
    public String toString() {
        String value = "";
        if (this.radioPredefined != null) {
            if (this.radioPredefined.getSelection()) {
                if (this.combo != null) {
                    value = this.combo.getText();
                }
            } else if (this.text != null) {
                value = this.text.getText();
            }
        }
        return value;
    }

    @Override
    public Object getValue(Trace t) {
        String strValue = null;
        String stringValue = this.toString();
        String[] enumIds = this.attrTypeStringEnumRange.getEnumerationIds(t);
        int i = 0;
        while (i < enumIds.length) {
            String enumName = this.attrTypeStringEnumRange.getEnumeratedValue(t, enumIds[i]);
            if (enumName.compareToIgnoreCase(stringValue) == 0) {
                strValue = enumIds[i];
                break;
            }
            ++i;
        }
        if (strValue == null) {
            String obj;
            if (Trace.isTracing) {
                t.data(67, "EnumTextRangeAttributeControl.getValue", 900, "Error: Current value '" + stringValue + "' does not match any enumerate values");
            }
            strValue = (obj = this.toString()) instanceof Integer ? obj : this.toString();
        }
        return strValue;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.radioPredefined.setEnabled(this.enabled);
        if (this.radioPredefined.getSelection()) {
            this.combo.setEnabled(this.enabled);
        } else {
            this.combo.setEnabled(false);
        }
        this.radioUserdefined.setEnabled(this.enabled);
        if (this.radioUserdefined.getSelection()) {
            this.text.setEnabled(this.enabled);
        } else {
            this.text.setEnabled(false);
        }
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = false;
        if (value instanceof String) {
            String strValue = (String)value;
            int index = this.combo.indexOfIgnoreCase(strValue);
            if (index != -1) {
                accepted = true;
                this.radioPredefined.setSelection(true);
                this.radioUserdefined.setSelection(false);
                this.combo.select(index);
            }
            if (!accepted) {
                accepted = true;
                this.radioPredefined.setSelection(false);
                this.radioUserdefined.setSelection(true);
                this.text.setText(strValue);
            }
        }
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        boolean changed = false;
        Object currentValue = this.getValue(t);
        changed = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return changed;
    }

    @Override
    public void valueApplied(Trace t) {
        Object value;
        this.originalValue = value = this.getValue(t);
        if (value instanceof String) {
            String strValue = (String)value;
            String[] enumIds = this.attrTypeStringEnumRange.getEnumerationIds(t);
            int i = 0;
            while (i < enumIds.length) {
                String enumName = this.attrTypeStringEnumRange.getEnumeratedValue(t, enumIds[i]);
                if (enumName.compareToIgnoreCase(strValue) == 0) {
                    this.originalValue = enumName;
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }

    @Override
    public void addMandatoryDecoration(Trace t) {
        this.createControlDecoration(t, (Control)this.radioPredefined);
    }
}

