/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringEnum;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import java.util.Enumeration;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EnumTextAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/EnumTextAttributeControl.java";
    private ExtCombo combo = null;
    private boolean enabled = true;
    private AttrTypeFixedLengthStringEnum attrTypeFLSEnum = null;
    private Object originalValue = null;

    public EnumTextAttributeControl(Trace t, Composite parent, int style, AttrType attrType, Object currentValue) {
        super(t, parent, style, attrType, currentValue);
        this.attrTypeFLSEnum = (AttrTypeFixedLengthStringEnum)attrType;
        this.originalValue = currentValue;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.combo = new ExtCombo(this, 2060);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.combo.setLayoutData(gridData);
        String[] enumNames = this.attrTypeFLSEnum.getEnumerationIds(t);
        String selectName = null;
        int i = 0;
        while (i < enumNames.length) {
            String comboname = this.attrTypeFLSEnum.getEnumeratedValue(t, enumNames[i]);
            if (!this.attrTypeFLSEnum.hasBeenSuperseded(t, enumNames[i])) {
                this.combo.add(comboname);
            }
            ++i;
        }
        if (currentValue instanceof String) {
            String[] stringArray = enumNames;
            int n = enumNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (((String)currentValue).compareToIgnoreCase(name) == 0) {
                    selectName = this.attrTypeFLSEnum.getEnumeratedValue(t, name);
                    this.combo.select(this.combo.indexOfIgnoreCase(selectName));
                }
                ++n2;
            }
        }
        this.combo.sort();
        if (selectName == null) {
            this.combo.add((String)currentValue, 0);
            this.combo.select(0);
        }
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                EnumTextAttributeControl.this.valueChanged(tr);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                EnumTextAttributeControl.this.valueChanged(tr);
            }
        });
    }

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    @Override
    public String toString() {
        String value = "";
        if (this.combo != null) {
            value = this.combo.getText();
        }
        return value;
    }

    @Override
    public Object getValue(Trace t) {
        String strValue = null;
        String stringValue = this.toString();
        String[] enumIds = this.attrTypeFLSEnum.getEnumerationIds(t);
        int i = 0;
        while (i < enumIds.length) {
            String enumName = this.attrTypeFLSEnum.getEnumeratedValue(t, enumIds[i]);
            if (enumName.compareTo(stringValue) == 0 && !this.attrTypeFLSEnum.hasBeenSuperseded(t, enumIds[i])) {
                strValue = enumIds[i];
                break;
            }
            ++i;
        }
        if (strValue == null) {
            String obj;
            if (Trace.isTracing) {
                t.data(67, "EnumTextAttributeControl.getValue", 900, "Error: Current value '" + stringValue + "' does not match any enumerate values");
            }
            strValue = (obj = this.toString()) instanceof Integer ? obj : this.toString();
        }
        return strValue;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.combo.setEnabled(this.enabled);
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        String strValue = "";
        if (value instanceof String) {
            strValue = (String)value;
        }
        boolean accepted = false;
        int index = this.combo.indexOfIgnoreCase(strValue);
        if (index != -1) {
            accepted = true;
            this.combo.select(index);
        }
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        boolean result = false;
        Object currentValue = this.getValue(t);
        result = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return result;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }
}

