/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditURLDialog
extends org.eclipse.swt.widgets.Dialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/EditURLDialog.java";
    private static final String FILE_PROTOCOL = "file";
    private static final int TEXT_INDENT = 20;
    private Shell shellDlg = null;
    private int numCols = 2;
    private String initialValue = null;
    private String currentValue = null;
    private AttrType attrType = null;
    private boolean isOK = false;
    private boolean isFileURL = false;
    private Composite compositeMsgBar = null;
    private Label labelMsgBarIcon = null;
    private Label labelMsgBarMessage = null;
    private Button radioFile = null;
    private Button radioOther = null;
    private Text textFile = null;
    private Button buttonFileSelect = null;
    private Text textOther = null;
    private Composite compositeOKCancelButtons = null;
    private Button buttonOK = null;
    private Button buttonCancel = null;
    private GridData gridDataOK = null;
    private GridData gridDataCancel = null;
    private Message msgFile = null;
    private static int MAX_WIDTH = 250;

    public EditURLDialog(Trace t, Shell parent, int style) {
        super(parent, style);
    }

    public boolean open(Trace t, String initValue, AttrType attType) {
        this.initialValue = initValue;
        this.attrType = attType;
        this.currentValue = this.initialValue;
        if (this.initialValue.length() > 0) {
            try {
                URL url = new URL(this.initialValue);
                String protocol = url.getProtocol();
                if (protocol != null && protocol.equals(FILE_PROTOCOL)) {
                    this.isFileURL = true;
                    this.currentValue = url.getFile();
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
        Shell parent = this.getParent();
        this.shellDlg = new Shell(parent, 67696);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = this.numCols;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        this.shellDlg.setLayout((Layout)gridLayout);
        String title = Message.format((String)this.msgFile.getMessage(t, "UI.PROP.Dialog.EditTitle"), (String)this.attrType.getDisplayTitle());
        this.shellDlg.setText(title);
        Image image = this.getParent().getImage();
        if (image == null) {
            image = Icons.get(Icons.iconkeyExplorerSmall);
        }
        this.shellDlg.setImage(image);
        UiPlugin.getHelpSystem().setHelp((Control)this.shellDlg, "com.ibm.mq.explorer.ui.infopop.UI_IntArrayEnumEditDialog");
        this.compositeMsgBar = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeMsgBar.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = this.numCols;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeMsgBar.setLayoutData((Object)gridData);
        this.labelMsgBarIcon = new Label(this.compositeMsgBar, 0);
        this.labelMsgBarIcon.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
        this.labelMsgBarIcon.setVisible(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.labelMsgBarIcon.setLayoutData((Object)gridData);
        this.labelMsgBarMessage = new Label(this.compositeMsgBar, 0);
        this.labelMsgBarMessage.setText(String.valueOf(title) + title);
        this.labelMsgBarMessage.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.labelMsgBarMessage.setLayoutData((Object)gridData);
        this.radioFile = new Button((Composite)this.shellDlg, 16);
        this.radioFile.setText(this.msgFile.getMessage(t, "UI.PROP.Dialog.File"));
        this.radioFile.setSelection(this.isFileURL);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = this.numCols;
        this.radioFile.setLayoutData((Object)gridData);
        this.radioFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                EditURLDialog.this.isFileURL = EditURLDialog.this.radioFile.getSelection();
                EditURLDialog.this.enableControls(tr);
                EditURLDialog.this.checkIfEnableOK(tr);
            }
        });
        Composite compFile = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = this.numCols;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        compFile.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = this.numCols;
        gridData.horizontalIndent = 20;
        gridData.grabExcessHorizontalSpace = true;
        compFile.setLayoutData((Object)gridData);
        this.textFile = new Text(compFile, 2052);
        if (this.isFileURL) {
            this.textFile.setText(this.currentValue);
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = this.numCols - 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = MAX_WIDTH;
        this.textFile.setLayoutData((Object)gridData);
        this.textFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                EditURLDialog.this.checkIfEnableOK(tr);
            }
        });
        this.buttonFileSelect = new Button(compFile, 8);
        Message mFile = UiPlugin.getUIMessages(t, "KEY_NewObject");
        this.buttonFileSelect.setText(mFile.getMessage(t, "UI.NewObject.WizPage1.ButtonSelect"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 1;
        this.buttonFileSelect.setLayoutData((Object)gridData);
        this.buttonFileSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                EditURLDialog.this.selectFile(tr);
            }
        });
        this.radioOther = new Button((Composite)this.shellDlg, 16);
        this.radioOther.setText(this.msgFile.getMessage(t, "UI.PROP.Dialog.Other"));
        this.radioOther.setSelection(!this.isFileURL);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = this.numCols;
        this.radioOther.setLayoutData((Object)gridData);
        this.radioOther.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                EditURLDialog.this.isFileURL = EditURLDialog.this.radioFile.getSelection();
                EditURLDialog.this.enableControls(tr);
                EditURLDialog.this.checkIfEnableOK(tr);
            }
        });
        Composite compOther = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = this.numCols;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        compOther.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = this.numCols;
        gridData.horizontalIndent = 20;
        gridData.grabExcessHorizontalSpace = true;
        compOther.setLayoutData((Object)gridData);
        this.textOther = new Text(compOther, 2052);
        if (!this.isFileURL) {
            this.textOther.setText(this.currentValue);
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = this.numCols - 1;
        gridData.widthHint = MAX_WIDTH;
        gridData.grabExcessHorizontalSpace = true;
        this.textOther.setLayoutData((Object)gridData);
        this.textOther.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                EditURLDialog.this.checkIfEnableOK(tr);
            }
        });
        Button button = new Button(compOther, 8);
        button.setText(mFile.getMessage(t, "UI.NewObject.WizPage1.ButtonSelect"));
        button.setVisible(false);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.horizontalSpan = 1;
        button.setLayoutData((Object)gridData);
        Label label = new Label((Composite)this.shellDlg, 0);
        label.setVisible(false);
        gridData = new GridData(1808);
        gridData.horizontalSpan = this.numCols;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.compositeOKCancelButtons = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeOKCancelButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = this.numCols;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeOKCancelButtons.setLayoutData((Object)gridData);
        label = new Label(this.compositeOKCancelButtons, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonOK = new Button(this.compositeOKCancelButtons, 8);
        this.buttonOK.setText(this.msgFile.getMessage(t, "UI.GENERAL.OK"));
        this.gridDataOK = new GridData();
        this.gridDataOK.horizontalAlignment = 3;
        this.buttonOK.setLayoutData((Object)this.gridDataOK);
        this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditURLDialog.this.isOK = true;
                URL url = EditURLDialog.this.getEnteredURL(tr);
                if (url != null) {
                    EditURLDialog.this.currentValue = url.toString();
                } else {
                    EditURLDialog.this.currentValue = new String();
                }
                EditURLDialog.this.shellDlg.close();
            }
        });
        this.buttonCancel = new Button(this.compositeOKCancelButtons, 8);
        this.buttonCancel.setText(this.msgFile.getMessage(t, "UI.GENERAL.CANCEL"));
        this.gridDataCancel = new GridData();
        this.gridDataCancel.horizontalAlignment = 3;
        this.buttonCancel.setLayoutData((Object)this.gridDataCancel);
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditURLDialog.this.isOK = false;
                EditURLDialog.this.shellDlg.close();
            }
        });
        int maxWidth = 0;
        Point sizeOK = this.buttonOK.computeSize(-1, -1);
        Point sizeCancel = this.buttonCancel.computeSize(-1, -1);
        if (sizeOK.x > maxWidth) {
            maxWidth = sizeOK.x;
        }
        if (sizeCancel.x > maxWidth) {
            maxWidth = sizeCancel.x;
        }
        this.gridDataOK.widthHint = maxWidth;
        this.gridDataCancel.widthHint = maxWidth;
        this.enableControls(t);
        this.shellDlg.setDefaultButton(this.buttonOK);
        this.checkIfEnableOK(t);
        this.shellDlg.pack();
        UiUtils.makeShellCenteredOnParent(t, parent, this.shellDlg);
        this.shellDlg.open();
        Display display = parent.getDisplay();
        while (!this.shellDlg.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.isOK;
    }

    private void checkIfEnableOK(Trace t) {
        boolean ok = false;
        boolean isShowMsg = false;
        URL value = this.getEnteredURL(t);
        ok = value == null ? (this.isFileURL ? this.textFile.getText().length() == 0 : this.textOther.getText().length() == 0) : true;
        if (ok) {
            File file;
            if (this.isFileURL && !(file = new File(this.textFile.getText())).exists()) {
                isShowMsg = true;
                this.labelMsgBarMessage.setText(this.msgFile.getMessage(t, "UI.PROP.Dialog.FileNotExist"));
            }
        } else {
            isShowMsg = true;
            this.labelMsgBarMessage.setText(this.msgFile.getMessage(t, "UI.PROP.Dialog.InvalidURL"));
        }
        this.labelMsgBarIcon.setVisible(isShowMsg);
        this.labelMsgBarMessage.setVisible(isShowMsg);
        this.buttonOK.setEnabled(ok);
    }

    public String getCurrentValue(Trace t) {
        return this.currentValue;
    }

    private URL getEnteredURL(Trace t) {
        URL value = null;
        try {
            if (this.isFileURL) {
                String filename = this.textFile.getText();
                if (filename.length() > 0) {
                    value = new URL(FILE_PROTOCOL, null, filename);
                }
            } else {
                String other = this.textOther.getText();
                value = new URL(other);
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return value;
    }

    private void enableControls(Trace t) {
        this.buttonFileSelect.setEnabled(this.isFileURL);
        if (this.isFileURL) {
            UiUtils.makeTextControlReadWrite(t, this.textFile);
            UiUtils.makeTextControlReadOnly(t, this.textOther, false);
            this.buttonFileSelect.setFocus();
        } else {
            UiUtils.makeTextControlReadWrite(t, this.textOther);
            UiUtils.makeTextControlReadOnly(t, this.textFile, false);
            this.textOther.setFocus();
        }
    }

    private void selectFile(Trace t) {
        FileDialog fileDialog = new FileDialog(this.shellDlg, 4096);
        fileDialog.setFileName(this.textFile.getText());
        String result = fileDialog.open();
        if (result != null) {
            this.textFile.setText(result);
        }
    }
}

