/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthStringListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.properties.AddStringArrayDialog;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class EditStringArrayDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/EditStringArrayDialog.java";
    private static final int NUM_COLS = 1;
    private List listCtrl = null;
    private static final int LIST_HEIGHT_HINT = 100;
    private static final int LIST_MAX_WIDTH = 500;
    private Composite compositeAddEditRemoveButtons = null;
    private Button buttonAdd = null;
    private Button buttonEdit = null;
    private Button buttonRemove = null;
    private GridData gridDataAdd = null;
    private GridData gridDataEdit = null;
    private GridData gridDataRemove = null;
    private ArrayList<String> stringArrayValues = null;
    private AttrTypeStringArray attrType = null;
    private int maxItemLength = -1;
    private int maxLength = -1;
    private int maxItems = -1;
    private Message msgFile = null;

    public EditStringArrayDialog(Shell parent, ArrayList<String> values, AttrTypeStringArray attType) {
        super(parent);
        this.stringArrayValues = values;
        this.attrType = attType;
        this.setShellStyle(this.getShellStyle() | 0x10);
        Trace t = Trace.getDefault();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Trace t = Trace.getDefault();
        String title = Message.format((String)this.msgFile.getMessage(t, "UI.PROP.Dialog.EditStringArrayTitle"), (String)this.attrType.getDisplayTitle());
        newShell.setText(title);
        Image image = this.getParentShell().getImage();
        if (image == null) {
            image = Icons.get(Icons.iconkeyExplorerSmall);
        }
        newShell.setImage(image);
        UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.ui.infopop.UI_StringArrayEditDialog");
    }

    public Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        this.maxItemLength = this.attrType.getMaxLen();
        this.maxItems = this.attrType.getMaxNumberOfItems();
        if (this.attrType instanceof AttrTypeFixedLengthStringListItem) {
            AttrTypeFixedLengthStringListItem attrTypeFLSListItem = (AttrTypeFixedLengthStringListItem)this.attrType;
            this.maxLength = attrTypeFLSListItem.getTotalLength();
        }
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.listCtrl = new List(composite, 2816);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        gridData.heightHint = 100;
        this.listCtrl.setLayoutData((Object)gridData);
        this.compositeAddEditRemoveButtons = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeAddEditRemoveButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeAddEditRemoveButtons.setLayoutData((Object)gridData);
        this.buttonAdd = new Button(this.compositeAddEditRemoveButtons, 8);
        this.buttonAdd.setText(this.msgFile.getMessage(t, "UI.PROP.Dialog.Add"));
        this.gridDataAdd = new GridData();
        this.gridDataAdd.horizontalAlignment = 1;
        this.buttonAdd.setLayoutData((Object)this.gridDataAdd);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditStringArrayDialog.this.addItem(tr);
            }
        });
        this.buttonEdit = new Button(this.compositeAddEditRemoveButtons, 8);
        this.buttonEdit.setText(this.msgFile.getMessage(t, "UI.PROP.Dialog.Edit"));
        this.gridDataEdit = new GridData();
        this.gridDataEdit.horizontalAlignment = 1;
        this.buttonEdit.setLayoutData((Object)this.gridDataEdit);
        this.buttonEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditStringArrayDialog.this.editItem(tr);
            }
        });
        this.buttonRemove = new Button(this.compositeAddEditRemoveButtons, 8);
        this.buttonRemove.setText(this.msgFile.getMessage(t, "UI.PROP.Dialog.Remove.NoConfirm"));
        this.gridDataRemove = new GridData();
        this.gridDataRemove.horizontalAlignment = 1;
        this.buttonRemove.setLayoutData((Object)this.gridDataRemove);
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditStringArrayDialog.this.removeItem(tr);
            }
        });
        int maxWidth = 0;
        Point sizeAdd = this.buttonAdd.computeSize(-1, -1);
        Point sizeEdit = this.buttonEdit.computeSize(-1, -1);
        Point sizeRemove = this.buttonRemove.computeSize(-1, -1);
        if (sizeAdd.x > maxWidth) {
            maxWidth = sizeAdd.x;
        }
        if (sizeEdit.x > maxWidth) {
            maxWidth = sizeEdit.x;
        }
        if (sizeRemove.x > maxWidth) {
            maxWidth = sizeRemove.x;
        }
        this.gridDataAdd.widthHint = maxWidth;
        this.gridDataEdit.widthHint = maxWidth;
        this.gridDataRemove.widthHint = maxWidth;
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        int i = 0;
        while (i < this.stringArrayValues.size()) {
            String item = this.stringArrayValues.get(i);
            this.listCtrl.add(item.trim());
            ++i;
        }
        int count = this.listCtrl.getItemCount();
        if (count > 0) {
            this.listCtrl.select(count - 1);
        }
        Point size = this.listCtrl.computeSize(-1, -1);
        if (size.x > 500) {
            gridData = (GridData)this.listCtrl.getLayoutData();
            gridData.widthHint = 500;
        }
        this.checkIfEnableAddEditRemove(t);
        return composite;
    }

    protected void okPressed() {
        this.getNewValues(Trace.getDefault());
        super.okPressed();
    }

    private void checkIfEnableAddEditRemove(Trace t) {
        int count = this.listCtrl.getItemCount();
        boolean enableAdd = true;
        if (this.maxLength > 0) {
            boolean bl = enableAdd = this.calculateMaxAddLength(t) > 0;
        }
        if (enableAdd && this.maxItems > 0) {
            enableAdd = count < this.maxItems;
        }
        boolean enableEditRemove = count > 0;
        this.buttonAdd.setEnabled(enableAdd);
        this.buttonEdit.setEnabled(enableEditRemove);
        this.buttonRemove.setEnabled(enableEditRemove);
    }

    public ArrayList<String> getStringArrayValues() {
        return this.stringArrayValues;
    }

    private void addItem(Trace t) {
        AddStringArrayDialog addDlg;
        int maxAddLength = -1;
        if (this.maxLength > 0 && this.maxItemLength > 0 && (maxAddLength = this.calculateMaxAddLength(t)) > this.maxItemLength) {
            maxAddLength = this.maxItemLength;
        }
        if ((addDlg = new AddStringArrayDialog(t, this.getShell(), true, null, this.attrType, maxAddLength)).open() == 0) {
            int index = this.listCtrl.getSelectionIndex();
            if (index == -1) {
                index = this.listCtrl.getItemCount() - 1;
            }
            int newIndex = index + 1;
            this.listCtrl.add(addDlg.getStringValue(), newIndex);
            this.listCtrl.setSelection(newIndex);
            this.checkIfEnableAddEditRemove(t);
        }
    }

    private int calculateMaxAddLength(Trace t) {
        int maxAddLength = -1;
        if (this.maxLength > 0) {
            int existLength = 0;
            int i = 0;
            while (i < this.listCtrl.getItemCount()) {
                String text = this.listCtrl.getItem(i);
                existLength += text.length();
                ++i;
            }
            maxAddLength = this.maxLength - existLength;
        }
        return maxAddLength;
    }

    private void editItem(Trace t) {
        int index = this.listCtrl.getSelectionIndex();
        if (index != -1) {
            AddStringArrayDialog addDlg;
            String item = this.listCtrl.getItem(index);
            int maxEditLength = -1;
            if (this.maxLength > 0 && this.maxItemLength > 0 && (maxEditLength = this.calculateMaxAddLength(t) + item.length()) > this.maxItemLength) {
                maxEditLength = this.maxItemLength;
            }
            if ((addDlg = new AddStringArrayDialog(t, this.getShell(), false, item, this.attrType, maxEditLength)).open() == 0) {
                this.listCtrl.setItem(index, addDlg.getStringValue());
                this.checkIfEnableAddEditRemove(t);
            }
        }
        this.listCtrl.redraw();
        this.checkIfEnableAddEditRemove(t);
    }

    private void removeItem(Trace t) {
        int index = this.listCtrl.getSelectionIndex();
        if (index != -1) {
            this.listCtrl.remove(index);
        }
        if (index > 0) {
            this.listCtrl.select(index - 1);
        } else {
            this.listCtrl.select(0);
        }
        this.listCtrl.redraw();
        this.checkIfEnableAddEditRemove(t);
    }

    private void getNewValues(Trace t) {
        this.stringArrayValues.clear();
        int i = 0;
        while (i < this.listCtrl.getItemCount()) {
            String item = this.listCtrl.getItem(i);
            this.stringArrayValues.add(item);
            ++i;
        }
    }
}

