/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeIntArrayEnum;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.filters.ValuePair;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EditIntArrayEnumDialog
extends Dialog
implements SelectionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/EditIntArrayEnumDialog.java";
    private Shell shellDlg = null;
    private int numCols = 1;
    private boolean isOK = false;
    private Composite compositeOKCancelButtons = null;
    private Button buttonOK = null;
    private Button buttonCancel = null;
    private GridData gridDataOK = null;
    private GridData gridDataCancel = null;
    private ArrayList originalIntegerValues = null;
    private ArrayList<Integer> currentIntegerValues = null;
    private ArrayList<String> currentStringValues = null;
    private ArrayList<Button> checkboxes = null;
    private ArrayList<ExtCombo> combos = null;
    private ValuePair[] valuePairs = null;
    private boolean isUniqueMode = true;
    private UiMQObject uiMQObject = null;
    private int attrId = -1;
    private Message msgFile = null;

    public EditIntArrayEnumDialog(Trace t, Shell parent, int style) {
        super(parent, style);
    }

    public boolean open(Trace t, ArrayList values, AttrTypeIntArrayEnum attrType, UiMQObject uiMQObj, int attId) {
        this.originalIntegerValues = values;
        this.uiMQObject = uiMQObj;
        this.attrId = attId;
        this.currentIntegerValues = new ArrayList();
        this.currentStringValues = new ArrayList();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
        this.isUniqueMode = attrType.isUnique(t);
        this.numCols = this.isUniqueMode ? 2 : 1;
        Shell parent = this.getParent();
        this.shellDlg = new Shell(parent, 67696);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = this.numCols;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        this.shellDlg.setLayout((Layout)gridLayout);
        String title = Message.format((String)this.msgFile.getMessage(t, "UI.PROP.Dialog.EditIntArrayEnumTitle"), (String)attrType.getDisplayTitle());
        this.shellDlg.setText(title);
        Image image = this.getParent().getImage();
        if (image == null) {
            image = Icons.get(Icons.iconkeyExplorerSmall);
        }
        this.shellDlg.setImage(image);
        UiPlugin.getHelpSystem().setHelp((Control)this.shellDlg, "com.ibm.mq.explorer.ui.infopop.UI_IntArrayEnumEditDialog");
        Label labelPad = new Label((Composite)this.shellDlg, 0);
        labelPad.setText(String.valueOf(title) + title);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = this.numCols;
        labelPad.setLayoutData((Object)gridData);
        Integer[] enumIds = attrType.getEnumerationIds(t);
        int validIds = 0;
        int i = 0;
        while (i < enumIds.length) {
            if (this.uiMQObject.getDmObject().isEnumerationIdValid(t, this.attrId, enumIds[i].intValue())) {
                ++validIds;
            }
            ++i;
        }
        this.valuePairs = new ValuePair[validIds];
        i = 0;
        int index = 0;
        while (i < enumIds.length) {
            if (this.uiMQObject.getDmObject().isEnumerationIdValid(t, this.attrId, enumIds[i].intValue())) {
                this.valuePairs[index++] = new ValuePair(enumIds[i], attrType.getEnumeratedValue(t, enumIds[i]));
            }
            ++i;
        }
        int numItems = this.originalIntegerValues.size();
        if (this.isUniqueMode) {
            numItems = validIds;
        }
        this.checkboxes = new ArrayList();
        this.combos = new ArrayList();
        Button checkbox = null;
        boolean enableNextCheckbox = true;
        int i2 = 0;
        while (i2 < numItems) {
            if (this.isUniqueMode) {
                checkbox = new Button((Composite)this.shellDlg, 32);
                this.checkboxes.add(checkbox);
                checkbox.setData((Object)i2);
                gridData = new GridData();
                checkbox.setLayoutData((Object)gridData);
                checkbox.addSelectionListener((SelectionListener)this);
            }
            ExtCombo combo = new ExtCombo((Composite)this.shellDlg, 2060);
            this.combos.add(combo);
            ValuePair selectValuePair = null;
            int j = 0;
            while (j < this.valuePairs.length) {
                combo.add(this.valuePairs[j]);
                if (i2 < this.originalIntegerValues.size() && this.valuePairs[j].getValue() == ((Integer)this.originalIntegerValues.get(i2)).intValue()) {
                    selectValuePair = this.valuePairs[j];
                }
                ++j;
            }
            combo.sort();
            if (selectValuePair != null) {
                combo.select(combo.indexOfObject(selectValuePair));
                if (this.isUniqueMode && checkbox != null) {
                    checkbox.setEnabled(true);
                    checkbox.setSelection(true);
                    enableNextCheckbox = true;
                    j = 0;
                    while (j < i2) {
                        Button chkbox = this.checkboxes.get(j);
                        chkbox.setEnabled(false);
                        ++j;
                    }
                }
            } else if (this.isUniqueMode && checkbox != null) {
                combo.setEnabled(false);
                checkbox.setEnabled(enableNextCheckbox);
                checkbox.setSelection(false);
                enableNextCheckbox = false;
            }
            combo.addSelectionListener(this);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            combo.setLayoutData(gridData);
            ++i2;
        }
        Label label = new Label((Composite)this.shellDlg, 0);
        label.setVisible(false);
        gridData = new GridData(1808);
        gridData.horizontalSpan = this.numCols;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.compositeOKCancelButtons = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeOKCancelButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = this.numCols;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeOKCancelButtons.setLayoutData((Object)gridData);
        label = new Label(this.compositeOKCancelButtons, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonOK = new Button(this.compositeOKCancelButtons, 8);
        this.buttonOK.setText(this.msgFile.getMessage(t, "UI.GENERAL.OK"));
        this.gridDataOK = new GridData();
        this.gridDataOK.horizontalAlignment = 3;
        this.buttonOK.setLayoutData((Object)this.gridDataOK);
        this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                EditIntArrayEnumDialog.this.getCurrentValues(tr);
                EditIntArrayEnumDialog.this.isOK = true;
                EditIntArrayEnumDialog.this.shellDlg.close();
            }
        });
        this.buttonCancel = new Button(this.compositeOKCancelButtons, 8);
        this.buttonCancel.setText(this.msgFile.getMessage(t, "UI.GENERAL.CANCEL"));
        this.gridDataCancel = new GridData();
        this.gridDataCancel.horizontalAlignment = 3;
        this.buttonCancel.setLayoutData((Object)this.gridDataCancel);
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditIntArrayEnumDialog.this.isOK = false;
                EditIntArrayEnumDialog.this.shellDlg.close();
            }
        });
        int maxWidth = 0;
        Point sizeOK = this.buttonOK.computeSize(-1, -1);
        Point sizeCancel = this.buttonCancel.computeSize(-1, -1);
        if (sizeOK.x > maxWidth) {
            maxWidth = sizeOK.x;
        }
        if (sizeCancel.x > maxWidth) {
            maxWidth = sizeCancel.x;
        }
        this.gridDataOK.widthHint = maxWidth;
        this.gridDataCancel.widthHint = maxWidth;
        this.shellDlg.setDefaultButton(this.buttonOK);
        this.checkIfEnableOK(t);
        this.shellDlg.pack();
        labelPad.setVisible(false);
        UiUtils.makeShellCenteredOnParent(t, parent, this.shellDlg);
        this.shellDlg.open();
        Control first = this.shellDlg.getChildren()[0];
        first.setFocus();
        Display display = parent.getDisplay();
        while (!this.shellDlg.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.isOK;
    }

    public ArrayList getIntegerValues() {
        return this.currentIntegerValues;
    }

    public ArrayList getStringValues() {
        return this.currentStringValues;
    }

    public void widgetSelected(SelectionEvent e) {
        Trace t = Trace.getDefault();
        if (e.widget instanceof Button) {
            Button checkbox = (Button)e.widget;
            int item = (Integer)checkbox.getData();
            ExtCombo combo = this.combos.get(item);
            boolean selected = checkbox.getSelection();
            combo.setEnabled(selected);
            if (selected) {
                if (item < this.checkboxes.size() - 1) {
                    Button nextCheckbox = this.checkboxes.get(item + 1);
                    nextCheckbox.setEnabled(true);
                }
                if (item > 0) {
                    Button prevCheckbox = this.checkboxes.get(item - 1);
                    prevCheckbox.setEnabled(false);
                }
            } else {
                if (item < this.checkboxes.size() - 1) {
                    Button nextCheckbox = this.checkboxes.get(item + 1);
                    nextCheckbox.setEnabled(false);
                }
                if (item > 0) {
                    Button prevCheckbox = this.checkboxes.get(item - 1);
                    prevCheckbox.setEnabled(true);
                }
            }
        }
        this.checkIfEnableOK(t);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        Trace t = Trace.getDefault();
        this.checkIfEnableOK(t);
    }

    private void checkIfEnableOK(Trace t) {
        boolean allUnique = true;
        boolean allValid = true;
        boolean oneSelected = false;
        if (this.isUniqueMode) {
            ArrayList<ValuePair> arrayList = new ArrayList<ValuePair>();
            int i = 0;
            while (i < this.combos.size()) {
                Button checkbox = this.checkboxes.get(i);
                if (checkbox.getSelection()) {
                    oneSelected = true;
                    ExtCombo combo = this.combos.get(i);
                    int selection = combo.getSelectionIndex();
                    if (selection == -1) {
                        allValid = false;
                        break;
                    }
                    if (this.isUniqueMode) {
                        ValuePair valuePair = (ValuePair)combo.getObject(selection);
                        if (arrayList.contains(valuePair)) {
                            allUnique = false;
                            break;
                        }
                        arrayList.add(valuePair);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.combos.size()) {
                ExtCombo combo = this.combos.get(i);
                int selection = combo.getSelectionIndex();
                if (selection == -1) {
                    allValid = false;
                    break;
                }
                oneSelected = true;
                ++i;
            }
        }
        this.buttonOK.setEnabled(allUnique && allValid && oneSelected);
    }

    private void getCurrentValues(Trace t) {
        this.currentIntegerValues.clear();
        this.currentStringValues.clear();
        int i = 0;
        while (i < this.combos.size()) {
            boolean add = true;
            if (this.isUniqueMode) {
                Button chkbox = this.checkboxes.get(i);
                add = chkbox.getSelection();
            }
            if (add) {
                ExtCombo combo = this.combos.get(i);
                ValuePair valuePair = (ValuePair)combo.getObject(combo.getSelectionIndex());
                this.currentIntegerValues.add(valuePair.getValue());
                this.currentStringValues.add(valuePair.toString());
            }
            ++i;
        }
    }
}

