/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.PropertyControl;
import com.ibm.mq.explorer.ui.internal.properties.UiAttr;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class CustomPropertyPage
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/CustomPropertyPage.java";
    private UiMQObject uiMQObject = null;
    private UiDisplayGroup uiDisplayGroup = null;
    private Font fontFixedSpace = null;

    public CustomPropertyPage(Trace t, Composite parent, int style, UiMQObject uiMQObj, UiDisplayGroup uiDispGroup, boolean readonly) {
        super(parent, style);
        this.uiMQObject = uiMQObj;
        this.uiDisplayGroup = uiDispGroup;
    }

    public abstract void init(Trace var1);

    public abstract void restoreDefaults(Trace var1);

    public abstract boolean apply(Trace var1, Object var2);

    public abstract boolean isAnyControlEnabled(Trace var1);

    public abstract void changesApplied(Trace var1);

    public void addUnexpectedAttributes(Trace t, Composite page, int[] expectedAttrIds) {
        Attr attr;
        ArrayList<Attr> attrs = new ArrayList<Attr>();
        ArrayList<UiAttr> unexpectedAttrs = new ArrayList<UiAttr>();
        IDmObject dmObject = this.uiMQObject.getDmObject();
        int[] attrIds = dmObject.getAllAttributes(t);
        int i = 0;
        while (i < attrIds.length) {
            AttrType attrType;
            attr = dmObject.getAttribute(t, attrIds[i], 0);
            if (attr != null && (attrType = attr.getAttrType()).getDisplayGroup().getId() == this.uiDisplayGroup.getDisplayGroup().getId()) {
                attrs.add(attr);
            }
            ++i;
        }
        i = 0;
        while (i < attrs.size()) {
            attr = (Attr)attrs.get(i);
            int attrId = attr.getAttributeID();
            boolean expected = false;
            int j = 0;
            while (j < expectedAttrIds.length) {
                if (attrId == expectedAttrIds[j]) {
                    expected = true;
                    break;
                }
                ++j;
            }
            if (!expected) {
                UiAttr uiAttr = new UiAttr(t, attr, this.uiDisplayGroup.getDisplayGroup());
                unexpectedAttrs.add(uiAttr);
            }
            ++i;
        }
        if (!unexpectedAttrs.isEmpty()) {
            Composite composite = new Composite(page, 0);
            Layout layout = page.getLayout();
            int numCols = 1;
            if (layout instanceof GridLayout) {
                GridLayout gridLayout = (GridLayout)layout;
                numCols = gridLayout.numColumns;
            }
            GridData gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalSpan = numCols;
            composite.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 2;
            composite.setLayout((Layout)gridLayout);
            PropertyControl.sortAttributesBySequenceNumber(t, unexpectedAttrs);
            int i2 = 0;
            while (i2 < unexpectedAttrs.size()) {
                UiAttr uiAttr = unexpectedAttrs.get(i2);
                int visible = uiAttr.getAttr().getAttrType().getDisplayGroupSequence();
                if (visible != -2 && visible != -1) {
                    if (Trace.isTracing) {
                        t.data(67, "CustomPropertyPage.addUnexpectedAttributes", 900, "Adding unexpected attribute " + uiAttr.getAttr().getAttributeID() + " to page");
                    }
                    this.uiDisplayGroup.getPropertyControl().addAttributeToPage(t, composite, uiAttr);
                }
                ++i2;
            }
        }
    }

    public UiDisplayGroup getUiDisplayGroup() {
        return this.uiDisplayGroup;
    }

    public void setFixedSpaceFont(Font font) {
        this.fontFixedSpace = font;
    }

    public Font getFixedSpaceFont() {
        return this.fontFixedSpace;
    }
}

