/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChangePasswordDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/ChangePasswordDialog.java";
    private Shell shell = null;
    private Message msgFile;
    private String titleText = null;
    private Point preferredSize = null;
    private Text newPassword1 = null;
    private Text newPassword2 = null;
    private static String passwordPromptText = null;
    private static String passwordConfirmText = null;
    private String passwordValue = null;
    private int maxLength = 0;
    private static final int MIN_DIALOG_HORIZONTAL_SIZE_HINT = 400;

    public ChangePasswordDialog(Shell parent, int style, int maxLength) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.setHeadingsInfo(t);
        this.maxLength = maxLength;
    }

    private void setHeadingsInfo(Trace t) {
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
        this.titleText = this.msgFile.getMessage(t, "Ui.Change.Password.Title");
        passwordPromptText = this.msgFile.getMessage(t, "Ui.Change.Password.Prompt");
        passwordConfirmText = this.msgFile.getMessage(t, "Ui.Change.Password.Confirmation");
        this.setTitle(this.titleText);
    }

    @Override
    public String getTitle(Trace t) {
        return this.titleText;
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_ChangePasswordDialog";
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return false;
    }

    @Override
    public void packDialog(Trace t) {
    }

    private void setTitle(String titleText2) {
        this.titleText = titleText2;
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 400;
        composite.setLayoutData((Object)gridData);
        Label passwordPrompt = new Label(composite, 0);
        passwordPrompt.setText(this.msgFile.getMessage(passwordPromptText));
        gridData = new GridData();
        passwordPrompt.setLayoutData((Object)gridData);
        this.newPassword1 = new Text(composite, 0x400800);
        this.newPassword1.setTextLimit(this.maxLength);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.newPassword1.setLayoutData((Object)gridData);
        this.newPassword1.setFocus();
        Label passwordConfirm = new Label(composite, 0);
        passwordConfirm.setText(passwordConfirmText);
        gridData = new GridData();
        passwordConfirm.setLayoutData((Object)gridData);
        this.newPassword2 = new Text(composite, 0x400800);
        this.newPassword2.setTextLimit(this.maxLength);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.newPassword2.setLayoutData((Object)gridData);
        composite.pack();
        this.preferredSize = composite.getSize();
        this.checkIfEnableOK(t);
    }

    protected void checkIfEnableOK(Trace t) {
        this.enableOK(t, this.isEnableOK(t));
    }

    @Override
    public boolean okPressed(Trace t) {
        boolean passwordChangeSuccessful = false;
        if (this.getPassword1().compareTo(this.getPassword2()) == 0) {
            this.passwordValue = this.getPassword1();
            passwordChangeSuccessful = true;
        } else if (this.getPassword1().compareTo("") == 0) {
            String messageFailure = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4165");
            MessageBox.showMessageFailure(t, this.shell, messageFailure, "AMQ4165");
        } else if (this.getPassword2().compareTo("") == 0) {
            String messageFailure = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4166");
            MessageBox.showMessageFailure(t, this.shell, messageFailure, "AMQ4166");
        } else {
            String messageFailure = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4167");
            MessageBox.showMessageFailure(t, this.shell, messageFailure, "AMQ4167");
        }
        return passwordChangeSuccessful;
    }

    private String getPassword1() {
        return this.newPassword1.getText();
    }

    private String getPassword2() {
        return this.newPassword2.getText();
    }

    @Override
    public void cancelPressed(Trace t) {
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        return true;
    }

    public String getPassword() {
        return this.passwordValue;
    }
}

