/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.lang.reflect.Array;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ByteArrayEditDialog
extends Dialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/ByteArrayEditDialog.java";
    public static final int WIDTH_HINT = 400;
    public int bufferSize;
    private Shell parentShell = null;
    private Shell shellDlg = null;
    private Composite mainComposite = null;
    private Button radioText = null;
    private Button radioBytes = null;
    private Text byteArrayText = null;
    private Text byteArrayBytes = null;
    private Button buttonOK;
    private Composite compositeButtons = null;
    private boolean isOK = false;
    private String hexString = null;
    private Message msgFile = null;
    private boolean modifyingProgramatically = false;

    public ByteArrayEditDialog(Shell parent) {
        super(parent);
        this.parentShell = parent;
    }

    public boolean open(Trace t, String title, byte[] byteArray) {
        this.bufferSize = byteArray.length;
        this.hexString = this.toHexString(t, byteArray);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Status");
        this.shellDlg = new Shell(this.parentShell, 68848);
        UiPlugin.getHelpSystem().setHelp((Control)this.shellDlg, "com.ibm.mq.explorer.ui.infopop.UI_ByteArrayDialog");
        this.shellDlg.setText(this.getText());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        this.shellDlg.setLayout((Layout)gridLayout);
        this.shellDlg.setText(title);
        this.mainComposite = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.mainComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.mainComposite.setLayoutData((Object)gridData);
        this.radioText = new Button(this.mainComposite, 16);
        this.radioText.setText(this.msgFile.getMessage(t, "UI.ByteArrayControl.text"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        this.radioText.setLayoutData((Object)gridData);
        this.radioText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ByteArrayEditDialog.this.setTextMode();
            }
        });
        this.byteArrayText = new Text(this.mainComposite, 2048);
        this.byteArrayText.setText(this.toTextString(t, this.hexString));
        this.byteArrayText.setTextLimit(byteArray.length);
        gridData = new GridData(800);
        gridData.widthHint = 400;
        this.byteArrayText.setLayoutData((Object)gridData);
        this.byteArrayText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ByteArrayEditDialog.this.modifyingProgramatically) {
                    ByteArrayEditDialog.this.modifyingProgramatically = true;
                    Trace tr = Trace.getDefault();
                    String s = ByteArrayEditDialog.this.byteArrayText.getText();
                    ByteArrayEditDialog.this.hexString = ByteArrayEditDialog.this.toHexString(tr, s);
                    ByteArrayEditDialog.this.byteArrayBytes.setText(ByteArrayEditDialog.this.hexString);
                    ByteArrayEditDialog.this.buttonOK.setEnabled(true);
                    ByteArrayEditDialog.this.modifyingProgramatically = false;
                }
            }
        });
        this.radioBytes = new Button(this.mainComposite, 16);
        this.radioBytes.setText(this.msgFile.getMessage(t, "UI.ByteArrayControl.bytes"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        this.radioBytes.setLayoutData((Object)gridData);
        this.radioBytes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ByteArrayEditDialog.this.setBytesMode();
            }
        });
        this.byteArrayBytes = new Text(this.mainComposite, 2048);
        this.byteArrayBytes.setText(this.toHexString(t, byteArray));
        this.byteArrayBytes.setTextLimit(byteArray.length * 2);
        gridData = new GridData(800);
        gridData.widthHint = 400;
        this.byteArrayBytes.setLayoutData((Object)gridData);
        this.byteArrayBytes.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ByteArrayEditDialog.this.modifyingProgramatically) {
                    ByteArrayEditDialog.this.modifyingProgramatically = true;
                    Trace tr = Trace.getDefault();
                    ByteArrayEditDialog.this.hexString = ByteArrayEditDialog.this.byteArrayBytes.getText();
                    String b = ByteArrayEditDialog.this.toTextString(tr, ByteArrayEditDialog.this.hexString);
                    ByteArrayEditDialog.this.byteArrayText.setText(b);
                    int length = ByteArrayEditDialog.this.hexString.length();
                    boolean even = length % 2 == 0;
                    ByteArrayEditDialog.this.buttonOK.setEnabled(even);
                    ByteArrayEditDialog.this.modifyingProgramatically = false;
                }
            }
        });
        this.byteArrayBytes.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!e.text.matches("[0123456789abcdefABCDEF]*")) {
                    e.doit = false;
                }
            }
        });
        Composite pad = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        pad.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = 0;
        pad.setLayoutData((Object)gridData);
        this.compositeButtons = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.compositeButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(136);
        gridData.horizontalSpan = 1;
        this.compositeButtons.setLayoutData((Object)gridData);
        this.buttonOK = new Button(this.compositeButtons, 8);
        this.buttonOK.setText(this.msgFile.getMessage(t, "UI.GENERAL.OK"));
        gridData = new GridData(784);
        this.buttonOK.setLayoutData((Object)gridData);
        this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ByteArrayEditDialog.this.isOK = true;
                ByteArrayEditDialog.this.shellDlg.close();
            }
        });
        Button buttonCancel = new Button(this.compositeButtons, 8);
        buttonCancel.setText(this.msgFile.getMessage(t, "UI.GENERAL.CLOSE"));
        gridData = new GridData(784);
        buttonCancel.setLayoutData((Object)gridData);
        buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ByteArrayEditDialog.this.shellDlg.close();
            }
        });
        this.setInitialMode(t, byteArray);
        this.shellDlg.setDefaultButton(this.buttonOK);
        this.shellDlg.pack();
        this.shellDlg.layout();
        this.shellDlg.open();
        Display display = this.shellDlg.getDisplay();
        while (!this.shellDlg.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.isOK;
    }

    private void setTextMode() {
        this.radioText.setSelection(true);
        this.radioBytes.setSelection(false);
        this.byteArrayText.setEnabled(true);
        this.byteArrayBytes.setEnabled(false);
        this.byteArrayText.setFocus();
    }

    private void setBytesMode() {
        this.radioText.setSelection(false);
        this.radioBytes.setSelection(true);
        this.byteArrayText.setEnabled(false);
        this.byteArrayBytes.setEnabled(true);
        this.byteArrayBytes.setFocus();
    }

    private String toHexString(Trace t, String string) {
        StringBuffer buffer = new StringBuffer();
        int end = -1;
        int i = 0;
        while (i < string.length()) {
            char ch = string.charAt(i);
            buffer.append(Integer.toHexString(0xF & ch >> 4));
            buffer.append(Integer.toHexString(0xF & ch));
            if (ch != '\u0000') {
                end = i;
            }
            ++i;
        }
        String result = buffer.substring(0, (end + 1) * 2).toString();
        return result;
    }

    private String toHexString(Trace t, byte[] array) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < array.length && array[i] != 0) {
            byte b = array[i];
            String currentCharacter = Integer.toString((b & 0xFF) + 256, 16).substring(1);
            result.append(currentCharacter);
            ++i;
        }
        return result.toString();
    }

    private String toTextString(Trace t, String string) {
        int size = string.length() / 2;
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < size) {
            String hex = string.substring(2 * i, 2 * i + 2);
            int msd = Character.digit(hex.charAt(0), 16);
            int lsd = Character.digit(hex.charAt(1), 16);
            int b = msd << 4 | lsd;
            result.append((char)b);
            ++i;
        }
        return result.toString();
    }

    private byte[] toByteArray(Trace t, String string) {
        byte[] array = (byte[])Array.newInstance(Byte.TYPE, this.bufferSize);
        int size = string.length() / 2;
        int i = 0;
        while (i < size) {
            String hex = string.substring(2 * i, 2 * i + 2);
            int msd = Character.digit(hex.charAt(0), 16);
            int lsd = Character.digit(hex.charAt(1), 16);
            int b = msd << 4 | lsd;
            array[i] = (byte)b;
            ++i;
        }
        i = size;
        while (i < this.bufferSize) {
            array[i] = 0;
            ++i;
        }
        return array;
    }

    private void setInitialMode(Trace t, byte[] raw) {
        int firstNonPrintable = raw.length;
        int lastNonZero = -1;
        int i = 0;
        while (i < raw.length) {
            byte ch = raw[i];
            char c = (char)ch;
            if (!this.isPrintableAscii(c) && firstNonPrintable == raw.length) {
                firstNonPrintable = i;
            }
            if (c != '\u0000') {
                lastNonZero = i;
            }
            ++i;
        }
        if (firstNonPrintable > lastNonZero) {
            this.setTextMode();
        } else {
            this.setBytesMode();
        }
    }

    private boolean isPrintableAscii(char c) {
        return Character.isLetterOrDigit(c);
    }

    protected byte[] showEditDialog(Trace t, String title, byte[] byteArray) {
        byte[] result = null;
        boolean ok = this.open(t, title, byteArray);
        if (ok) {
            result = this.toByteArray(t, this.hexString);
        }
        return result;
    }
}

