/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrByteArray;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeByteArray;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.ByteArrayEditDialog;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class ByteArrayAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/ByteArrayAttributeControl.java";
    private byte[] byteArray = null;
    private Text textCtrl = null;
    private Button buttonSelect = null;
    private boolean enabled = true;
    private Object originalValue = null;

    public ByteArrayAttributeControl(Trace t, Composite parent, int style, AttrType attrType, Object currentValue) {
        super(t, parent, style, attrType, currentValue);
        this.originalValue = currentValue;
        ByteBuffer bb = (ByteBuffer)currentValue;
        int limit = bb.limit();
        this.byteArray = (byte[])Array.newInstance(Byte.TYPE, limit);
        bb.rewind();
        int i = 0;
        while (i < limit) {
            this.byteArray[i] = bb.get();
            ++i;
        }
        boolean isSelectButton = true;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.textCtrl = new Text((Composite)this, 2818);
        this.textCtrl.setText(this.toString());
        UiUtils.makeTextControlReadOnly(t, this.textCtrl, true);
        Menu blankMenu = new Menu((Control)this.textCtrl);
        this.textCtrl.setMenu(blankMenu);
        this.textCtrl.setFont(JFaceResources.getTextFont());
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 100;
        this.textCtrl.setLayoutData((Object)gridData);
        this.textCtrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                ByteArrayAttributeControl.this.valueChanged(tr);
            }
        });
        if (isSelectButton) {
            this.buttonSelect = new Button((Composite)this, 8);
            Message msgFile = UiPlugin.getUIMessages(t, "KEY_NewObject");
            this.buttonSelect.setText(msgFile.getMessage(t, "UI.GENERAL.EDIT"));
            gridData = new GridData();
            gridData.horizontalAlignment = 3;
            gridData.horizontalSpan = 1;
            this.buttonSelect.setLayoutData((Object)gridData);
            this.buttonSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Trace tr = Trace.getDefault();
                    ByteArrayAttributeControl.this.showEditDialog(tr);
                }
            });
        }
    }

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    @Override
    public String toString() {
        AttrTypeByteArray attrType;
        Trace t = Trace.getDefault();
        String value = "";
        if (this.byteArray != null && (attrType = (AttrTypeByteArray)this.getAttrType()) != null) {
            AttrByteArray at = new AttrByteArray(t, 0, 0, this.byteArray, attrType, null);
            value = at.toFormattedString(t);
        }
        return value;
    }

    @Override
    public Object getValue(Trace t) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.byteArray.length);
        byteBuffer.put(this.byteArray);
        return byteBuffer;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.buttonSelect.setEnabled(b);
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean isAccepted = false;
        if (value instanceof ByteBuffer) {
            ByteBuffer bb = (ByteBuffer)value;
            int limit = bb.limit();
            this.byteArray = (byte[])Array.newInstance(Byte.TYPE, limit);
            bb.rewind();
            int i = 0;
            while (i < limit) {
                this.byteArray[i] = bb.get();
                ++i;
            }
            isAccepted = true;
        }
        return isAccepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        Object currentValue = this.getValue(t);
        boolean changed = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return changed;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }

    protected void showEditDialog(Trace t) {
        String title;
        ByteArrayEditDialog dialog = new ByteArrayEditDialog(this.getShell());
        byte[] result = dialog.showEditDialog(t, title = this.getAttrType().getPropTitle(), this.byteArray);
        if (result != null) {
            this.byteArray = result;
            this.textCtrl.setText(this.toString());
        }
        this.buttonSelect.setFocus();
    }
}

