/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BooleanAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/BooleanAttributeControl.java";
    private Button checkbox = null;
    private boolean enabled = true;
    private Object originalValue = null;

    public BooleanAttributeControl(Trace t, Composite parent, int style, AttrType attrType, Object currentValue) {
        super(t, parent, style, attrType, currentValue);
        this.originalValue = currentValue;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.checkbox = new Button((Composite)this, 32);
        GridData gridData = new GridData(768);
        this.checkbox.setLayoutData((Object)gridData);
        Text text = new Text((Composite)this, 2048);
        text.setVisible(false);
        gridData = new GridData(768);
        text.setLayoutData((Object)gridData);
        boolean val = (Boolean)currentValue;
        this.checkbox.setSelection(val);
    }

    @Override
    public String toString() {
        String value = "";
        if (this.checkbox != null) {
            value = Boolean.toString(this.checkbox.getSelection());
        }
        return value;
    }

    @Override
    public Object getValue(Trace t) {
        Boolean value = this.checkbox.getSelection();
        return value;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.checkbox.setEnabled(this.enabled);
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        if (value instanceof Boolean) {
            this.checkbox.setSelection(((Boolean)value).booleanValue());
        } else {
            String strValue = value.toString();
            Boolean bValue = Boolean.valueOf(strValue);
            this.checkbox.setSelection(bValue.booleanValue());
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        Object currentValue = this.getValue(t);
        boolean changed = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return changed;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }
}

