/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class AttributeControl
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/AttributeControl.java";
    private Attr attr = null;
    private AttrType attrType = null;
    private String labelText = null;
    private Label associatedLabel = null;
    public static final int VALUE_TYPES_NONE = 0;
    public static final int VALUE_TYPES_STRING_ONLY = 1;
    public static final int VALUE_TYPES_INT_ONLY = 2;
    public static final int VALUE_TYPES_STRING_AND_INT = 3;
    public static final int VALUE_TYPES_LONG_ONLY = 4;
    protected Hashtable<IAttributeModifiedListener, Integer> modifyListeners = null;
    protected boolean valid = true;
    protected Message msgFile = null;
    private ControlDecoration mandatoryDecoration = null;

    public AttributeControl(Trace t, Composite parent, int style, AttrType attType, Object curValue) {
        super(parent, style);
        this.attrType = attType;
        this.modifyListeners = new Hashtable();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
    }

    public void setAttr(Attr att) {
        this.attr = att;
    }

    public Attr getAttr() {
        return this.attr;
    }

    public AttrType getAttrType() {
        return this.attrType;
    }

    public void setAssociatedLabel(Label label) {
        this.associatedLabel = label;
        if (this.associatedLabel != null) {
            this.labelText = this.associatedLabel.getText();
        }
    }

    public Label getAssociatedLabel() {
        return this.associatedLabel;
    }

    public abstract String toString();

    public abstract Object getValue(Trace var1);

    public abstract void setEnabled(boolean var1);

    public abstract boolean isEnabled();

    public abstract boolean setValue(Trace var1, Object var2);

    public abstract boolean isChanged(Trace var1);

    public abstract void valueApplied(Trace var1);

    public void addModifyListener(IAttributeModifiedListener listener, Integer userType) {
        this.modifyListeners.put(listener, userType);
    }

    public void removeModifyListener(IAttributeModifiedListener listener) {
        this.modifyListeners.remove(listener);
    }

    public static int compareObjectValues(Trace t, Object o1, Object o2) {
        int retValue = 0;
        if (o1 instanceof String && o2 instanceof String) {
            String string1 = (String)o1;
            String string2 = (String)o2;
            retValue = string1.compareTo(string2);
        } else if (o1 instanceof Integer && o2 instanceof Integer) {
            Integer integer1 = (Integer)o1;
            Integer integer2 = (Integer)o2;
            retValue = integer1.compareTo(integer2);
        } else if (o1 instanceof Long && o2 instanceof Long) {
            Long long1 = (Long)o1;
            Long long2 = (Long)o2;
            retValue = long1.compareTo(long2);
        } else if (o1 instanceof Boolean && o2 instanceof Boolean) {
            Boolean bool1 = (Boolean)o1;
            Boolean bool2 = (Boolean)o2;
            retValue = bool1.equals(bool2) ? 0 : 1;
        } else if (o1 instanceof ByteBuffer && o2 instanceof ByteBuffer) {
            ByteBuffer byteBuffer1 = (ByteBuffer)o1;
            ByteBuffer byteBuffer2 = (ByteBuffer)o2;
            byteBuffer1.rewind();
            byteBuffer2.rewind();
            retValue = byteBuffer1.equals(byteBuffer2) ? 0 : 1;
        } else {
            if (Trace.isTracing) {
                t.data(67, "AttributeControl.compareObjectValues", 900, "Warning: Unknown/mismatched object types");
            }
            t.FFST(67, "AttributeControl.compareObjectValues", 0, 50024, 0, 0, o1.getClass().getName(), o2.getClass().getName(), null);
        }
        return retValue;
    }

    public abstract void setAdditionalValidCharacters(Trace var1, String var2);

    public String getLabelText() {
        return this.labelText;
    }

    public boolean getEnabled() {
        return this.isEnabled();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void addMandatoryDecoration(Trace t) {
    }

    public ControlDecoration getMandatoryDecoration() {
        return this.mandatoryDecoration;
    }

    protected void createControlDecoration(Trace t, Control control) {
        this.mandatoryDecoration = UiUtils.createControlDecoration(t, control);
    }
}

