/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthWMQNameListItem;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeStringArray;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddStringArrayDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/AddStringArrayDialog.java";
    private static final int NUM_COLS = 1;
    private Text textCtrl = null;
    private static final int TEXT_MAX_WIDTH = 500;
    private String newString = null;
    private int maxLength = 48;
    private Message msgFile = null;
    private boolean valid = true;
    private Composite compMsg;
    private Boolean isAdd;
    private String value;
    private final AttrTypeStringArray attrType;

    public AddStringArrayDialog(Trace t, Shell parent, boolean isAdd, String value, AttrTypeStringArray attrType, int maxlen) {
        super(parent);
        this.isAdd = isAdd;
        this.value = value;
        this.attrType = attrType;
        this.maxLength = maxlen;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Properties");
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Trace t = Trace.getDefault();
        String title = "";
        if (this.isAdd.booleanValue()) {
            title = Message.format((String)this.msgFile.getMessage(t, "UI.PROP.Dialog.AddStringArrayTitleAdd"), (String)this.attrType.getDisplayTitle());
            UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.ui.infopop.UI_StringArrayAddStringDialog");
        } else {
            title = Message.format((String)this.msgFile.getMessage(t, "UI.PROP.Dialog.AddStringArrayTitleEdit"), (String)this.attrType.getDisplayTitle());
            UiPlugin.getHelpSystem().setHelp((Control)newShell, "com.ibm.mq.explorer.ui.infopop.UI_StringArrayEditStringDialog");
        }
        newShell.setText(title);
        Image image = this.getParentShell().getImage();
        if (image == null) {
            image = Icons.get(Icons.iconkeyExplorerSmall);
        }
        newShell.setImage(image);
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.compMsg = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = false;
        this.compMsg.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        this.compMsg.setLayoutData((Object)gridData);
        this.compMsg.setVisible(false);
        Label labelIcon = new Label(this.compMsg, 1);
        labelIcon.setImage(Dialog.getImage((String)"dialog_message_error_image"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        labelIcon.setLayoutData((Object)gridData);
        Label labelMsg = new Label(this.compMsg, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        labelMsg.setLayoutData((Object)gridData);
        labelMsg.setText(this.msgFile.getMessage("UI.GENERAL.NAME.INVALID.CHARS.OR.LENGTH"));
        this.textCtrl = new Text(composite, 2048);
        if (this.attrType.getMaxLen() > 0) {
            this.textCtrl.setTextLimit(this.attrType.getMaxLen());
        }
        if (this.maxLength > 0) {
            this.textCtrl.setTextLimit(this.maxLength);
        }
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        this.textCtrl.setLayoutData((Object)gridData);
        Label label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        label.setLayoutData((Object)gridData);
        this.textCtrl.setFocus();
        if (!this.isAdd.booleanValue() && this.value != null) {
            this.textCtrl.setText(this.value);
            this.textCtrl.setSelection(this.value.length());
            Point size = this.textCtrl.computeSize(-1, -1);
            if (size.x > 500) {
                gridData = (GridData)this.textCtrl.getLayoutData();
                gridData.widthHint = 500;
            }
        } else {
            this.textCtrl.setText("");
        }
        if (this.attrType instanceof AttrTypeFixedLengthWMQNameListItem) {
            this.textCtrl.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    Trace tr = Trace.getDefault();
                    AddStringArrayDialog.this.valid = StringValidation.verifyMQObjectName(tr, e);
                }
            });
        }
        this.textCtrl.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (AddStringArrayDialog.this.attrType.getRegExp() != null) {
                    AddStringArrayDialog.this.valid = StringValidation.verifyUsingRegularExpression(Trace.getDefault(), AddStringArrayDialog.this.textCtrl.getText(), e, AddStringArrayDialog.this.attrType.getRegExp());
                }
                if (AddStringArrayDialog.this.valid && AddStringArrayDialog.this.attrType.getMinLen() > 0) {
                    int lengthToVerify = e.start + e.text.length() + (AddStringArrayDialog.this.textCtrl.getText().length() - e.end);
                    AddStringArrayDialog.this.valid = lengthToVerify >= AddStringArrayDialog.this.attrType.getMinLen();
                }
            }
        });
        this.textCtrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                AddStringArrayDialog.this.checkIfEnableOK(tr);
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.checkIfEnableOK(Trace.getDefault());
    }

    protected void okPressed() {
        this.newString = this.textCtrl.getText();
        super.okPressed();
    }

    private void checkIfEnableOK(Trace t) {
        if (this.compMsg != null) {
            this.compMsg.setVisible(!this.valid);
        }
        String text = this.textCtrl.getText();
        boolean enableOK = this.valid && text.length() > 0;
        Button b = this.getButton(0);
        if (b != null) {
            b.setEnabled(enableOK);
        }
    }

    public String getStringValue() {
        return this.newString;
    }
}

