/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeRange;
import com.ibm.mq.explorer.ui.internal.controls.CustomSpinner;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import java.util.Enumeration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public abstract class AbstractNumericAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/AbstractNumericAttributeControl.java";
    protected Composite spinner = null;
    private boolean enabled = true;
    private Object originalValue = null;

    public AbstractNumericAttributeControl(Trace t, Composite parent, int style, AttrType attrType, Object currentValue) {
        super(t, parent, style, attrType, currentValue);
        GridData gridData;
        this.originalValue = currentValue;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        if (attrType instanceof AttrTypeLong || attrType instanceof AttrTypeLongRange) {
            this.spinner = new CustomSpinner(this, 0);
            gridData = new GridData(768);
            this.spinner.setLayoutData((Object)gridData);
        } else {
            this.spinner = new Spinner((Composite)this, 2048);
            gridData = new GridData(768);
            this.spinner.setLayoutData((Object)gridData);
        }
        this.setLimits();
        if (attrType instanceof AttrTypeRange) {
            AttrTypeRange attrTypeRange = (AttrTypeRange)attrType;
            ((Spinner)this.spinner).setMaximum(attrTypeRange.getMaximumValue());
            ((Spinner)this.spinner).setMinimum(attrTypeRange.getMinimumValue());
        } else if (attrType instanceof AttrTypeLongRange) {
            AttrTypeLongRange attrTypeLongRange = (AttrTypeLongRange)attrType;
            ((CustomSpinner)this.spinner).setLongMaximum(attrTypeLongRange.getMaximumValue());
            ((CustomSpinner)this.spinner).setLongMinimum(attrTypeLongRange.getMinimumValue());
        }
        Object defval = attrType.getDefaultValue(t);
        long val = 0L;
        if (defval != null) {
            try {
                val = Long.parseLong(attrType.getDefaultValue(t).toString());
            }
            catch (NumberFormatException numberFormatException) {
                t.FFST(67, "AbstractNumericAttributeControl.AbstractNumericAttributeControl", 10, 50999, "Failed to parse default value, using minimum instead for attrType: " + attrType);
            }
        }
        try {
            val = Long.parseLong(currentValue.toString());
        }
        catch (NumberFormatException numberFormatException) {
            t.FFST(67, "AbstractNumericAttributeControl.AbstractNumericAttributeControl", 20, 50006, "Current value of " + attrType.getDisplayTitle() + " is outside valid INT range, setting default");
        }
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Trace tr = Trace.getDefault();
                AbstractNumericAttributeControl.this.valueChanged(tr);
            }
        };
        if (this.spinner instanceof CustomSpinner) {
            ((CustomSpinner)this.spinner).setLongSelection(t, val);
            ((CustomSpinner)this.spinner).addModifyListener(listener);
        } else {
            ((Spinner)this.spinner).setSelection((int)val);
            ((Spinner)this.spinner).addModifyListener(listener);
        }
    }

    public abstract void setLimits();

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    @Override
    public String toString() {
        String str = "";
        if (this.spinner != null) {
            str = this.spinner instanceof CustomSpinner ? Long.toString(((CustomSpinner)this.spinner).getLongSelection()) : Integer.toString(((Spinner)this.spinner).getSelection());
        }
        return str;
    }

    @Override
    public abstract Object getValue(Trace var1);

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.spinner.setEnabled(this.enabled);
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = true;
        String strValue = "";
        if (value instanceof String) {
            try {
                Integer.parseInt((String)value, 0);
                strValue = (String)value;
            }
            catch (NumberFormatException numberFormatException) {
                accepted = false;
            }
        } else {
            strValue = value.toString();
        }
        if (accepted) {
            if (this.spinner instanceof CustomSpinner) {
                ((CustomSpinner)this.spinner).setLongSelection(t, Long.parseLong(strValue));
            } else {
                ((Spinner)this.spinner).setSelection(Integer.parseInt(strValue));
            }
        }
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        Object currentValue = this.getValue(t);
        boolean changed = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return changed;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }
}

