/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeEnumRange;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLong;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeLongEnumRange;
import com.ibm.mq.explorer.ui.internal.controls.CustomSpinner;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.properties.NumberValuePair;
import java.util.Enumeration;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public abstract class AbstractEnumRangeAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/AbstractEnumRangeAttributeControl.java";
    protected Button radioPredefined = null;
    protected Button radioUserdefined = null;
    protected ExtCombo combo = null;
    protected Composite spinner = null;
    private AbstractAttrTypeEnumRange attrTypeEnumRange = null;
    private boolean enabled = true;
    protected Object originalValue = null;

    public AbstractEnumRangeAttributeControl(Trace t, Composite parent, int style, AttrType attrType, Object currentValue) {
        super(t, parent, style, attrType, currentValue);
        this.attrTypeEnumRange = (AbstractAttrTypeEnumRange)attrType;
        this.originalValue = currentValue;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.setLayout((Layout)gridLayout);
        this.radioPredefined = new Button((Composite)this, 16);
        GridData gridData = new GridData();
        this.radioPredefined.setLayoutData((Object)gridData);
        this.radioPredefined.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                if (AbstractEnumRangeAttributeControl.this.radioPredefined.getSelection()) {
                    AbstractEnumRangeAttributeControl.this.predefinedSelected(tr);
                    AbstractEnumRangeAttributeControl.this.valueChanged(tr);
                }
            }
        });
        this.radioPredefined.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String label = AbstractEnumRangeAttributeControl.this.getAssociatedLabel().getText();
                NumberValuePair vp = (NumberValuePair)AbstractEnumRangeAttributeControl.this.combo.getObject(AbstractEnumRangeAttributeControl.this.combo.getSelectionIndex());
                if (vp != null) {
                    label = String.valueOf(label) + " " + vp.toString();
                }
                e.result = label;
            }
        });
        this.combo = new ExtCombo(this, 2060);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.combo.setLayoutData(gridData);
        NumberValuePair selectedObject = this.addEnumeratesToCombo(t, this.attrTypeEnumRange, currentValue);
        if (selectedObject == null && this.combo.getItemCount() > 0) {
            this.combo.select(0);
        }
        this.combo.sortByNumericValue();
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                AbstractEnumRangeAttributeControl.this.valueChanged(tr);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                AbstractEnumRangeAttributeControl.this.valueChanged(tr);
            }
        });
        this.radioUserdefined = new Button((Composite)this, 16);
        gridData = new GridData();
        this.radioUserdefined.setLayoutData((Object)gridData);
        this.radioUserdefined.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                if (AbstractEnumRangeAttributeControl.this.radioUserdefined.getSelection()) {
                    AbstractEnumRangeAttributeControl.this.userdefinedSelected(tr);
                    AbstractEnumRangeAttributeControl.this.valueChanged(tr);
                }
            }
        });
        this.radioUserdefined.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String label = AbstractEnumRangeAttributeControl.this.getAssociatedLabel().getText();
                e.result = AbstractEnumRangeAttributeControl.this.spinner instanceof CustomSpinner ? String.valueOf(label) + " " + Long.valueOf(((CustomSpinner)AbstractEnumRangeAttributeControl.this.spinner).getLongSelection()).toString() : String.valueOf(label) + " " + Long.valueOf(((Spinner)AbstractEnumRangeAttributeControl.this.spinner).getSelection()).toString();
            }
        });
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                AbstractEnumRangeAttributeControl.this.valueChanged(tr);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                AbstractEnumRangeAttributeControl.this.valueChanged(tr);
            }
        };
        if (attrType instanceof AttrTypeLong || attrType instanceof AttrTypeLongEnum || attrType instanceof AttrTypeLongEnumRange) {
            this.spinner = new CustomSpinner(this, 0);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            this.spinner.setLayoutData((Object)gridData);
            CustomSpinner customSpinner = (CustomSpinner)this.spinner;
            customSpinner.setLongMaximum(this.attrTypeEnumRange.getMaximumNumberValue().longValue());
            customSpinner.setLongMinimum(this.attrTypeEnumRange.getMinimumNumberValue().longValue());
            customSpinner.setLongSelection(t, this.attrTypeEnumRange.getMinimumNumberValue().longValue());
            customSpinner.addSelectionListener(listener);
        } else {
            this.spinner = new Spinner((Composite)this, 2048);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            this.spinner.setLayoutData((Object)gridData);
            Spinner nativeSpinner = (Spinner)this.spinner;
            nativeSpinner.setMaximum(this.attrTypeEnumRange.getMaximumNumberValue().intValue());
            nativeSpinner.setMinimum(this.attrTypeEnumRange.getMinimumNumberValue().intValue());
            nativeSpinner.setSelection(this.attrTypeEnumRange.getMinimumNumberValue().intValue());
            nativeSpinner.addSelectionListener(listener);
        }
        if (selectedObject != null) {
            this.combo.select(this.combo.indexOfObject(selectedObject));
            this.radioPredefined.setSelection(true);
            this.predefinedSelected(t);
        } else {
            if (this.spinner instanceof CustomSpinner) {
                ((CustomSpinner)this.spinner).setLongSelection(t, ((Number)this.originalValue).longValue());
            } else {
                ((Spinner)this.spinner).setSelection(((Number)this.originalValue).intValue());
            }
            this.radioUserdefined.setSelection(true);
            this.userdefinedSelected(t);
        }
    }

    public abstract NumberValuePair addEnumeratesToCombo(Trace var1, AbstractAttrTypeEnumRange var2, Object var3);

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    protected void predefinedSelected(Trace t) {
        this.combo.setEnabled(true);
        this.spinner.setEnabled(false);
    }

    protected void userdefinedSelected(Trace t) {
        this.combo.setEnabled(false);
        this.spinner.setEnabled(true);
    }

    @Override
    public String toString() {
        String value = "";
        Object obj = this.getValue(Trace.getDefault());
        if (obj != null) {
            value = obj.toString();
        }
        return value;
    }

    public Object getNumberValue(Trace t) {
        Number numberValue = null;
        String stringValue = null;
        if (this.radioPredefined.getSelection()) {
            NumberValuePair vp = (NumberValuePair)this.combo.getObject(this.combo.getSelectionIndex());
            if (vp != null) {
                stringValue = vp.toString();
                Number[] enumIds = this.attrTypeEnumRange.getEnumerationNumberIds(t);
                int i = 0;
                while (i < enumIds.length) {
                    String enumName = this.attrTypeEnumRange.getEnumeratedValue(t, enumIds[i]);
                    if (enumName.compareTo(stringValue) == 0) {
                        numberValue = enumIds[i];
                        break;
                    }
                    ++i;
                }
            }
            if (numberValue == null) {
                if (Trace.isTracing) {
                    if (stringValue != null) {
                        t.data(67, "AbstractEnumRangeAttributeControl.getNumberValue", 900, "Error: Current value '" + stringValue + "' does not match any enumerate values");
                    } else {
                        t.data(67, "AbstractEnumRangeAttributeControl.getNumberValue", 900, "Error: Current value does not match any enumerate values");
                    }
                }
                numberValue = (Number)this.originalValue;
            }
        } else if (this.spinner != null) {
            numberValue = this.spinner instanceof CustomSpinner ? Long.valueOf(((CustomSpinner)this.spinner).getLongSelection()) : Long.valueOf(((Spinner)this.spinner).getSelection());
        }
        return numberValue;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.radioPredefined.setEnabled(this.enabled);
        if (this.radioPredefined.getSelection()) {
            this.combo.setEnabled(this.enabled);
        } else {
            this.combo.setEnabled(false);
        }
        this.radioUserdefined.setEnabled(this.enabled);
        if (this.radioUserdefined.getSelection()) {
            this.spinner.setEnabled(this.enabled);
        } else {
            this.spinner.setEnabled(false);
        }
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        boolean accepted = false;
        Integer intValue = null;
        intValue = value instanceof Integer ? (Integer)value : Integer.valueOf(-1);
        Number[] enumIds = this.attrTypeEnumRange.getEnumerationNumberIds(t);
        int i = 0;
        while (i < enumIds.length) {
            if (AttributeControl.compareObjectValues(t, value, enumIds[i]) == 0) {
                accepted = true;
                String name = this.attrTypeEnumRange.getEnumeratedValue(t, enumIds[i]);
                int index = this.combo.indexOfIgnoreCase(name);
                this.radioPredefined.setSelection(true);
                this.radioUserdefined.setSelection(false);
                this.combo.select(index);
            }
            ++i;
        }
        if (!accepted && intValue >= this.attrTypeEnumRange.getMinimumNumberValue().intValue() && intValue <= this.attrTypeEnumRange.getMaximumNumberValue().intValue()) {
            accepted = true;
            this.radioUserdefined.setSelection(true);
            this.radioPredefined.setSelection(false);
            if (this.spinner instanceof CustomSpinner) {
                ((CustomSpinner)this.spinner).setSelection(t, intValue);
            } else {
                ((Spinner)this.spinner).setSelection(intValue.intValue());
            }
        }
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        boolean changed = false;
        Object currentValue = this.getValue(t);
        changed = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return changed;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    public boolean isPredefined(Trace t) {
        return this.radioPredefined.getSelection();
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }
}

