/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.properties;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.ui.internal.controls.ExtCombo;
import com.ibm.mq.explorer.ui.internal.properties.AttributeControl;
import com.ibm.mq.explorer.ui.internal.properties.AttributeModifiedEvent;
import com.ibm.mq.explorer.ui.internal.properties.IAttributeModifiedListener;
import com.ibm.mq.explorer.ui.internal.properties.NumberValuePair;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractEnumAttributeControl
extends AttributeControl {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/properties/AbstractEnumAttributeControl.java";
    protected ExtCombo combo = null;
    private boolean enabled = true;
    private AbstractAttrTypeEnum attrTypeEnum = null;
    private Object originalValue = null;

    public AbstractEnumAttributeControl(Trace t, Composite parent, int style, AttrType attrType, Object currentValue) {
        super(t, parent, style, attrType, currentValue);
        this.attrTypeEnum = (AbstractAttrTypeEnum)attrType;
        this.originalValue = currentValue;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        this.setLayout((Layout)gridLayout);
        this.combo = new ExtCombo(this, 2060);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.combo.setLayoutData(gridData);
        this.addEnumeratesToCombo(t, this.attrTypeEnum, currentValue);
        this.combo.sortByNumericValue();
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                AbstractEnumAttributeControl.this.valueChanged(tr);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                Trace tr = Trace.getDefault();
                AbstractEnumAttributeControl.this.valueChanged(tr);
            }
        });
    }

    public abstract void addEnumeratesToCombo(Trace var1, AbstractAttrTypeEnum var2, Object var3);

    private void valueChanged(Trace t) {
        if (!this.modifyListeners.isEmpty()) {
            AttributeModifiedEvent attrModifiedEvent = new AttributeModifiedEvent((Object)this, this.getValue(t));
            Enumeration keys = this.modifyListeners.keys();
            while (keys.hasMoreElements()) {
                IAttributeModifiedListener listener = (IAttributeModifiedListener)keys.nextElement();
                attrModifiedEvent.setUserType((Integer)this.modifyListeners.get(listener));
                listener.attrModified(attrModifiedEvent);
            }
        }
    }

    @Override
    public String toString() {
        String value = "";
        if (this.combo != null) {
            value = this.combo.getText();
        }
        return value;
    }

    public Object getNumberValue(Trace t) {
        Number intValue = null;
        String stringValue = this.toString();
        Number[] enumIds = this.attrTypeEnum.getEnumerationNumberIds(t);
        int i = 0;
        while (i < enumIds.length) {
            String enumName = this.attrTypeEnum.getEnumeratedValue(t, enumIds[i]);
            if (enumName.compareTo(stringValue) == 0) {
                intValue = enumIds[i];
                break;
            }
            ++i;
        }
        if (intValue == null) {
            Object obj;
            if (Trace.isTracing) {
                t.data(67, "AbstractEnumAttributeControl.getNumberValue", 900, "Error: Current value '" + stringValue + "' does not match any enumerate values");
            }
            intValue = (obj = this.originalValue) instanceof Integer ? (Integer)obj : Integer.valueOf(0);
        }
        return intValue;
    }

    @Override
    public void setEnabled(boolean b) {
        this.enabled = b;
        this.combo.setEnabled(this.enabled);
    }

    @Override
    public boolean setValue(Trace t, Object value) {
        String strValue = "";
        if (value instanceof String) {
            strValue = (String)value;
        } else if (value instanceof Integer) {
            Integer intValue = (Integer)value;
            strValue = this.attrTypeEnum.getEnumeratedValue(t, (Number)intValue);
        }
        boolean accepted = false;
        int index = this.combo.indexOfIgnoreCase(strValue);
        if (index != -1) {
            accepted = true;
            this.combo.select(index);
        }
        return accepted;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isChanged(Trace t) {
        boolean result = false;
        Object currentValue = this.getValue(t);
        result = AttributeControl.compareObjectValues(t, currentValue, this.originalValue) != 0;
        return result;
    }

    @Override
    public void valueApplied(Trace t) {
        this.originalValue = this.getValue(t);
    }

    @Override
    public void setAdditionalValidCharacters(Trace t, String addValidChars) {
    }

    public void setValidSelections(Trace t, Number[] validValues) {
        ArrayList<NumberValuePair> invalidValues = new ArrayList<NumberValuePair>();
        int count = this.combo.getItemCount();
        int i = 0;
        while (i < count) {
            NumberValuePair numberValuePair = (NumberValuePair)this.combo.getObject(i);
            Number value = numberValuePair.getValue();
            boolean isValid = false;
            int j = 0;
            while (j < validValues.length) {
                if (value.intValue() == validValues[j].intValue()) {
                    isValid = true;
                    break;
                }
                ++j;
            }
            if (!isValid) {
                invalidValues.add(numberValuePair);
            }
            ++i;
        }
        Iterator iterator = invalidValues.iterator();
        while (iterator.hasNext()) {
            this.combo.remove(iterator.next());
        }
    }
}

