/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.preferences;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableColumnManager;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableViewer;
import com.ibm.mq.explorer.ui.internal.controls.ExtViewerSorter;
import com.ibm.mq.explorer.ui.internal.plugins.PluginRegistrationManager;
import com.ibm.mq.explorer.ui.internal.plugins.RegisteredPlugin;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferencePageEnablePlugins
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/preferences/PreferencePageEnablePlugins.java";
    private static final int NUM_COLS = 4;
    private TableColumn[] tableColumns = null;
    private String[] columnTitles = null;
    private static final int COLUMN_NAME = 0;
    private static final int COLUMN_VENDOR = 1;
    private static final int COLUMN_DESC = 2;
    private static final int COLUMN_ID = 3;
    private Composite composite = null;
    private ExtTableViewer extTableViewer = null;
    private PluginRegistrationManager pluginRegistrationManager = null;
    private boolean isCurrentSettingsLoaded = false;
    private EnablePluginsContentProvider contentProvider = null;
    private ExtTableColumnManager columnManager = null;
    EnablePluginsLabelProvider labelProvider = null;

    protected Control createContents(Composite parent) {
        Trace t = Trace.getDefault();
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_Preferences");
        this.composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.composite.setLayoutData((Object)gridData);
        UiPlugin.getHelpSystem().setHelp((Control)this.composite, "com.ibm.mq.explorer.ui.infopop.UI_PreferencePageEnablePlugins");
        UiPlugin.getHelpSystem().setHelp(this.getControl(), "com.ibm.mq.explorer.ui.infopop.UI_PreferencePageEnablePlugins");
        this.columnTitles = new String[4];
        this.columnTitles[0] = msgFile.getMessage(t, "UI.PREF.Plugin.Name");
        this.columnTitles[1] = msgFile.getMessage(t, "UI.PREF.Plugin.Vendor");
        this.columnTitles[2] = msgFile.getMessage(t, "UI.PREF.Plugin.Desc");
        this.columnTitles[3] = msgFile.getMessage(t, "UI.PREF.Plugin.ID");
        this.extTableViewer = new ExtTableViewer(this.composite, 67620, 2);
        Table table = this.extTableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.tableColumns = new TableColumn[4];
        int i = 0;
        while (i < 4) {
            this.tableColumns[i] = new TableColumn(table, 0);
            this.tableColumns[i].setText(this.columnTitles[i]);
            this.tableColumns[i].setWidth(100);
            ++i;
        }
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.extTableViewer.getTable().setLayoutData((Object)gridData);
        this.contentProvider = new EnablePluginsContentProvider();
        this.extTableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new EnablePluginsLabelProvider();
        this.extTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        EnablePluginsViewerSorter viewerSorter = new EnablePluginsViewerSorter();
        this.columnManager = new ExtTableColumnManager(t, this.extTableViewer, this.labelProvider, true);
        this.columnManager.setViewerSorter(t, viewerSorter, true);
        this.columnManager.addColumnSortListeners(t);
        Composite compButtons = new Composite(this.composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginWidth = 0;
        compButtons.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData = new GridData(768);
        compButtons.setLayoutData((Object)gridData);
        Button buttonSelectAll = new Button(compButtons, 8);
        buttonSelectAll.setText(msgFile.getMessage(t, "UI.GENERAL.SELECT.ALL"));
        gridData = new GridData();
        buttonSelectAll.setLayoutData((Object)gridData);
        buttonSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageEnablePlugins.this.selectAllItems(Trace.getDefault(), true);
            }
        });
        Button buttonSelectNone = new Button(compButtons, 8);
        buttonSelectNone.setText(msgFile.getMessage(t, "UI.GENERAL.SELECT.NONE"));
        gridData = new GridData();
        buttonSelectNone.setLayoutData((Object)gridData);
        buttonSelectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencePageEnablePlugins.this.selectAllItems(Trace.getDefault(), false);
            }
        });
        Label label = new Label(compButtons, 0);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        ButtonTools.makeEqualWidthGridData(t, compButtons);
        return this.composite;
    }

    public void init(IWorkbench workbench) {
        this.pluginRegistrationManager = UiPlugin.getPluginRegistrationManager();
        this.setPreferenceStore(UiPlugin.getPrefStore());
    }

    public void setVisible(boolean visible) {
        Trace t = Trace.getDefault();
        super.setVisible(visible);
        if (visible && !this.isCurrentSettingsLoaded) {
            this.loadCurrentSettings(t);
            this.isCurrentSettingsLoaded = true;
        }
    }

    private void loadCurrentSettings(Trace t) {
        ArrayList<RegisteredPlugin> registeredPlugins = this.pluginRegistrationManager.getRegisteredPlugins();
        this.extTableViewer.setInput(registeredPlugins);
        Table table = this.extTableViewer.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            TableItem tableItem = table.getItem(i);
            RegisteredPlugin regPlugin = (RegisteredPlugin)tableItem.getData();
            tableItem.setChecked(regPlugin.isEnabled());
            ++i;
        }
        this.columnManager.resizeTableColumns(t, true);
    }

    protected void performDefaults() {
        super.performDefaults();
        Table table = this.extTableViewer.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            TableItem tableItem = table.getItem(i);
            RegisteredPlugin regPlugin = (RegisteredPlugin)tableItem.getData();
            boolean enabledByDefault = regPlugin.isEnabledByDefault();
            tableItem.setChecked(enabledByDefault);
            ++i;
        }
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        Table table = this.extTableViewer.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            TableItem tableItem = table.getItem(i);
            RegisteredPlugin regPlugin = (RegisteredPlugin)tableItem.getData();
            String plugin_id = regPlugin.getPlugin_id();
            boolean enabled = tableItem.getChecked();
            this.pluginRegistrationManager.enablePlugin(plugin_id, enabled);
            store.setValue("EnablePlugin_" + plugin_id, enabled);
            ++i;
        }
        this.pluginRegistrationManager.enablementUpdateComplete();
        return super.performOk();
    }

    protected void performApply() {
        super.performApply();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    private void selectAllItems(Trace t, boolean isSelect) {
        Table table = this.extTableViewer.getTable();
        int i = 0;
        while (i < table.getItemCount()) {
            TableItem tableItem = table.getItem(i);
            tableItem.setChecked(isSelect);
            ++i;
        }
    }

    private class EnablePluginsContentProvider
    implements IStructuredContentProvider {
        RegisteredPlugin[] regPlugins = null;

        private EnablePluginsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.regPlugins;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)newInput;
                this.regPlugins = arrayList.toArray(new RegisteredPlugin[arrayList.size()]);
            }
        }
    }

    private class EnablePluginsLabelProvider
    extends ExtTableLabelProvider {
        @Override
        public Image getImageForColumn(Object element, int columnIndex) {
            return null;
        }

        @Override
        public String getTextForColumn(Object element, int columnIndex) {
            String text = "";
            if (element instanceof RegisteredPlugin) {
                RegisteredPlugin regPlugin = (RegisteredPlugin)element;
                switch (columnIndex) {
                    case 0: {
                        text = regPlugin.getName();
                        break;
                    }
                    case 1: {
                        text = regPlugin.getVendor();
                        break;
                    }
                    case 2: {
                        text = regPlugin.getDescription();
                        break;
                    }
                    case 3: {
                        text = regPlugin.getPlugin_id();
                    }
                }
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class EnablePluginsViewerSorter
    extends ExtViewerSorter
    implements Comparator<Object> {
        private boolean isSortAscending = true;
        private int sortIndex = 0;
        private boolean isPrevSortAscending = true;
        private int prevSortIndex = 0;
        private Collator collator = Collator.getInstance(Locale.getDefault());

        private EnablePluginsViewerSorter() {
        }

        @Override
        public void setSortDirection(Trace t, boolean sortAscending) {
            this.isSortAscending = sortAscending;
        }

        @Override
        public void setSortColumnIndex(Trace t, int index) {
            if (index != this.sortIndex) {
                this.prevSortIndex = this.sortIndex;
            }
            this.sortIndex = index;
        }

        private int compareString(Trace t, String value1, String value2) {
            int result = 0;
            result = this.isSortAscending ? this.collator.compare(value1, value2) : this.collator.compare(value2, value1);
            return result;
        }

        public int compare(Viewer viewer, Object o1, Object o2) {
            return this.compare(o1, o2);
        }

        @Override
        public int compare(Object o1, Object o2) {
            Trace t = Trace.getDefault();
            int result = 0;
            if (o1 == null) {
                result = this.isSortAscending ? -1 : 1;
            } else if (o2 == null) {
                result = this.isSortAscending ? 1 : -1;
            } else if (o1 instanceof RegisteredPlugin && o2 instanceof RegisteredPlugin) {
                String text2;
                RegisteredPlugin regPlugin1 = (RegisteredPlugin)o1;
                RegisteredPlugin regPlugin2 = (RegisteredPlugin)o2;
                String text1 = this.getTextForColumn(t, regPlugin1, this.sortIndex);
                result = this.compareString(t, text1, text2 = this.getTextForColumn(t, regPlugin2, this.sortIndex));
                if (result == 0 && this.prevSortIndex != this.sortIndex) {
                    text1 = this.getTextForColumn(t, regPlugin1, this.prevSortIndex);
                    text2 = this.getTextForColumn(t, regPlugin2, this.prevSortIndex);
                    result = this.isPrevSortAscending ? this.compareString(t, text1, text2) : this.compareString(t, text2, text1);
                }
            }
            return result;
        }

        private String getTextForColumn(Trace t, RegisteredPlugin regPlugin, int index) {
            String text = "";
            switch (this.sortIndex) {
                case 0: {
                    text = regPlugin.getName();
                    break;
                }
                case 1: {
                    text = regPlugin.getVendor();
                    break;
                }
                case 2: {
                    text = regPlugin.getDescription();
                    break;
                }
                case 3: {
                    text = regPlugin.getPlugin_id();
                }
            }
            return text;
        }

        @Override
        public void setSortDirections(Trace t, boolean primarySortAscending, boolean secondarySortAscending) {
            this.isSortAscending = primarySortAscending;
            this.isPrevSortAscending = secondarySortAscending;
        }

        @Override
        public void setSortColumnIndices(Trace t, int primaryIndex, int secondaryIndex) {
            this.sortIndex = primaryIndex;
            this.prevSortIndex = secondaryIndex;
        }
    }
}

