/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.preferences;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.plugins.PluginRegistrationManager;
import com.ibm.mq.explorer.ui.internal.plugins.RegisteredPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ImportExportPreferences {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/preferences/ImportExportPreferences.java";
    private XMLMemento rootWrite = null;
    private XMLMemento rootRead = null;
    private static final String ROOT_NODE = "Preferences";
    private static final String MAIN_NODE = "Main";
    private static final String PLUGINS_NODE = "PluginRegistrations";
    private static final String APLUGIN_NODE_PREFIX = "Plugin_";
    private static final String SSL_NODE = "SSL";
    private static final String COLORS_NODE = "Colors";
    private static final String VERSION_KEY = "FileVersion";
    private static final String PLUGINS_COUNT_KEY = "Count";
    private static final String PLUGIN_ID_KEY = "PluginId";
    private static final String PLUGIN_ENABLED_KEY = "Enabled";
    private static final String THIS_VERSION = "1.0.0";
    private IPreferenceStore preferenceStore = null;
    private PluginRegistrationManager pluginRegistrationManager = null;

    public ImportExportPreferences(Trace t, IPreferenceStore prefStore, PluginRegistrationManager pluginRegMgr) {
        this.preferenceStore = prefStore;
        this.pluginRegistrationManager = pluginRegMgr;
        this.rootWrite = XMLMemento.createWriteRoot((String)ROOT_NODE);
    }

    public boolean exportPreferences(Trace t, String filename) {
        boolean result = false;
        this.rootWrite.putString(VERSION_KEY, THIS_VERSION);
        IMemento mainWrite = this.openChild(t, (IMemento)this.rootWrite, MAIN_NODE);
        boolean isSet = this.preferenceStore.getBoolean("ShowObjectStatus");
        int intSet = isSet ? 1 : 0;
        mainWrite.putInteger("ShowObjectStatus", intSet);
        String string = this.preferenceStore.getString("LocalDefaultRefreshRate");
        mainWrite.putString("LocalDefaultRefreshRate", string);
        string = this.preferenceStore.getString("RemoteDefaultRefreshRate");
        mainWrite.putString("RemoteDefaultRefreshRate", string);
        string = this.preferenceStore.getString("MonitorRefreshRate");
        mainWrite.putString("MonitorRefreshRate", string);
        isSet = this.preferenceStore.getBoolean("SuppressSuccessDialog");
        intSet = isSet ? 1 : 0;
        mainWrite.putInteger("SuppressSuccessDialog", intSet);
        isSet = this.preferenceStore.getBoolean("RemoveAuthorityRecord");
        intSet = isSet ? 1 : 0;
        mainWrite.putInteger("RemoveAuthorityRecord", intSet);
        isSet = this.preferenceStore.getBoolean("SuppressManageAuthorityRecordDialog");
        intSet = isSet ? 1 : 0;
        mainWrite.putInteger("SuppressManageAuthorityRecordDialog", intSet);
        isSet = this.preferenceStore.getBoolean("SortTables");
        intSet = isSet ? 1 : 0;
        mainWrite.putInteger("SortTables", intSet);
        IMemento pluginsWrite = this.openChild(t, (IMemento)this.rootWrite, PLUGINS_NODE);
        ArrayList<RegisteredPlugin> registeredPlugins = this.pluginRegistrationManager.getRegisteredPlugins();
        pluginsWrite.putInteger(PLUGINS_COUNT_KEY, registeredPlugins.size());
        int i = 0;
        while (i < registeredPlugins.size()) {
            RegisteredPlugin registeredPlugin = registeredPlugins.get(i);
            IMemento pluginWrite = this.openChild(t, pluginsWrite, APLUGIN_NODE_PREFIX + i);
            pluginWrite.putString(PLUGIN_ID_KEY, registeredPlugin.getPlugin_id());
            intSet = 0;
            if (registeredPlugin.isEnabled()) {
                intSet = 1;
            }
            pluginWrite.putInteger(PLUGIN_ENABLED_KEY, intSet);
            ++i;
        }
        IMemento sslWrite = this.openChild(t, (IMemento)this.rootWrite, SSL_NODE);
        string = this.preferenceStore.getString("TrustedStoreName");
        sslWrite.putString("TrustedStoreName", string);
        string = this.preferenceStore.getString("PersonalStoreName");
        sslWrite.putString("PersonalStoreName", string);
        IMemento colorsWrite = this.openChild(t, (IMemento)this.rootWrite, COLORS_NODE);
        string = this.preferenceStore.getString("InvalidCellColorRed");
        colorsWrite.putString("InvalidCellColorRed", string);
        string = this.preferenceStore.getString("InvalidCellColorGreen");
        colorsWrite.putString("InvalidCellColorGreen", string);
        string = this.preferenceStore.getString("InvalidCellColorBlue");
        colorsWrite.putString("InvalidCellColorBlue", string);
        string = this.preferenceStore.getString("ConsoleBackgroundColorRed");
        colorsWrite.putString("ConsoleBackgroundColorRed", string);
        string = this.preferenceStore.getString("ConsoleBackgroundColorGreen");
        colorsWrite.putString("ConsoleBackgroundColorGreen", string);
        string = this.preferenceStore.getString("ConsoleBackgroundColorBlue");
        colorsWrite.putString("ConsoleBackgroundColorBlue", string);
        string = this.preferenceStore.getString("ConsoleCommandColorRed");
        colorsWrite.putString("ConsoleCommandColorRed", string);
        string = this.preferenceStore.getString("ConsoleCommandColorGreen");
        colorsWrite.putString("ConsoleCommandColorGreen", string);
        string = this.preferenceStore.getString("ConsoleCommandColorBlue");
        colorsWrite.putString("ConsoleCommandColorBlue", string);
        string = this.preferenceStore.getString("ConsoleStdoutColorRed");
        colorsWrite.putString("ConsoleStdoutColorRed", string);
        string = this.preferenceStore.getString("ConsoleStdoutColorGreen");
        colorsWrite.putString("ConsoleStdoutColorGreen", string);
        string = this.preferenceStore.getString("ConsoleStdoutColorBlue");
        colorsWrite.putString("ConsoleStdoutColorBlue", string);
        string = this.preferenceStore.getString("ConsoleStderrColorRed");
        colorsWrite.putString("ConsoleStderrColorRed", string);
        string = this.preferenceStore.getString("ConsoleStderrColorGreen");
        colorsWrite.putString("ConsoleStderrColorGreen", string);
        string = this.preferenceStore.getString("ConsoleStderrColorBlue");
        colorsWrite.putString("ConsoleStderrColorBlue", string);
        string = this.preferenceStore.getString("ConsoleResultColorRed");
        colorsWrite.putString("ConsoleResultColorRed", string);
        string = this.preferenceStore.getString("ConsoleResultColorGreen");
        colorsWrite.putString("ConsoleResultColorGreen", string);
        string = this.preferenceStore.getString("ConsoleResultColorBlue");
        colorsWrite.putString("ConsoleResultColorBlue", string);
        OutputStreamWriter writer = null;
        try {
            try {
                File file = new File(filename);
                FileOutputStream output = new FileOutputStream(file);
                writer = new OutputStreamWriter(output);
                this.rootWrite.save((Writer)writer);
                result = true;
            }
            catch (IOException e) {
                t.FFST(67, "ImportExportPreferences.exportPreferences", 10, -1, 0, 0, e.getMessage(), null, null);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "ImportExportPreferences.exportPreferences", 20, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e1) {
                t.FFST(67, "ImportExportPreferences.exportPreferences", 20, -1, 0, 0, e1.getMessage(), null, null);
            }
        }
        return result;
    }

    public boolean importPreferences(Trace t, String filename) {
        boolean result = true;
        InputStreamReader reader = null;
        try {
            try {
                IMemento child;
                File file = new File(filename);
                FileInputStream input = new FileInputStream(file);
                reader = new InputStreamReader(input);
                this.rootRead = XMLMemento.createReadRoot((Reader)reader);
                String fileVersion = this.rootRead.getString(VERSION_KEY);
                if (fileVersion != null) {
                    fileVersion.compareTo(THIS_VERSION);
                }
                if ((child = this.rootRead.getChild(MAIN_NODE)) != null) {
                    this.setPreferenceBoolean(child, "ShowObjectStatus");
                    this.setPreferenceInteger(child, "LocalDefaultRefreshRate");
                    this.setPreferenceInteger(child, "RemoteDefaultRefreshRate");
                    this.setPreferenceInteger(child, "RemoteDefaultRefreshRate");
                    this.setPreferenceInteger(child, "MonitorRefreshRate");
                    this.setPreferenceInteger(child, "SuppressSuccessDialog");
                    this.setPreferenceInteger(child, "RemoveAuthorityRecord");
                    this.setPreferenceInteger(child, "SuppressManageAuthorityRecordDialog");
                    this.setPreferenceInteger(child, "SortTables");
                }
                if ((child = this.rootRead.getChild(PLUGINS_NODE)) != null && this.pluginRegistrationManager != null) {
                    Integer intCount = child.getInteger(PLUGINS_COUNT_KEY);
                    int i = 0;
                    while (i < intCount) {
                        IMemento pluginChild = child.getChild(APLUGIN_NODE_PREFIX + i);
                        if (pluginChild != null) {
                            String pluginId = pluginChild.getString(PLUGIN_ID_KEY);
                            Integer pluginEnabled = pluginChild.getInteger(PLUGIN_ENABLED_KEY);
                            if (pluginId != null && pluginEnabled != null) {
                                boolean enabled = pluginEnabled == 1;
                                this.pluginRegistrationManager.enablePlugin(pluginId, enabled);
                                this.preferenceStore.setValue("EnablePlugin_" + pluginId, enabled);
                            }
                        }
                        ++i;
                    }
                    this.pluginRegistrationManager.enablementUpdateComplete();
                }
                if ((child = this.rootRead.getChild(SSL_NODE)) != null) {
                    this.setPreferenceString(child, "TrustedStoreName");
                    this.setPreferenceString(child, "PersonalStoreName");
                }
                if ((child = this.rootRead.getChild(COLORS_NODE)) != null) {
                    Integer intValue;
                    this.setPreferenceString(child, "InvalidCellColorRed");
                    this.setPreferenceString(child, "InvalidCellColorGreen");
                    this.setPreferenceString(child, "InvalidCellColorBlue");
                    String text = this.preferenceStore.getString("InvalidCellColorChanged");
                    if (text.equals("")) {
                        text = "0";
                    }
                    if ((intValue = Integer.valueOf(text)) != null) {
                        text = "" + (intValue + 1);
                        this.preferenceStore.setValue("InvalidCellColorChanged", text);
                    }
                    this.setPreferenceString(child, "ConsoleBackgroundColorRed");
                    this.setPreferenceString(child, "ConsoleBackgroundColorGreen");
                    this.setPreferenceString(child, "ConsoleBackgroundColorBlue");
                    text = this.preferenceStore.getString("ConsoleBackgroundColorChanged");
                    if (text.equals("")) {
                        text = "0";
                    }
                    if ((intValue = Integer.valueOf(text)) != null) {
                        text = "" + (intValue + 1);
                        this.preferenceStore.setValue("ConsoleBackgroundColorChanged", text);
                    }
                    this.setPreferenceString(child, "ConsoleCommandColorRed");
                    this.setPreferenceString(child, "ConsoleCommandColorGreen");
                    this.setPreferenceString(child, "ConsoleCommandColorBlue");
                    text = this.preferenceStore.getString("ConsoleCommandColorChanged");
                    if (text.equals("")) {
                        text = "0";
                    }
                    if ((intValue = Integer.valueOf(text)) != null) {
                        text = "" + (intValue + 1);
                        this.preferenceStore.setValue("ConsoleCommandColorChanged", text);
                    }
                    this.setPreferenceString(child, "ConsoleStdoutColorRed");
                    this.setPreferenceString(child, "ConsoleStdoutColorGreen");
                    this.setPreferenceString(child, "ConsoleStdoutColorBlue");
                    text = this.preferenceStore.getString("ConsoleStdoutColorChanged");
                    if (text.equals("")) {
                        text = "0";
                    }
                    if ((intValue = Integer.valueOf(text)) != null) {
                        text = "" + (intValue + 1);
                        this.preferenceStore.setValue("ConsoleStdoutColorChanged", text);
                    }
                    this.setPreferenceString(child, "ConsoleStderrColorRed");
                    this.setPreferenceString(child, "ConsoleStderrColorGreen");
                    this.setPreferenceString(child, "ConsoleStderrColorBlue");
                    text = this.preferenceStore.getString("ConsoleStderrColorChanged");
                    if (text.equals("")) {
                        text = "0";
                    }
                    if ((intValue = Integer.valueOf(text)) != null) {
                        text = "" + (intValue + 1);
                        this.preferenceStore.setValue("ConsoleStderrColorChanged", text);
                    }
                    this.setPreferenceString(child, "ConsoleResultColorRed");
                    this.setPreferenceString(child, "ConsoleResultColorGreen");
                    this.setPreferenceString(child, "ConsoleResultColorBlue");
                    text = this.preferenceStore.getString("ConsoleResultColorChanged");
                    if (text.equals("")) {
                        text = "0";
                    }
                    if ((intValue = Integer.valueOf(text)) != null) {
                        text = "" + (intValue + 1);
                        this.preferenceStore.setValue("ConsoleResultColorChanged", text);
                    }
                }
            }
            catch (FileNotFoundException e) {
                if (Trace.isTracing) {
                    t.data(67, "ImportExportPreferences.importPreferences", 300, e.getMessage());
                }
                result = false;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "ImportExportPreferences.importPreferences", 10, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
            catch (WorkbenchException e) {
                if (Trace.isTracing) {
                    t.data(67, "ImportExportPreferences.importPreferences", 300, e.getMessage());
                }
                result = false;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "ImportExportPreferences.importPreferences", 10, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e1) {
                t.FFST(67, "ImportExportPreferences.importPreferences", 10, -1, 0, 0, e1.getMessage(), null, null);
            }
        }
        return result;
    }

    private void setPreferenceBoolean(IMemento child, String preferenceName) {
        Integer intVal = child.getInteger(preferenceName);
        if (intVal != null) {
            this.preferenceStore.setValue(preferenceName, intVal == 1);
        }
    }

    private void setPreferenceInteger(IMemento child, String preferenceName) {
        Integer intVal = child.getInteger(preferenceName);
        if (intVal != null) {
            this.preferenceStore.setValue(preferenceName, intVal.intValue());
        }
    }

    private void setPreferenceString(IMemento child, String preferenceName) {
        String stringVal = child.getString(preferenceName);
        if (stringVal != null) {
            this.preferenceStore.setValue(preferenceName, stringVal);
        }
    }

    private IMemento openChild(Trace t, IMemento parent, String childName) {
        IMemento child = null;
        child = parent.getChild(childName);
        if (child == null) {
            child = parent.createChild(childName);
        }
        return child;
    }
}

