/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.plugins;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.plugins.PluginsChangedEvent;
import com.ibm.mq.explorer.ui.internal.plugins.PluginsChangedListener;
import com.ibm.mq.explorer.ui.internal.plugins.RegisteredPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;

public class PluginRegistrationManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/plugins/PluginRegistrationManager.java";
    private Map<String, RegisteredPlugin> registeredPlugins = new HashMap<String, RegisteredPlugin>();
    private Vector<PluginsChangedListener> changeListeners = new Vector();
    private boolean enablementChanged = false;
    private ArrayList<RegisteredPlugin> changedPlugins = new ArrayList();

    public PluginRegistrationManager(Trace t) {
    }

    public void loadPluginRegistrations(Trace t) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", "registerplugin");
        if (extensionPoint != null) {
            if (Trace.isTracing) {
                t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "    label = " + extensionPoint.getLabel());
                t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "    schemaReference = " + extensionPoint.getSchemaReference());
                t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
                t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            }
            IConfigurationElement[] configArray = extensionPoint.getConfigurationElements();
            t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "    Number of ConfigurationElements = " + configArray.length);
            int i = 0;
            while (i < configArray.length) {
                IConfigurationElement element = configArray[i];
                if (Trace.isTracing) {
                    t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "        name  = " + element.getName());
                    t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "        value = " + element.getValue());
                    t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "");
                }
                String name = element.getAttribute("name");
                String description = element.getAttribute("description");
                String vendor = element.getAttribute("vendor");
                String plugin_id = element.getAttribute("pluginId");
                String enabledByDefaultString = element.getAttribute("enabledByDefault");
                boolean enabledByDefault = true;
                if (enabledByDefaultString != null && enabledByDefaultString.compareToIgnoreCase("false") == 0) {
                    enabledByDefault = false;
                }
                if (name != null && name.length() > 0 && vendor != null && vendor.length() > 0 && description != null && description.length() > 0 && plugin_id != null && plugin_id.length() > 0) {
                    if (Trace.isTracing) {
                        t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "        name               = " + name);
                        t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "        description        = " + description);
                        t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "        vendor             = " + vendor);
                        t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "        pluginId           = " + plugin_id);
                        t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "        enabledByDefault   = " + enabledByDefault);
                        t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "");
                    }
                    RegisteredPlugin registeredPlugin = new RegisteredPlugin(name, description, vendor, plugin_id, enabledByDefault);
                    IPreferenceStore store = UiPlugin.getPrefStore();
                    store.setDefault("EnablePlugin_" + plugin_id, enabledByDefault);
                    registeredPlugin.setEnabled(store.getBoolean("EnablePlugin_" + plugin_id));
                    this.registeredPlugins.put(plugin_id, registeredPlugin);
                }
                ++i;
            }
            t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "");
        }
        t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "");
        t.data(67, "PluginRegistrationManager.loadPluginRegistrations", 300, "");
    }

    public boolean isPluginRegistered(String plugin_id) {
        boolean registered = false;
        registered = plugin_id.compareTo("com.ibm.mq.explorer.ui") == 0 ? true : (plugin_id.compareTo("com.ibm.mq.explorer.ui.zos") == 0 ? true : this.registeredPlugins.containsKey(plugin_id));
        return registered;
    }

    public boolean isPluginEnabled(String plugin_id) {
        RegisteredPlugin rp = this.registeredPlugins.get(plugin_id);
        if (rp != null) {
            return rp.isEnabled();
        }
        return false;
    }

    public ArrayList<RegisteredPlugin> getRegisteredPlugins() {
        return new ArrayList<RegisteredPlugin>(this.registeredPlugins.values());
    }

    public void enablementUpdateBegin() {
        this.enablementChanged = false;
        this.changedPlugins.clear();
    }

    public void enablementUpdateComplete() {
        if (this.enablementChanged) {
            PluginsChangedEvent changeEvent = new PluginsChangedEvent(this, this.changedPlugins);
            int i = 0;
            while (i < this.changeListeners.size()) {
                PluginsChangedListener listener = this.changeListeners.elementAt(i);
                listener.pluginsChanged(changeEvent);
                ++i;
            }
        }
        this.changedPlugins.clear();
    }

    public void addChangeListener(Trace t, PluginsChangedListener listener) {
        this.changeListeners.addElement(listener);
    }

    public void removeChangeListener(Trace t, PluginsChangedListener listener) {
        this.changeListeners.removeElement(listener);
    }

    public boolean isPluginEnabledByDefault(String plugin_id) {
        boolean enabledByDefault = false;
        RegisteredPlugin registeredPlugin = this.getRegisteredPluginObject(plugin_id);
        if (registeredPlugin != null) {
            enabledByDefault = registeredPlugin.isEnabledByDefault();
        }
        return enabledByDefault;
    }

    public void enablePlugin(String plugin_id, boolean enabled) {
        RegisteredPlugin registeredPlugin = this.getRegisteredPluginObject(plugin_id);
        if (registeredPlugin != null && registeredPlugin.isEnabled() != enabled) {
            registeredPlugin.setEnabled(enabled);
            this.enablementChanged = true;
            this.changedPlugins.add(registeredPlugin);
        }
    }

    private RegisteredPlugin getRegisteredPluginObject(String plugin_id) {
        return this.registeredPlugins.get(plugin_id);
    }

    public String getPluginName(String plugin_id) {
        String name = null;
        RegisteredPlugin plugin = this.getRegisteredPluginObject(plugin_id);
        if (plugin != null) {
            name = plugin.getName();
        }
        return name;
    }
}

