/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.passwords;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.core.internal.utils.QueueManagerHandle;
import com.ibm.mq.explorer.passwords.internal.store.IPwCredentials;
import com.ibm.mq.explorer.passwords.internal.store.PwDefaultCredentials;
import com.ibm.mq.explorer.passwords.internal.store.PwDefaultStore;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.dialogs.PasswordDialog;
import com.ibm.mq.explorer.ui.internal.passwords.PwStoreManager;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;

public abstract class PwUtils {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/passwords/PwUtils.java";
    private static Message msgFile = null;

    private PwUtils() {
        System.out.println("*** You should not be using this constructor ***");
    }

    public static int savePassword(Trace t, IDmObject dmObject, String objectId, String resourceId, String pw) {
        int rc = 0;
        String ownerId = null;
        try {
            if (PwStoreManager.isSavingPasswordsPreference() && PwDefaultStore.getDefaultStore((Trace)t).isOpen(t)) {
                QueueManagerHandle h = ((DmQueueManagerHandle)dmObject).getQueueManagerHandle(t);
                if (pw != null) {
                    ownerId = h.getUniqueId(t);
                    PwDefaultCredentials c = new PwDefaultCredentials(t, ownerId, objectId, resourceId, pw);
                    rc = PwStoreManager.getStoreManager(t).saveCredentials(t, (IPwCredentials)c);
                }
            }
        }
        catch (Exception e) {
            rc = 1;
            t.FFST(67, "PwUtils.savePassword", 0, 50028, 0, 0, e.getMessage(), "Unable to save password for object " + dmObject.getTitle() + ", owner " + ownerId + ", resource " + resourceId, null);
        }
        return rc;
    }

    public static int savePassword(Trace t, String owner, String objectId, String resource, String pw) {
        int rc = 0;
        try {
            if (PwStoreManager.isSavingPasswordsPreference() && PwDefaultStore.getDefaultStore((Trace)t).isOpen(t) && pw != null) {
                PwDefaultCredentials c = new PwDefaultCredentials(t, owner, objectId, resource, pw);
                rc = PwStoreManager.getStoreManager(t).saveCredentials(t, (IPwCredentials)c);
            }
        }
        catch (Exception e) {
            rc = 1;
            t.FFST(67, "PwUtils.savePassword", 1, 50028, 0, 0, e.getMessage(), "Unable to save password for owner " + owner + ", object id " + objectId + ", resource " + resource, null);
        }
        return rc;
    }

    public static boolean getPasswords(Trace t, DmQueueManager qmgr) {
        boolean retValue = true;
        retValue = PwUtils.getUseridPassword(t, qmgr);
        if (retValue && (retValue = PwUtils.getPersonalStorePassword(t, qmgr))) {
            retValue = PwUtils.getTrustStorePassword(t, qmgr);
        }
        return retValue;
    }

    public static boolean getUseridPassword(Trace t, final DmQueueManager qmgr) {
        boolean prompt = false;
        final boolean[] retValue = new boolean[]{true};
        final QueueManagerHandle qmHandle = qmgr.getConnectionHandle().getQueueManagerHandle(t);
        int passwordMode = qmHandle.getPasswordMode();
        if (qmHandle.getUserIdState() != 0) {
            if (passwordMode == 1) {
                prompt = true;
            }
            if (passwordMode == 2 && !PwStoreManager.isSavingPasswordsPreference()) {
                prompt = true;
            }
            if (prompt) {
                if (msgFile == null) {
                    msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
                }
                UiUtils.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Trace t2 = Trace.getDefault();
                        PasswordDialog dialog = new PasswordDialog(UiPlugin.getShell());
                        dialog.setTitle(msgFile.getMessage("Ui.Dialog.Passwords.Title"));
                        String description = msgFile.getMessage("Ui.Dialog.Passwords.QueueManager", qmgr.getTitle());
                        description = String.valueOf(description) + "\n";
                        description = String.valueOf(description) + msgFile.getMessage("Ui.Dialog.Passwords.Description", qmHandle.getUserid());
                        dialog.setDescription(description);
                        dialog.setMinPasswordLength(0);
                        dialog.create(t2);
                        if (dialog.open(t2)) {
                            qmHandle.setTempPassword(dialog.getPassword());
                        } else {
                            retValue[0] = false;
                        }
                    }
                });
            }
        }
        if (Trace.isTracing) {
            t.data(67, "PwUtils.getUseridPassword", 300, "Get userid password will return " + retValue);
        }
        return retValue[0];
    }

    public static boolean getPersonalStorePassword(Trace t, final DmQueueManager qmgr) {
        final boolean[] retValue = new boolean[]{true};
        boolean prompt = false;
        final QueueManagerHandle qmHandle = qmgr.getConnectionHandle().getQueueManagerHandle(t);
        if (!PwStoreManager.isSavingPasswordsPreference() || !PwDefaultStore.getDefaultStore((Trace)t).isOpen(t)) {
            prompt = true;
        } else if (PwUtils.getPassword(t, qmHandle, "com.ibm.mq.explorer.addqm.conn.details.personal.store.pw", qmHandle.getSSLPersonalStore()) == null) {
            prompt = true;
        }
        if (prompt) {
            if (msgFile == null) {
                msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
            }
            if (!qmHandle.getSSLPersonalStore().equals("")) {
                UiUtils.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Trace t2 = Trace.getDefault();
                        PasswordDialog dialog = new PasswordDialog(UiPlugin.getShell());
                        dialog.setTitle(msgFile.getMessage("Ui.Dialog.Passwords.Title"));
                        dialog.setDescription(msgFile.getMessage("Ui.Dialog.Passwords.Enter.Password", qmHandle.getSSLPersonalStore()));
                        dialog.create(t2);
                        if (dialog.open(t2)) {
                            qmHandle.setTempSSLPersonalStorePassword(dialog.getPassword());
                            PwUtils.savePassword(t2, (IDmObject)qmgr.getConnectionHandle(), "com.ibm.mq.explorer.addqm.conn.details.personal.store.pw", qmHandle.getSSLPersonalStore(), dialog.getPassword());
                        } else {
                            retValue[0] = false;
                        }
                    }
                });
            }
        }
        if (Trace.isTracing) {
            t.data(67, "PwUtils.getPersonalStorePassword", 300, "Get SSL personal store password will return " + retValue);
        }
        return retValue[0];
    }

    public static boolean getTrustStorePassword(Trace t, final DmQueueManager qmgr) {
        final boolean[] retValue = new boolean[]{true};
        boolean prompt = false;
        final QueueManagerHandle qmHandle = qmgr.getConnectionHandle().getQueueManagerHandle(t);
        if (!PwStoreManager.isSavingPasswordsPreference() || !PwDefaultStore.getDefaultStore((Trace)t).isOpen(t)) {
            prompt = true;
        } else if (PwUtils.getPassword(t, qmgr.getConnectionHandle().getQueueManagerHandle(t), "com.ibm.mq.explorer.addqm.conn.details.trusted.store.pw", qmHandle.getSSLTrustedStore()) == null) {
            prompt = true;
        }
        if (prompt) {
            if (msgFile == null) {
                msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
            }
            if (!qmHandle.getSSLTrustedStore().equals("")) {
                UiUtils.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Trace t2 = Trace.getDefault();
                        PasswordDialog dialog = new PasswordDialog(UiPlugin.getShell());
                        dialog.setTitle(msgFile.getMessage("Ui.Dialog.Passwords.Title"));
                        dialog.setDescription(msgFile.getMessage("Ui.Dialog.Passwords.Enter.Password", qmHandle.getSSLTrustedStore()));
                        dialog.create(t2);
                        if (dialog.open(t2)) {
                            qmHandle.setTempSSLTrustedStorePassword(dialog.getPassword());
                            PwUtils.savePassword(t2, (IDmObject)qmgr.getConnectionHandle(), "com.ibm.mq.explorer.addqm.conn.details.trusted.store.pw", qmHandle.getSSLTrustedStore(), dialog.getPassword());
                        } else {
                            retValue[0] = false;
                        }
                    }
                });
            }
        }
        if (Trace.isTracing) {
            t.data(67, "PwUtils.getTrustStorePassword", 300, "Get SSL trusted store password will return " + retValue);
        }
        return retValue[0];
    }

    private static String getPassword(Trace t, QueueManagerHandle qmHandle, String objectId, String resourceId) {
        String pw = null;
        String ownerId = qmHandle.getUniqueId(t);
        IPwCredentials c = PwStoreManager.getStoreManager(t).getCredentials(t, ownerId, objectId, resourceId);
        if (c != null) {
            pw = c.getPassword();
        }
        return pw;
    }

    public static int removePassword(Trace t, IDmObject dmObject, String objectId, String resourceId, String pw) {
        int rc = 0;
        String ownerId = null;
        if (PwStoreManager.isSavingPasswordsPreference() && PwDefaultStore.getDefaultStore((Trace)t).isOpen(t)) {
            QueueManagerHandle h = ((DmQueueManagerHandle)dmObject).getQueueManagerHandle(t);
            if (pw != null) {
                ownerId = h.getUniqueId(t);
                PwDefaultCredentials c = new PwDefaultCredentials(t, ownerId, objectId, resourceId, pw);
                rc = PwStoreManager.getStoreManager(t).deleteCredentials(t, (IPwCredentials)c);
            }
        }
        return rc;
    }

    public static String promptUseridPassword(final String QmgrName, final String userId) {
        final String[] retValue = new String[]{null};
        if (msgFile == null) {
            msgFile = UiPlugin.getUIMessages(Trace.getInstance(), "KEY_Queue Manager");
        }
        UiUtils.runInUIThread(new Runnable(){

            @Override
            public void run() {
                Trace t2 = Trace.getDefault();
                PasswordDialog dialog = new PasswordDialog(UiPlugin.getShell());
                dialog.setTitle(msgFile.getMessage("Ui.Dialog.Passwords.Title"));
                String description = msgFile.getMessage("Ui.Dialog.Passwords.QueueManager", QmgrName);
                description = String.valueOf(description) + "\n";
                description = String.valueOf(description) + msgFile.getMessage("Ui.Dialog.Passwords.Enter.Password", userId);
                dialog.setDescription(description);
                dialog.setMinPasswordLength(0);
                dialog.create(t2);
                if (dialog.open(t2)) {
                    retValue[0] = dialog.getPassword();
                }
            }
        });
        return retValue[0];
    }
}

