/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.passwords;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.passwords.internal.store.PwDefaultStore;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.passwords.PwStoreManager;
import com.ibm.mq.explorer.ui.internal.utils.ButtonTools;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PwStoreStatusDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/passwords/PwStoreStatusDialog.java";
    private static final int WIDTH_HINT = 400;
    private static final String PASSWORD_PREFERENCES_ID = "com.ibm.mq.explorer.pref.passwords";
    private Point preferredSize = null;
    private Message uiMessages;
    private Text textFileName = null;
    private Text textKeyType = null;
    private Text textStatus = null;
    private Text textSavingPreference = null;
    private Button buttonOpenStore = null;
    private Button buttonOpenPrefs = null;
    private boolean statusOpen = false;

    public PwStoreStatusDialog(Shell parent) {
        super(parent, 0, 1);
        Trace t = Trace.getDefault();
        this.uiMessages = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        Composite mainComposite = composite;
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginLeft = 10;
        gridLayout.makeColumnsEqualWidth = false;
        mainComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        mainComposite.setLayoutData((Object)gridData);
        Label label1 = new Label(mainComposite, 0);
        label1.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Store.Name"));
        gridData = new GridData(768);
        gridData.widthHint = 400;
        label1.setLayoutData((Object)gridData);
        this.textFileName = new Text(mainComposite, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 400;
        this.textFileName.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, this.textFileName, false);
        UiUtils.createBlankLine(mainComposite, 1);
        Label label2 = new Label(mainComposite, 0);
        label2.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Key.Type"));
        gridData = new GridData(768);
        gridData.widthHint = 400;
        label2.setLayoutData((Object)gridData);
        this.textKeyType = new Text(mainComposite, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 400;
        this.textKeyType.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, this.textKeyType, false);
        UiUtils.createBlankLine(mainComposite, 1);
        Label label3 = new Label(mainComposite, 0);
        label3.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Text"));
        gridData = new GridData(768);
        gridData.widthHint = 400;
        label3.setLayoutData((Object)gridData);
        this.textStatus = new Text(mainComposite, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 400;
        this.textStatus.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, this.textStatus, false);
        UiUtils.createBlankLine(mainComposite, 1);
        Label label4 = new Label(mainComposite, 0);
        label4.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Prefs.Text"));
        gridData = new GridData(768);
        gridData.widthHint = 400;
        label4.setLayoutData((Object)gridData);
        this.textSavingPreference = new Text(mainComposite, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 400;
        this.textSavingPreference.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, this.textSavingPreference, false);
        this.getStatusInfo(t);
        mainComposite.pack();
        this.preferredSize = mainComposite.getSize();
    }

    private void getStatusInfo(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        this.textFileName.setText(store.getString("PasswordsFileName"));
        boolean storeEnabled = store.getBoolean("PasswordsStoreEnabled");
        if (storeEnabled) {
            boolean userKeyType = store.getBoolean("PasswordsStoreUserKeyEnabled");
            if (userKeyType) {
                this.textKeyType.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Key.User"));
            } else {
                this.textKeyType.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Key.Default"));
            }
            this.textSavingPreference.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Prefs.Save"));
        } else {
            this.textKeyType.setText("");
            this.textSavingPreference.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Prefs.NoSave"));
        }
        this.statusOpen = PwDefaultStore.getDefaultStore((Trace)t).isOpen(t);
        if (this.statusOpen && PwDefaultStore.getDefaultStore((Trace)t).isSavingPasswords(t)) {
            this.textStatus.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Open"));
        } else {
            this.textStatus.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Closed"));
        }
        this.enableOpenStoreButton(t);
    }

    @Override
    public boolean okPressed(Trace t) {
        return true;
    }

    @Override
    public void cancelPressed(Trace t) {
    }

    @Override
    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_PwStoreStatusDialog";
    }

    @Override
    public String getTitle(Trace t) {
        return this.uiMessages.getMessage("UI.MACH.Password.Store.Title");
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return false;
    }

    @Override
    public void packDialog(Trace t) {
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return true;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        this.buttonOpenPrefs = new Button(composite, 8);
        this.buttonOpenPrefs.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Open.Prefs.Button"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.buttonOpenPrefs.setLayoutData((Object)gridData);
        this.buttonOpenPrefs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PwStoreStatusDialog.this.getShell(), (String)PwStoreStatusDialog.PASSWORD_PREFERENCES_ID, (String[])new String[]{PwStoreStatusDialog.PASSWORD_PREFERENCES_ID}, null);
                prefDialog.open();
                PwStoreStatusDialog.this.getStatusInfo(Trace.getDefault());
            }
        });
        this.buttonOpenStore = new Button(composite, 8);
        this.buttonOpenStore.setText(this.uiMessages.getMessage("UI.MACH.Password.Store.Status.Open.Store.Button"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.buttonOpenStore.setLayoutData((Object)gridData);
        this.buttonOpenStore.setEnabled(false);
        this.buttonOpenStore.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                PwStoreManager.getStoreManager(t2).close(t2);
                PwStoreManager.getStoreManager(t2);
                PwStoreStatusDialog.this.getStatusInfo(t2);
            }
        });
        ButtonTools.makeEqualWidthGridData(t, new Button[]{this.buttonOpenStore, this.buttonOpenPrefs});
        this.enableOpenStoreButton(t);
    }

    public void enableOpenStoreButton(Trace t) {
        if (this.buttonOpenStore != null) {
            if (this.statusOpen && PwDefaultStore.getDefaultStore((Trace)t).isSavingPasswords(t) || this.textFileName.getText().equals("") || this.textKeyType.getText().equals("")) {
                this.buttonOpenStore.setEnabled(false);
            } else {
                this.buttonOpenStore.setEnabled(true);
            }
        }
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        return false;
    }
}

