/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.passwords;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.passwords.internal.store.IPwCredentials;
import com.ibm.mq.explorer.passwords.internal.store.PwDefaultStore;
import com.ibm.mq.explorer.passwords.internal.utils.PwUtils;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.dialogs.PasswordDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import java.io.File;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;

public class PwStoreManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/passwords/PwStoreManager.java";
    public static final String MESSAGE_OPEN_ERROR = "AMQ4600";
    public static final String MESSAGE_COPY_ENTRIES = "AMQ4601";
    public static final String MESSAGE_VALIDATE_KEY_ERROR = "AMQ4602";
    public static final String MESSAGE_INVALID_FILENAME = "AMQ4603";
    public static final String MESSAGE_READONLY_FILENAME = "AMQ4604";
    public static final String MESSAGE_INVALID_FORMAT = "AMQ4605";
    public static final String MESSAGE_NOT_OPENED = "AMQ4606";
    private static final String SYSTEM_DEFAULT_KEY = "jhbasouawwfeqw9845kjn9ds8ds";
    private static final int MAXIMUM_KEY_PROMPTS = 3;
    private static PwDefaultStore defaultStore = null;
    private static PwStoreManager storeManager = null;
    private static String masterKey = "";
    private Message msgFile = null;

    private PwStoreManager(Trace t) {
        int openRc = 4;
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Queue Manager");
        defaultStore = PwDefaultStore.getDefaultStore((Trace)t);
        this.getPasswordFilePreference(t);
        if (PwStoreManager.isSavingPasswordsPreference()) {
            int i = 0;
            while (i < 3) {
                masterKey = this.getMasterKey(t, i + 1, 3);
                if (masterKey != null) {
                    openRc = defaultStore.open(t, defaultStore.getPasswordStoreFile(t).toString(), masterKey);
                    if (openRc == 0 || openRc == 8) break;
                    UiPlugin.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Trace t2 = Trace.getDefault();
                            String[] inserts = new String[]{PwUtils.formatPasswordStoreName((String)defaultStore.getPasswordStoreFile(t2).toString())};
                            MessageBox.showSystemMessageById(t2, UiPlugin.getShell(), PwStoreManager.MESSAGE_OPEN_ERROR, inserts);
                        }
                    });
                    if (!PwStoreManager.isUserDefinedKey()) {
                        break;
                    }
                } else {
                    UiPlugin.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Trace t2 = Trace.getDefault();
                            String[] inserts = new String[]{PwUtils.formatPasswordStoreName((String)defaultStore.getPasswordStoreFile(t2).toString())};
                            MessageBox.showSystemMessageById(t2, UiPlugin.getShell(), PwStoreManager.MESSAGE_NOT_OPENED, inserts);
                        }
                    });
                    break;
                }
                ++i;
            }
            if (openRc != 0) {
                openRc = defaultStore.open(t);
            }
        } else {
            masterKey = SYSTEM_DEFAULT_KEY;
            openRc = defaultStore.open(t);
        }
        if (Trace.isTracing) {
            t.data(67, "PwStoreManager.PwStoreManager", 300, "Store open return code " + openRc);
        }
    }

    public int saveCredentials(Trace t, IPwCredentials c) {
        int rc = 0;
        if (defaultStore.isOpen(t)) {
            rc = defaultStore.saveCredentials(t, c);
        }
        return rc;
    }

    public int deleteCredentials(Trace t, IPwCredentials c) {
        int rc = 0;
        if (defaultStore.isOpen(t)) {
            rc = defaultStore.deleteCredentials(t, c);
        }
        return rc;
    }

    public IPwCredentials getCredentials(Trace t, String ownerId, String objectId, String resourceId) {
        IPwCredentials credentials = null;
        credentials = defaultStore.getCredentials(t, ownerId, objectId, resourceId);
        return credentials;
    }

    public Vector<IPwCredentials> getAllCredentials(Trace t, String ownerId) {
        Vector allCredentials = null;
        allCredentials = defaultStore.getAllCredentials(t);
        return allCredentials;
    }

    public Vector<IPwCredentials> getAllCredentials(Trace t) {
        Vector allCredentials = null;
        allCredentials = defaultStore.getAllCredentials(t);
        return allCredentials;
    }

    public void close(Trace t) {
        defaultStore.close(t);
        defaultStore = null;
        storeManager = null;
    }

    public int setFile(Trace t, String newFile) {
        return this.setKeyAndFile(t, masterKey, masterKey, newFile);
    }

    public int setKey(Trace t, String oldKey, String newKey) {
        return this.setKeyAndFile(t, oldKey, newKey, defaultStore.getPasswordStoreFile(t).toString());
    }

    public int setKeyAndFile(Trace t, String oldMasterKey, String newMasterKey, String newFile) {
        String oldKey = oldMasterKey;
        String newKey = newMasterKey;
        int openRc = 0;
        File file = new File(newFile);
        if (oldKey.equals("")) {
            oldKey = SYSTEM_DEFAULT_KEY;
        }
        if (newKey.equals("")) {
            newKey = SYSTEM_DEFAULT_KEY;
        }
        if (!oldKey.equals(newKey)) {
            openRc = defaultStore.validate(t, oldKey);
            if (openRc == 0) {
                openRc = file.compareTo(defaultStore.getPasswordStoreFile(t)) == 0 ? defaultStore.setMasterKey(t, oldKey, newKey) : defaultStore.open(t, newFile, newKey);
            } else {
                MessageBox.showMessageFailure(t, UiPlugin.getShell(), CommonServices.getSystemMessage((String)MESSAGE_VALIDATE_KEY_ERROR, (String)PwUtils.formatPasswordStoreName((String)defaultStore.getPasswordStoreFile(t).toString())), MESSAGE_VALIDATE_KEY_ERROR);
            }
        } else {
            openRc = file.compareTo(defaultStore.getPasswordStoreFile(t)) == 0 ? defaultStore.setMasterKey(t, oldKey, newKey) : defaultStore.open(t, newFile, newKey);
        }
        if (openRc == 0 || openRc == 8) {
            masterKey = newKey;
        }
        return openRc;
    }

    public static boolean isSavingPasswordsPreference() {
        IPreferenceStore store = UiPlugin.getPrefStore();
        boolean b = store.getBoolean("PasswordsStoreEnabled");
        PwDefaultStore.setSavingPasswordsPreference((boolean)b);
        return b;
    }

    public static boolean isUserDefinedKey() {
        IPreferenceStore store = UiPlugin.getPrefStore();
        return store.getBoolean("PasswordsStoreUserKeyEnabled");
    }

    public static PwStoreManager getStoreManager(Trace t) {
        if (storeManager == null) {
            storeManager = new PwStoreManager(t);
        }
        return storeManager;
    }

    private String getMasterKey(Trace t, final int attempt, final int maxAttempts) {
        String password = null;
        if (PwStoreManager.isSavingPasswordsPreference()) {
            if (PwStoreManager.isUserDefinedKey()) {
                final String[] ret = new String[1];
                UiPlugin.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Trace t2 = Trace.getDefault();
                        PasswordDialog dialog = new PasswordDialog(UiPlugin.getShell());
                        dialog.setTitle(PwStoreManager.this.msgFile.getMessage("Ui.Dialog.Passwords.Title"));
                        dialog.setDescription(PwStoreManager.this.msgFile.getMessage("Ui.Dialog.Passwords.User.Key", String.valueOf(attempt), String.valueOf(maxAttempts)));
                        dialog.create(t2);
                        if (dialog.open(t2)) {
                            ret[0] = dialog.getPassword();
                        }
                    }
                });
                password = ret[0];
            } else {
                password = SYSTEM_DEFAULT_KEY;
            }
        } else {
            password = SYSTEM_DEFAULT_KEY;
        }
        return password;
    }

    private void getPasswordFilePreference(Trace t) {
        IPreferenceStore store = UiPlugin.getPrefStore();
        String s = store.getString("PasswordsFileName");
        if (s.equals("")) {
            String storeFilename = UiPlugin.getPersistentFileLocation().toString();
            storeFilename = String.valueOf(storeFilename) + File.separator + "WMQ_Passwords.xml";
            defaultStore.setPasswordStoreFile(t, new File(storeFilename));
        } else {
            defaultStore.setPasswordStoreFile(t, new File(s));
        }
        if (Trace.isTracing) {
            t.data(67, "PwStoreManager.getPasswordFilePreference", 300, "Password store file name = " + defaultStore.getPasswordStoreFile(t));
        }
    }

    public int validate(Trace t, File fileName) {
        return defaultStore.validate(t, fileName);
    }

    public int validate(Trace t, String key) {
        return defaultStore.validate(t, key);
    }

    public int createStore(Trace t, String fileName, String userKey, boolean copy) {
        int rc = 0;
        String key = userKey;
        if (key.equals("")) {
            key = SYSTEM_DEFAULT_KEY;
        }
        rc = defaultStore.create(t, fileName, key, copy);
        return rc;
    }

    public int open(Trace t, String fileName, String userKey) {
        int rc = 0;
        String key = userKey;
        if (key.equals("")) {
            key = SYSTEM_DEFAULT_KEY;
        }
        rc = defaultStore.open(t, fileName, key);
        return rc;
    }
}

