/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.objecttable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectSummaryEvent;
import com.ibm.mq.explorer.core.internal.event.DmQueueManagerListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManagerHandle;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTable;
import org.eclipse.swt.widgets.Display;

public class ObjectTableDMListener
implements DmQueueManagerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/objecttable/ObjectTableDMListener.java";
    private ObjectTable objectTable = null;
    private DmObject dmObject = null;
    private boolean isObserving = false;
    private IDmObservable observable = null;

    public ObjectTableDMListener(Trace t, ObjectTable objTable) {
        this.objectTable = objTable;
    }

    public boolean startListening(Trace t, IDmObservable observe, DmObjectFilter filter) {
        boolean ret = false;
        if (Trace.isTracing) {
            String traceText = "";
            traceText = filter == null ? "null filter passed in, this doesn't matter, just listen with a null filter" : "filter passed to start listening call: " + filter.toString(t);
            t.data(67, "ObjectTableDMListener.startListening", 300, traceText);
            t.data(67, "ObjectTableDMListener.startListening", 300, "Adding observer to observable object " + observe.getObservableName());
        }
        if (ret = observe.addObserver(t, (DmObjectListener)this, filter)) {
            if (Trace.isTracing) {
                t.data(67, "ObjectTableDMListener.startListening", 300, "Listen succesful");
            }
            this.isObserving = true;
            this.observable = observe;
        } else {
            if (Trace.isTracing) {
                t.data(67, "ObjectTableDMListener.startListening", 900, "Failed to add observer to observable object " + observe.getObservableName());
            }
            this.isObserving = false;
            this.observable = null;
        }
        return ret;
    }

    public boolean stopListening(Trace t, IDmObservable observe) {
        boolean ret = false;
        if (observe != null && this.isObserving) {
            if (Trace.isTracing) {
                t.data(67, "ObjectTableDMListener.stopListening", 300, "stopping listen to: " + observe);
            }
            ret = observe.deleteObserver(t, (DmObjectListener)this);
        } else if (Trace.isTracing) {
            t.data(67, "ObjectTableDMListener.stopListening", 900, "null observable passed in");
        }
        if (Trace.isTracing) {
            if (ret) {
                t.data(67, "ObjectTableDMListener.stopListening", 300, "Succesfully removed listener");
            } else {
                t.data(67, "ObjectTableDMListener.stopListening", 900, "failed to removed listener");
            }
        }
        this.isObserving = false;
        this.observable = null;
        this.dmObject = null;
        return ret;
    }

    private void refreshObjectTableItem(DmObject dmObj) {
        Trace t = Trace.getDefault();
        final DmObject object = dmObj;
        if (this.objectTable != null) {
            if (Trace.isTracing) {
                t.data(67, "ObjectTableDMListener.refreshObjectTableItem", 500, "refreshing object " + dmObj.toString(t));
            }
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ObjectTableDMListener.this.objectTable.isDisposed()) {
                        ObjectTableDMListener.this.objectTable.refreshItem(object);
                    } else if (Trace.isTracing) {
                        Trace tr = Trace.getDefault();
                        tr.data(67, "ObjectTableDMListener.refreshObjectTableItem", 300, "ignored, table is disposed");
                    }
                }
            });
        }
    }

    private void refreshObjectTableRefreshTime() {
        if (this.objectTable != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ObjectTableDMListener.this.objectTable.isDisposed()) {
                        ObjectTableDMListener.this.objectTable.updateLastRefreshText();
                    } else if (Trace.isTracing) {
                        Trace tr = Trace.getDefault();
                        tr.data(67, "ObjectTableDMListener.refreshObjectTableRefreshTime", 300, "ignored, table is disposed");
                    }
                }
            });
        }
    }

    public void dmObjectAdded(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        if (Trace.isTracing) {
            String logText = "dmObjectAdded event received - ";
            logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
            logText = String.valueOf(logText) + " name=" + object.toString(t);
            if (event.isLast()) {
                logText = String.valueOf(logText) + ", last=true";
            }
            t.data(67, "ObjectTableDMListener.dmObjectAdded", 500, logText);
        }
        if (this.dmObject == null || this.dmObject == object) {
            this.refreshObjectTableItem(object);
        } else if (Trace.isTracing) {
            t.data(67, "ObjectTableDMListener.dmObjectAdded", 900, "Ignore object add - there is already an object in the table");
        }
    }

    public void dmObjectChanged(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmObject object = (DmObject)event.getSource();
        if (Trace.isTracing) {
            String logText = "dmObjectChanged event received - ";
            logText = String.valueOf(logText) + "type=" + object.getObjectType(t);
            logText = String.valueOf(logText) + " name=" + object.toString(t);
            if (event.isLast()) {
                logText = String.valueOf(logText) + ", last=true";
            }
            t.data(67, "ObjectTableDMListener.dmObjectChanged", 500, logText);
        }
        boolean isMatchingObject = false;
        if (object != null && this.dmObject != null) {
            if (object.getObjectType(t) == 2 && this.dmObject.getObjectType(t) == 1002) {
                DmQueueManagerHandle objDmQueueManagerHandle = ((DmQueueManager)object).getConnectionHandle();
                if (objDmQueueManagerHandle == this.dmObject) {
                    isMatchingObject = true;
                }
            } else if (object.getObjectType(t) == 1002 && this.dmObject.getObjectType(t) == 2) {
                DmQueueManagerHandle dmObjDmQueueManagerHandle = ((DmQueueManager)this.dmObject).getConnectionHandle();
                if (dmObjDmQueueManagerHandle == object) {
                    isMatchingObject = true;
                }
            } else if (object == this.dmObject) {
                isMatchingObject = true;
            }
        }
        if (isMatchingObject) {
            this.refreshObjectTableItem(object);
        }
    }

    public void dmObjectDeleted(DmObjectEvent event) {
        if (!UiPlugin.isShutdownInProgress()) {
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ObjectTableDMListener.this.objectTable.removeAll(Trace.getDefault());
                    ObjectTableDMListener.this.dmObject = null;
                }
            });
        }
    }

    public void dmQueueManagerShown(DmObjectEvent event) {
    }

    public void dmQueueManagerHidden(DmObjectEvent event) {
    }

    public void dmQueueManagerConnected(DmObjectEvent event) {
    }

    public void dmQueueManagerDisconnected(DmObjectEvent event) {
        this.clearObjectTable(Trace.getDefault());
    }

    public void dmRefreshComplete(DmObjectEvent event) {
        Trace t = Trace.getDefault();
        DmCoreException e = event.getException();
        if (e != null) {
            if (Trace.isTracing) {
                t.data(67, "ObjectTableDMListener.dmRefreshComplete", 900, "refresh completed with unexpected error: cc=" + e.getCompCode() + " rc=" + e.getReasonCode());
            }
            this.displayExceptionErrorMessage(t, e);
            this.clearObjectTable(t);
        } else if (Trace.isTracing) {
            t.data(67, "ObjectTableDMListener.dmRefreshComplete", 500, "refresh completed");
        }
        this.refreshObjectTableRefreshTime();
    }

    public void dmObjectListDone(DmObjectListEvent event) {
    }

    public void setDmObject(DmObject dmObj) {
        this.dmObject = dmObj;
    }

    public void dmQueueManagerConnecting(DmObjectEvent event) {
    }

    public void dmObjectSummary(DmObjectSummaryEvent event) {
        DmCoreException e;
        final Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "ObjectTableDMListener.dmObjectSummary", 300, "count = " + event.getCount());
        }
        if ((e = event.getException()) != null) {
            switch (e.getReasonCode()) {
                case 2009: 
                case 2033: 
                case 2322: {
                    if (Trace.isTracing) {
                        t.data(67, "ObjectTableDMListener.dmObjectSummary", 900, "dmObjectSummary with connection or timeout error, stop listening");
                    }
                    if (UiPlugin.isShutdownInProgress()) break;
                    UiPlugin.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ObjectTableDMListener.this.objectTable.isDisposed()) {
                                if (ObjectTableDMListener.this.isObserving) {
                                    ObjectTableDMListener.this.objectTable.stopListener(t, ObjectTableDMListener.this.observable);
                                }
                                ObjectTableDMListener.this.objectTable.removeAll(t);
                            }
                        }
                    });
                    break;
                }
                default: {
                    if (Trace.isTracing) {
                        t.data(67, "ObjectTableDMListener.dmObjectSummary", 900, "dmObjectSummary with unexpected error: cc=" + e.getCompCode() + " rc=" + e.getReasonCode());
                    }
                    this.displayExceptionErrorMessage(t, e);
                    this.clearObjectTable(t);
                }
            }
        }
        this.refreshObjectTableRefreshTime();
    }

    private void displayExceptionErrorMessage(final Trace t, final DmCoreException e) {
        if (!UiPlugin.isShutdownInProgress()) {
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ObjectTableDMListener.this.objectTable.isDisposed()) {
                        MessageBox.showExceptionMessage(t, UiPlugin.getShell(), e);
                    }
                }
            });
        }
    }

    private void clearObjectTable(final Trace t) {
        if (!UiPlugin.isShutdownInProgress()) {
            UiPlugin.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ObjectTableDMListener.this.objectTable.isDisposed()) {
                        ObjectTableDMListener.this.objectTable.removeAll(t);
                    }
                }
            });
        }
    }

    public boolean isObserving() {
        return this.isObserving;
    }
}

