/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.objecttable;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrder;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderChangedEvent;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderItem;
import com.ibm.mq.explorer.ui.internal.attributeorder.AttributeOrderManager;
import com.ibm.mq.explorer.ui.internal.attributeorder.CompareAttributeOrderItems;
import com.ibm.mq.explorer.ui.internal.attributeorder.IAttributeOrderChangedListener;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtTableGreyCellManager;
import com.ibm.mq.explorer.ui.internal.explorertable.ExplorerTable;
import com.ibm.mq.explorer.ui.internal.explorertable.SchemeBar;
import com.ibm.mq.explorer.ui.internal.explorertable.StatusBar;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTableContentChangedEvent;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTableContentChangedListener;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTableContentProvider;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTableDMListener;
import com.ibm.mq.explorer.ui.internal.objecttable.ObjectTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.queuemanager.IQueueManagerDisconnectActionListener;
import com.ibm.mq.explorer.ui.internal.queuemanager.QueueManagerDisconnectActionEvent;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ObjectTable
extends Composite
implements IAttributeOrderChangedListener,
DisposeListener,
IQueueManagerDisconnectActionListener,
IPropertyChangeListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/objecttable/ObjectTable.java";
    private Table table = null;
    private SchemeBar schemeBar = null;
    protected TableColumn tabcolName = null;
    protected TableColumn tabcolValue = null;
    private Action actionEditProperties = null;
    private String objectId = "";
    private AttributeOrderManager attrOrderManager = null;
    private String orderId = null;
    private AttributeOrder attrOrder = null;
    private UiMQObject uiMQObject = null;
    private String nlsEditProps = "";
    private ObjectTableDMListener objectTableDMListener = null;
    private boolean isSchemeBar = true;
    private String instanceId = null;
    private boolean isInstanceSecondary = false;
    private boolean isStatusBar = false;
    private StatusBar statusBar = null;
    private Message msgFile = null;
    private IUiMQObjectFactory uiMQObjectFactory = null;
    private UiMQObject parentObjectForFactory = null;
    private int preferWidthNameColumn = 0;
    private Integer explicitFilterQSGDisposition = null;
    private Vector<ObjectTableContentChangedListener> contentChangedListeners = null;
    private TableViewer tableViewer = null;
    private ObjectTableContentProvider contentProvider = null;
    private ObjectTableLabelProvider labelProvider = null;
    private boolean isResizeColumnsTimerRunning = false;
    private boolean isResizeColumnsWhenTimerPops = false;
    private boolean isEnabled = true;
    private boolean isObserving = false;
    private IDmObservable observable = null;
    private DmObjectFilter filter = null;

    public ObjectTable(Trace t, Composite parent, int style, boolean showSchemeBar, boolean showStatusBar, boolean contextMenu) {
        super(parent, style);
        this.isSchemeBar = showSchemeBar;
        this.isStatusBar = showStatusBar;
        this.attrOrderManager = UiPlugin.getAttributeOrderManager();
        this.contentChangedListeners = new Vector();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Tables");
        this.nlsEditProps = this.msgFile.getMessage(t, "UI.TABLES.Menu.EditProps");
        this.objectTableDMListener = new ObjectTableDMListener(t, this);
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        this.table = new Table((Composite)this, 68356);
        this.table.setHeaderVisible(false);
        this.table.setLinesVisible(true);
        this.table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (ObjectTable.this.table.getSelectionIndices().length == 0 && ObjectTable.this.table.getItems().length > 0) {
                    ObjectTable.this.table.setSelection(ObjectTable.this.table.getTopIndex());
                }
            }
        });
        this.tabcolName = new TableColumn(this.table, 0);
        this.tabcolValue = new TableColumn(this.table, 0);
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Trace tr = Trace.getDefault();
                ObjectTable.this.resizeTableColumns(tr, false, true);
            }
        });
        this.table.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeiconified(ShellEvent e) {
                Trace tr = Trace.getDefault();
                ObjectTable.this.startListeningAfterMinimised(tr);
            }

            public void shellIconified(ShellEvent e) {
                Trace tr = Trace.getDefault();
                ObjectTable.this.stopListeningWhileMinimised(tr);
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.contentProvider = new ObjectTableContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new ObjectTableLabelProvider();
        this.labelProvider.setTable(this.table);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)gridData);
        if (contextMenu) {
            this.hookTableContextMenu(t);
        }
        if (this.isSchemeBar) {
            this.schemeBar = new SchemeBar(t, this, 2048);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            this.schemeBar.setLayoutData(gridData);
        }
        if (this.isStatusBar) {
            this.statusBar = new StatusBar(t, this, 0);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gridData.grabExcessHorizontalSpace = true;
            this.statusBar.setLayoutData(gridData);
        }
        this.attrOrderManager.addChangedListener(t, this);
        this.addDisposeListener(this);
        UiPlugin.addQueueManagerDisconnectActionListener(t, this);
        UiPlugin.getPrefStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.table.addDisposeListener((DisposeListener)this);
    }

    public void setStatus(Trace t, String status) {
        if (this.isStatusBar && this.statusBar != null && !this.statusBar.isDisposed()) {
            this.statusBar.showMessage(t, status);
        }
    }

    public void removeAll(Trace t) {
        if (!this.table.isDisposed()) {
            this.table.removeAll();
            ExtTableGreyCellManager greyCellMgr = this.labelProvider.getGreyCellManager();
            greyCellMgr.removeAllObjectsFromList();
            this.uiMQObject = null;
            this.tabcolName.setData(null);
            this.tabcolValue.setData(null);
        }
        this.sendContentChangedEvent(t);
    }

    public void setObjectId(Trace t, String objId) {
        this.objectId = objId;
    }

    public void setAttributeOrderId(Trace t, String id) {
        this.orderId = id;
        AttributeOrder attOrder = null;
        if (this.attrOrderManager.isRegistered(t, this.orderId)) {
            attOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, this.instanceId);
        }
        if (attOrder == null) {
            t.FFST(67, "ObjectTable.setAttributeOrderId", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeORder", this.orderId, this.instanceId);
        } else {
            this.attrOrder = attOrder;
        }
        if (this.isSchemeBar) {
            this.schemeBar.setScheme(t, this.attrOrder);
        }
    }

    private static void sortAttributeOrderItems(Trace t, ArrayList<AttributeOrderItem> attrItems, boolean isSecondary) {
        CompareAttributeOrderItems compareAttrItems = new CompareAttributeOrderItems(t, isSecondary);
        int count = attrItems.size();
        AttributeOrderItem[] attrItemArray = new AttributeOrderItem[count];
        attrItemArray = attrItems.toArray(attrItemArray);
        Arrays.sort(attrItemArray, compareAttrItems);
        attrItems.clear();
        int i = 0;
        while (i < count) {
            attrItems.add(attrItemArray[i]);
            ++i;
        }
    }

    public void setInstance(Trace t, String instId, boolean isSecondary) {
        if (this.isDifferentInstance(t, instId, isSecondary)) {
            this.instanceId = instId;
            this.isInstanceSecondary = isSecondary;
            if (this.isSchemeBar) {
                this.schemeBar.setInstance(t, this.instanceId, this.isInstanceSecondary);
            }
            if (this.attrOrderManager.isRegistered(t, this.orderId)) {
                this.attrOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, this.instanceId);
            }
            if (this.attrOrder == null) {
                t.FFST(67, "ObjectTable.setInstance", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeORder", this.orderId, this.instanceId);
            }
            if (this.isSchemeBar) {
                this.schemeBar.setScheme(t, this.attrOrder);
            }
        }
    }

    private boolean isDifferentInstance(Trace t, String instId, boolean isSecondary) {
        boolean result = false;
        boolean instanceIdDifferent = true;
        if (instId == null && this.instanceId == null) {
            instanceIdDifferent = false;
        } else if (instId == null || this.instanceId == null) {
            instanceIdDifferent = true;
        } else if (instId.compareTo(this.instanceId) == 0) {
            instanceIdDifferent = false;
        }
        boolean isSecondaryDifferent = isSecondary ^ this.isInstanceSecondary;
        result = instanceIdDifferent || isSecondaryDifferent;
        return result;
    }

    public void refresh() {
        Trace t = Trace.getDefault();
        if (this.isObserving) {
            this.observable.refreshObservable(t);
        }
    }

    private void showObjectInTable(Trace t, UiMQObject object) {
        if (this.table.isDisposed()) {
            return;
        }
        this.tabcolName.setData((Object)object);
        this.tabcolValue.setData((Object)object);
        IDmObject dmObject = object.getDmObject();
        int topIndex = -1;
        if (this.uiMQObject == object) {
            topIndex = this.table.getTopIndex();
        }
        this.table.removeAll();
        ExtTableGreyCellManager greyCellMgr = this.labelProvider.getGreyCellManager();
        greyCellMgr.removeAllObjectsFromList();
        this.uiMQObject = object;
        ArrayList<AttributeOrderItem> attrOrderItems = this.attrOrder.getAttributeOrderItems(t);
        ArrayList<AttributeOrderItem> showItems = new ArrayList<AttributeOrderItem>();
        int i = 0;
        while (i < attrOrderItems.size()) {
            AttributeOrderItem attrOrderItem = attrOrderItems.get(i);
            if (attrOrderItem.getAttributePosition(this.isInstanceSecondary) != -2 && attrOrderItem.getAttributePosition(this.isInstanceSecondary) != -1) {
                boolean repeating = false;
                Attr attr = dmObject.getAttribute(t, attrOrderItem.getAttributeId(), 0);
                if (attr != null) {
                    repeating = attr.getAttrType().isRepeating();
                }
                if (!repeating) {
                    showItems.add(attrOrderItem);
                }
            }
            ++i;
        }
        ObjectTable.sortAttributeOrderItems(t, showItems, this.isInstanceSecondary);
        this.tableViewer.setInput(showItems);
        this.tableViewer.refresh();
        ExplorerTable.paintGreyCells(t, this.table, this.labelProvider);
        this.resizeTableColumns(t, true, false);
        this.updateLastRefreshText();
        this.sendContentChangedEvent(t);
        if (topIndex != -1) {
            this.table.setTopIndex(topIndex);
        }
    }

    public void setObject(Trace t, UiMQObject object) {
        this.setObject(t, object, true);
    }

    public void setObject(Trace t, UiMQObject object, boolean isListen) {
        this.uiMQObject = object;
        if (this.uiMQObject != null) {
            if (isListen && this.objectTableDMListener != null) {
                this.objectTableDMListener.setDmObject((DmObject)this.uiMQObject.getDmObject());
            }
        } else {
            this.objectTableDMListener.setDmObject(null);
        }
        if (this.isEnabled && !this.table.isDisposed()) {
            this.table.removeAll();
            ExtTableGreyCellManager greyCellMgr = this.labelProvider.getGreyCellManager();
            greyCellMgr.removeAllObjectsFromList();
            if (object != null) {
                this.showObjectInTable(t, object);
            }
        }
    }

    private void hookTableContextMenu(Trace t) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Trace tr = Trace.getDefault();
                ObjectTable.this.fillTableContextMenu(tr, manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(menu);
    }

    private void fillTableContextMenu(Trace t, IMenuManager manager) {
        if (this.actionEditProperties == null) {
            this.actionEditProperties = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    ObjectTable.this.showProperties(tr);
                }
            };
            this.actionEditProperties.setText(this.nlsEditProps);
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionEditProperties, "com.ibm.mq.explorer.ui.infopop.UI_EditPropertiesMenuItem");
        }
        this.actionEditProperties.setEnabled(this.uiMQObject != null);
        if (this.uiMQObject != null && this.uiMQObject.isAllowProperties()) {
            manager.add((IAction)this.actionEditProperties);
            manager.add((IContributionItem)new Separator());
        }
    }

    public void showProperties(Trace t) {
        t.data(67, "ObjectTable.showProperties", 300, "ObjectTable: showProperties");
        this.uiMQObject.showProperties(t);
    }

    public boolean startListener(Trace t, IDmObservable observe) {
        boolean result = this.startListener(t, observe, null, false);
        return result;
    }

    public boolean startListener(Trace t, IDmObservable observe, int objId) {
        DmObjectFilter dmObjectFilter;
        boolean result = false;
        this.filter = dmObjectFilter = new DmObjectFilter(t, objId);
        result = this.startListener(t, observe, dmObjectFilter, false);
        return result;
    }

    public boolean startListener(Trace t, IDmObservable observe, DmObjectFilter fltr) {
        boolean result = false;
        boolean filterProvided = true;
        if (fltr == null) {
            filterProvided = false;
        }
        result = this.startListener(t, observe, fltr, filterProvided);
        return result;
    }

    private boolean startListener(Trace t, IDmObservable observe, DmObjectFilter fltr, boolean isExplicit) {
        boolean result = false;
        if (Trace.isTracing) {
            t.data(67, "ObjectTable.startListener", 300, "starting clear up");
        }
        this.uiMQObject = null;
        this.removeAll(t);
        if (isExplicit && this.explicitFilterQSGDisposition != null) {
            fltr.setDisp(t, this.explicitFilterQSGDisposition.intValue());
            if (Trace.isTracing) {
                t.data(67, "ObjectTable.startListener", 300, "setting QSG disp on explicit filter");
            }
        }
        if (observe != null) {
            result = this.objectTableDMListener.startListening(t, observe, fltr);
        } else if (Trace.isTracing) {
            t.data(67, "ObjectTable.startListener", 900, "null observable passed!");
        }
        if (result) {
            this.isObserving = true;
            this.observable = observe;
            this.filter = fltr;
        } else {
            this.isObserving = false;
            if (Trace.isTracing) {
                t.data(67, "ObjectTable.startListener", 900, "failed to start listening");
            }
            if (isExplicit) {
                String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4169");
                MessageBox.showMessageFailure(t, this.getShell(), msg, "AMQ4169");
            } else {
                String msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4168");
                MessageBox.showMessageFailure(t, this.getShell(), msg, "AMQ4168");
            }
        }
        return result;
    }

    public boolean stopListener(Trace t, IDmObservable observe) {
        boolean result = false;
        result = this.objectTableDMListener.stopListening(t, observe);
        if (result) {
            if (Trace.isTracing) {
                t.data(67, "ObjectTable.stopListener", 300, "stopped listening - clearing up");
            }
            this.uiMQObject = null;
            this.removeAll(t);
            this.observable = null;
            this.isObserving = false;
        } else if (Trace.isTracing) {
            t.data(67, "ObjectTable.stopListener", 900, "failed to stop listening");
        }
        return result;
    }

    public boolean isObserving(Trace t) {
        boolean result = false;
        if (this.isObserving) {
            result = true;
        }
        return result;
    }

    protected boolean refreshItem(Object item) {
        Trace t = Trace.getDefault();
        boolean result = false;
        boolean objectInTable = false;
        this.tabcolName.setData(null);
        this.tabcolValue.setData(null);
        if (item instanceof UiMQObject) {
            UiMQObject uiMQObj = null;
            uiMQObj = (UiMQObject)item;
            if (uiMQObj.equals(this.uiMQObject)) {
                objectInTable = true;
            }
        } else if (item instanceof DmObject) {
            DmObject dmObject = (DmObject)item;
            if (this.uiMQObject == null) {
                if (this.uiMQObjectFactory != null) {
                    this.uiMQObject = this.uiMQObjectFactory.create(t, (IDmObject)dmObject, this.parentObjectForFactory);
                    if (this.uiMQObject != null) {
                        t.data(67, "ObjectTable.refreshItem", 300, "adding UiMQObject " + this.uiMQObject.toString());
                        objectInTable = true;
                        if (this.objectTableDMListener != null) {
                            this.objectTableDMListener.setDmObject((DmObject)this.uiMQObject.getDmObject());
                        }
                    }
                } else {
                    t.data(67, "ObjectTable.refreshItem", 300, "No object factory, unable to make UiMQObject from object " + item.toString());
                }
            } else {
                String storedTitle = this.uiMQObject.getDmObject().getTitle();
                String newTitle = dmObject.getTitle();
                if (newTitle.startsWith(storedTitle)) {
                    objectInTable = true;
                }
            }
        }
        if (objectInTable) {
            if (Trace.isTracing) {
                t.data(67, "ObjectTable.refreshItem", 300, "refreshing UiMQObject " + this.uiMQObject.toString());
            }
            if (this.isEnabled && !this.table.isDisposed()) {
                this.table.removeAll();
                ExtTableGreyCellManager greyCellMgr = this.labelProvider.getGreyCellManager();
                greyCellMgr.removeAllObjectsFromList();
                this.showObjectInTable(t, this.uiMQObject);
            }
            result = true;
        }
        return result;
    }

    @Override
    public void changed(AttributeOrderChangedEvent e) {
    }

    @Override
    public void selectionChanged(AttributeOrderChangedEvent e) {
        Trace t = Trace.getDefault();
        if (this.orderId != null && e.getOrderId().compareTo(this.orderId) == 0) {
            this.attrOrder = this.attrOrderManager.getRegisteredCurrentAttributeOrder(t, this.orderId, this.instanceId);
            if (this.attrOrder == null) {
                t.FFST(67, "ObjectTable.selectionChanged", 10, 50020, 0, 0, "Failed to get RegisteredCurrentAttributeOrder", this.orderId, this.instanceId);
            }
            if (this.uiMQObject != null) {
                this.showObjectInTable(t, this.uiMQObject);
            }
            if (this.isSchemeBar) {
                this.schemeBar.setScheme(t, this.attrOrder);
            }
        }
    }

    public void updateLastRefreshText() {
        Trace t = Trace.getDefault();
        if (this.isStatusBar && this.isTableEnabled()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
            String dateString = dateFormat.format(new Date());
            String statusText = this.msgFile.getMessage(t, "UI.TABLES.Table.Status.Update", dateString);
            this.setStatus(t, statusText);
        }
    }

    public String getObjectId() {
        return this.objectId;
    }

    public void setUiMQObjectFactoryClass(Trace t, IUiMQObjectFactory factoryClass, UiMQObject parentToNewObjects) {
        this.uiMQObjectFactory = factoryClass;
        this.parentObjectForFactory = parentToNewObjects;
    }

    public void greyValueCells(Trace t) {
        if (!this.isDisposed()) {
            this.table.removeAll();
            ExtTableGreyCellManager greyCellMgr = this.labelProvider.getGreyCellManager();
            greyCellMgr.removeAllObjectsFromList();
            int iRow = 0;
            int i = 0;
            while (i < this.attrOrder.size()) {
                AttributeOrderItem attrOrderItem = this.attrOrder.getAttributeOrderItemFromPosition(t, i, this.isInstanceSecondary);
                if (attrOrderItem != null) {
                    String attrName = attrOrderItem.getAttributeName();
                    String attrValue = "";
                    TableItem tableItem = new TableItem(this.table, 0, iRow++);
                    tableItem.setText(0, attrName);
                    tableItem.setText(1, attrValue);
                    Color color = UiPlugin.getDisabledColor();
                    tableItem.setBackground(1, color);
                    tableItem.setForeground(1, color);
                }
                ++i;
            }
        }
    }

    private void resizeTableColumns(Trace t, boolean isNewObject, boolean canDelay) {
        if (Trace.isTracing) {
            Date date = new Date();
            t.data(67, "ObjectTable.resizeTableColumns", 300, "resizeTableColumns at " + date.toString());
        }
        if (isNewObject) {
            this.preferWidthNameColumn = 0;
        }
        if (this.isResizeColumnsTimerRunning && canDelay) {
            this.isResizeColumnsWhenTimerPops = true;
            if (Trace.isTracing) {
                t.data(67, "ObjectTable.resizeTableColumns", 300, "timer running, just setting isResizeColumnsWhenTimerPops flag");
            }
        } else {
            int timerDelay = UiPlugin.getResizeColumnsTimerDelay() / 5;
            this.isResizeColumnsWhenTimerPops = false;
            if (timerDelay > 0) {
                this.table.getDisplay().timerExec(timerDelay, new Runnable(){

                    @Override
                    public void run() {
                        Trace tr = Trace.getDefault();
                        if (Trace.isTracing) {
                            tr.data(67, "ObjectTable.resizeTableColumns", 300, "resize columns timer popped");
                        }
                        if (ObjectTable.this.isResizeColumnsWhenTimerPops) {
                            if (Trace.isTracing) {
                                tr.data(67, "ObjectTable.resizeTableColumns", 300, "flag set, resizing columns");
                            }
                            ObjectTable.this.resizeColumns(tr);
                        }
                        ObjectTable.this.isResizeColumnsTimerRunning = false;
                        ObjectTable.this.isResizeColumnsWhenTimerPops = false;
                    }
                });
                this.isResizeColumnsTimerRunning = true;
            }
            this.resizeColumns(t);
        }
    }

    private void resizeColumns(Trace t) {
        if (UiPlugin.isShutdownInProgress() || this.table.isDisposed()) {
            return;
        }
        this.table.setRedraw(false);
        int width = this.tabcolName.getWidth();
        int testwidth = 111;
        if (width == testwidth) {
            ++testwidth;
        }
        this.tabcolName.setWidth(testwidth);
        if (this.tabcolName.getWidth() != testwidth) {
            this.tabcolName.pack();
            this.tabcolValue.pack();
        } else {
            Point sizeTable = this.table.getSize();
            if (this.preferWidthNameColumn == 0) {
                this.tabcolName.pack();
                this.preferWidthNameColumn = this.tabcolName.getWidth();
            }
            this.tabcolName.setWidth(this.preferWidthNameColumn);
            int nameWidth = this.preferWidthNameColumn;
            this.tabcolValue.pack();
            int valueWidth = this.tabcolValue.getWidth();
            int availableWidth = sizeTable.x - UiUtils.getVScrollBarWidth(t, this.table) - 3 * this.table.getGridLineWidth() - 1;
            int spareWidth = availableWidth - nameWidth - valueWidth;
            if (spareWidth > 0) {
                if (nameWidth < sizeTable.x / 3) {
                    nameWidth = sizeTable.x / 3;
                } else if (nameWidth < sizeTable.x / 2) {
                    nameWidth = sizeTable.x / 2;
                }
                this.tabcolName.setWidth(nameWidth);
                valueWidth = availableWidth - nameWidth;
                this.tabcolValue.setWidth(valueWidth);
            }
        }
        this.table.setRedraw(true);
    }

    public int getItemHeight() {
        int height = -1;
        if (this.table != null) {
            height = this.table.getItemHeight() + this.table.getGridLineWidth();
        }
        return height;
    }

    public void setEnabled(boolean enabled) {
        Trace t = Trace.getDefault();
        super.setEnabled(enabled);
        if (this.table != null) {
            this.table.setEnabled(enabled);
            if (!enabled) {
                this.setStatus(t, "");
            }
        }
        this.isEnabled = enabled;
    }

    public void addContentChangedListener(Trace t, ObjectTableContentChangedListener listener) {
        this.contentChangedListeners.addElement(listener);
    }

    public void removeContentChangedListener(Trace t, ObjectTableContentChangedListener listener) {
        this.contentChangedListeners.removeElement(listener);
    }

    private void sendContentChangedEvent(Trace t) {
        ObjectTableContentChangedEvent ccEvent = new ObjectTableContentChangedEvent(this);
        int size = this.contentChangedListeners.size();
        int i = 0;
        while (i < size) {
            ObjectTableContentChangedListener listener = this.contentChangedListeners.elementAt(i);
            listener.contentChanged(ccEvent);
            ++i;
        }
    }

    public UiMQObject getObject(Trace t) {
        return this.uiMQObject;
    }

    public void widgetDisposed(DisposeEvent e) {
        if (e.getSource().equals(this)) {
            Trace t = Trace.getDefault();
            this.attrOrderManager.removeChangedListener(t, this);
            UiPlugin.removeQueueManagerDisconnectActionListener(t, this);
            UiPlugin.getPrefStore().removePropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private void stopListeningWhileMinimised(Trace t) {
        if (this.isObserving && this.observable != null) {
            this.objectTableDMListener.stopListening(t, this.observable);
        }
    }

    private void startListeningAfterMinimised(Trace t) {
        if (this.isObserving && this.observable != null) {
            this.objectTableDMListener.startListening(t, this.observable, this.filter);
        }
    }

    public boolean isTableEnabled() {
        return this.isEnabled;
    }

    @Override
    public void queueManagerBeingDisconnected(QueueManagerDisconnectActionEvent event) {
        Trace t = Trace.getDefault();
        DmQueueManager dmQmgr = event.getDmQueueManager();
        if (this.isObserving && dmQmgr.equals((Object)this.observable)) {
            this.stopListener(t, this.observable);
            this.removeAll(t);
        }
    }

    public void setTickCrossMode(Trace t, boolean isTickCross) {
        this.setTickCrossMode(t, isTickCross, null, null);
    }

    public void setTickCrossMode(Trace t, boolean isTickCross, Image imgTick, Image imgCross) {
        if (this.labelProvider != null) {
            this.labelProvider.setTickCrossMode(isTickCross, imgTick, imgCross);
            this.refreshItem(this.uiMQObject);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        Trace t = Trace.getDefault();
        String strProperty = event.getProperty();
        if (strProperty.compareTo("InvalidCellColorChanged") == 0) {
            ExplorerTable.paintGreyCells(t, this.table, this.labelProvider);
        }
    }
}

