/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrInt;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeBoolean;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.comparewith.CompareWithProvider;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.DialogClosedEvent;
import com.ibm.mq.explorer.ui.internal.properties.IDialogClosedListener;
import com.ibm.mq.explorer.ui.internal.properties.PropertyDlg;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.status.StatusDialog;
import com.ibm.mq.explorer.ui.internal.status.UiConfigurationProvider;
import com.ibm.mq.explorer.ui.internal.status.UiStatusProvider;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionFilter;

public abstract class UiMQObject
extends UiObject
implements IDialogClosedListener,
DmActionListener,
IActionFilter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/objects/UiMQObject.java";
    private IDmObject dmObject = null;
    private Action actionProperties = null;
    private Action actionConfiguration = null;
    private Action[] actionConfigurationArray = null;
    private Action actionStatus = null;
    private Action[] actionStatusArray = null;
    protected Shell shell = null;
    private PropertyDlg propertyDlg = null;
    private Message msgFile = null;
    private UiConfigurationProvider uiConfigurationProvider = null;
    private UiStatusProvider uiStatusProvider = null;
    private CompareWithProvider compareWithProvider = null;
    protected BusyDialog busyDialog = null;

    public UiMQObject() {
    }

    public UiMQObject(Trace t, IDmObject dmObj) {
        this.dmObject = dmObj;
        this.shell = UiPlugin.getShell();
    }

    public IDmObject getDmObject() {
        return this.dmObject;
    }

    public abstract int getDataModelObjectType(Trace var1);

    public abstract boolean isSupportDelete();

    public abstract boolean isAllowProperties();

    public abstract String getObjectType();

    public abstract String getNLSResourceFileKey();

    public abstract boolean isChangeProperties(Trace var1);

    public UiStatusProvider getStatusProvider(Trace t) {
        return this.uiStatusProvider;
    }

    public CompareWithProvider getCompareWithProvider(Trace t) {
        return this.compareWithProvider;
    }

    @Override
    public void appendToContextMenu(Shell sh, IMenuManager manager, Object contextObject) {
        String helpId;
        int i;
        MenuManager submanager;
        Object contextObj;
        Trace t = Trace.getDefault();
        this.shell = sh;
        manager.add((IContributionItem)new GroupMarker("group1"));
        this.uiStatusProvider = this.getStatusProvider(t);
        if (this.uiStatusProvider != null && this.uiStatusProvider.getStatusInstances(t, this, contextObject) != 0) {
            String[] statusTypes = this.uiStatusProvider.getStatusTypes(t, this);
            if (statusTypes.length == 1) {
                if (this.actionStatus == null) {
                    contextObj = contextObject;
                    this.actionStatus = new Action(){

                        public void run() {
                            Trace tr = Trace.getDefault();
                            UiMQObject.this.showStatus(tr, this.getId(), contextObj);
                        }
                    };
                    this.actionStatus.setText(this.uiStatusProvider.getActionText(t));
                    UiPlugin.getHelpSystem().setHelp((IAction)this.actionStatus, "com.ibm.mq.explorer.ui.infopop.UI_StatusMenuItem");
                    this.actionStatus.setId(statusTypes[0]);
                }
                manager.add((IAction)this.actionStatus);
            } else if (statusTypes.length > 1) {
                submanager = new MenuManager(this.uiStatusProvider.getMenuText(t));
                manager.add((IContributionItem)submanager);
                if (this.actionStatusArray == null) {
                    final Object contextObj2 = contextObject;
                    this.actionStatusArray = new Action[statusTypes.length];
                    i = 0;
                    while (i < statusTypes.length) {
                        this.actionStatusArray[i] = new Action(){

                            public void run() {
                                Trace tr = Trace.getDefault();
                                UiMQObject.this.showStatus(tr, this.getId(), contextObj2);
                            }
                        };
                        this.actionStatusArray[i].setText(this.uiStatusProvider.getMenuTextForStatusType(t, statusTypes[i]));
                        this.actionStatusArray[i].setId(statusTypes[i]);
                        helpId = this.uiStatusProvider.getMenuHelpIdForStatusType(t, statusTypes[i]);
                        if (helpId == null) {
                            helpId = this.uiStatusProvider.isGenericStatus(t) ? "com.ibm.mq.explorer.ui.infopop.UI_StatusGenericMenuItem" : "com.ibm.mq.explorer.ui.infopop.UI_StatusMenuItem";
                        }
                        UiPlugin.getHelpSystem().setHelp((IAction)this.actionStatusArray[i], helpId);
                        ++i;
                    }
                }
                int i2 = 0;
                while (i2 < statusTypes.length) {
                    submanager.add((IAction)this.actionStatusArray[i2]);
                    ++i2;
                }
            }
        }
        if (this.actionProperties == null) {
            this.actionProperties = new Action(){

                public void run() {
                    Trace tr = Trace.getDefault();
                    UiMQObject.this.showProperties(tr);
                }
            };
            this.actionProperties.setText(UiPlugin.getNLSString(t, "KEY_Properties", "UI.PROP.Properties.Action"));
            UiPlugin.getHelpSystem().setHelp((IAction)this.actionProperties, this.getHelpIdForProperties());
        }
        manager.add((IContributionItem)new GroupMarker("group2"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new GroupMarker("additions_p2"));
        this.uiConfigurationProvider = this.getUiConfigurationProvider();
        if (this.uiConfigurationProvider != null && this.uiConfigurationProvider.getConfigurationInstances(t, this, contextObject) != 0) {
            String[] configurationTypes = this.uiConfigurationProvider.getConfigurationTypes(t, this);
            if (configurationTypes.length == 1) {
                if (this.actionConfiguration == null) {
                    contextObj = contextObject;
                    this.actionConfiguration = new Action(){

                        public void run() {
                            Trace tr = Trace.getDefault();
                            UiMQObject.this.showConfiguration(tr, this.getId(), contextObj);
                        }
                    };
                    this.actionConfiguration.setText(this.uiConfigurationProvider.getActionText(t));
                    UiPlugin.getHelpSystem().setHelp((IAction)this.actionConfiguration, "com.ibm.mq.explorer.ui.infopop.UI_StatusMenuItem");
                    this.actionConfiguration.setId(configurationTypes[0]);
                }
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.actionConfiguration);
            } else if (configurationTypes.length > 1) {
                submanager = new MenuManager(this.uiConfigurationProvider.getMenuText(t));
                manager.add((IContributionItem)new Separator());
                manager.add((IContributionItem)submanager);
                if (this.actionConfigurationArray == null) {
                    final Object contextObj3 = contextObject;
                    this.actionConfigurationArray = new Action[configurationTypes.length];
                    i = 0;
                    while (i < configurationTypes.length) {
                        this.actionConfigurationArray[i] = new Action(){

                            public void run() {
                                Trace tr = Trace.getDefault();
                                UiMQObject.this.showConfiguration(tr, this.getId(), contextObj3);
                            }
                        };
                        this.actionConfigurationArray[i].setText(this.uiConfigurationProvider.getMenuTextForConfigurationType(t, configurationTypes[i]));
                        this.actionConfigurationArray[i].setId(configurationTypes[i]);
                        helpId = this.uiConfigurationProvider.getMenuHelpIdForConfigurationType(t, configurationTypes[i]);
                        if (helpId == null) {
                            helpId = this.uiStatusProvider.isGenericStatus(t) ? "com.ibm.mq.explorer.ui.infopop.UI_StatusGenericMenuItem" : "com.ibm.mq.explorer.ui.infopop.UI_StatusMenuItem";
                        }
                        UiPlugin.getHelpSystem().setHelp((IAction)this.actionConfigurationArray[i], helpId);
                        ++i;
                    }
                }
                int i3 = 0;
                while (i3 < configurationTypes.length) {
                    submanager.add((IAction)this.actionConfigurationArray[i3]);
                    ++i3;
                }
            }
        }
        if (this.isAllowProperties()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionProperties);
        }
    }

    public void showProperties(Trace t) {
        t.data(67, "UiMQObject.showProperties", 300, "UiMQObject: showProperties");
        if (this.propertyDlg == null) {
            this.propertyDlg = new PropertyDlg(t, this.shell, 0);
            this.propertyDlg.addDialogClosedListener(this);
            this.propertyDlg.open(t, this, !this.isChangeProperties(t));
        } else {
            this.propertyDlg.getShell().setActive();
        }
    }

    public void showProperties(Trace t, Shell s) {
        t.data(67, "UiMQObject.showProperties", 300, "UiMQObject: showProperties");
        if (this.propertyDlg == null) {
            this.propertyDlg = new PropertyDlg(t, s, 0);
            this.propertyDlg.addDialogClosedListener(this);
            this.propertyDlg.open(t, this, !this.isChangeProperties(t));
        } else {
            this.propertyDlg.getShell().setActive();
        }
    }

    public String getHelpId(UiDisplayGroup uiDisplayGroup) {
        String helpId = "com.ibm.mq.explorer.ui.infopop." + uiDisplayGroup.getDisplayGroup().getHelpId();
        return helpId;
    }

    public void deleteMenuAction(Trace t) {
        if (this.isDeleteSystemObject(t, this.shell)) {
            this.msgFile = UiPlugin.getUIMessages(t, this.getNLSResourceFileKey());
            String nlsString = "";
            if (this.msgFile != null) {
                nlsString = this.msgFile.getMessage(t, "UI.GENERAL.BUSY.DELETE", this.toString());
            }
            this.busyDialog = new BusyDialog(this.shell, nlsString);
            Object parms = null;
            this.getDmObject().actionDelete(t, (DmActionListener)this, parms);
            this.busyDialog.showDialog(t);
        }
    }

    public boolean isDeleteSystemObject(Trace t, Shell s) {
        boolean result;
        block5: {
            result = false;
            int pressed = -1;
            String title = UiPlugin.getNLSString(t, "KEY_General", "UI.GENERAL.MQ");
            String message = null;
            try {
                if (this.getDmObject().isSystemDefault(t) || this.getDmObject().isSystemObject(t)) {
                    message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4003", (String)this.getDmObject().getTitle());
                    pressed = MessageBox.showDeleteCancelMessage(t, s, message, 1, "AMQ4003");
                    if (pressed == 0) {
                        result = true;
                    }
                } else {
                    result = true;
                }
            }
            catch (NullPointerException nullPointerException) {
                message = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4546", (String)this.getDmObject().getTitle());
                pressed = MessageBox.showYesNoMessage(t, s, title, message, 0, "AMQ4546");
                if (pressed != 0) break block5;
                result = true;
            }
        }
        return result;
    }

    public abstract boolean isCustomGroup(Trace var1, UiDisplayGroup var2);

    public abstract boolean isCustomItem(Trace var1, Attr var2);

    public abstract CustomPropertyPage createCustomPropertyPage(Trace var1, Composite var2, int var3, UiDisplayGroup var4, boolean var5);

    public abstract CustomPropertyItem createCustomPropertyItem(Trace var1, Composite var2, int var3, Attr var4, boolean var5);

    public abstract boolean isNotifyChangedOnPropertyPage(Attr var1);

    public abstract boolean attrValueChangedOnPropertyPage(Trace var1, Attr var2, Object var3);

    public void enablePropertyDialogOKButton(Trace t, boolean enable) {
        if (this.propertyDlg != null) {
            this.propertyDlg.enableOKButton(t, enable);
        }
    }

    @Override
    public void dialogClosed(DialogClosedEvent event) {
        if (event.getSource().equals(this.propertyDlg)) {
            this.propertyDlg = null;
        }
    }

    private UiConfigurationProvider getUiConfigurationProvider() {
        return this.uiConfigurationProvider;
    }

    public void setUiConfigurationProvider(UiConfigurationProvider provider) {
        this.uiConfigurationProvider = provider;
    }

    private UiStatusProvider getUiStatusProvider() {
        return this.uiStatusProvider;
    }

    public void setUiStatusProvider(UiStatusProvider provider) {
        this.uiStatusProvider = provider;
    }

    public void showConfiguration(Trace t, String configurationType, Object contextObject) {
        StatusDialog statusDialog = new StatusDialog(this.shell, 0);
        statusDialog.open(t, this.getUiConfigurationProvider(), configurationType, this, contextObject);
    }

    public void showStatus(Trace t, String statusType, Object contextObject) {
        StatusDialog statusDialog = new StatusDialog(this.shell, 0);
        statusDialog.open(t, this.getUiStatusProvider(), statusType, this, contextObject);
    }

    public boolean isAllowApplyProperties() {
        Trace t = Trace.getDefault();
        boolean apply = this.getDmObject().getQueueManager().isConnected();
        if (!apply) {
            MessageBox.showMessageFailure(t, UiPlugin.getShell(), CommonServices.getSystemMessage((Trace)t, (String)"AMQ4043", (String)String.valueOf(2059)), "AMQ4043");
        }
        return apply;
    }

    public abstract boolean isDefaultDataModeEbcdic(Trace var1);

    public void setCompareWithProvider(CompareWithProvider provider) {
        this.compareWithProvider = provider;
    }

    public abstract String getAttributeName(Trace var1, int var2);

    public abstract String getAttributeValue(Trace var1, int var2);

    public void dmActionDone(DmActionEvent event) {
        final int rc = event.getReasonCode();
        final DmCoreException exc = event.getException();
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                Trace trace = Trace.getDefault();
                if (UiMQObject.this.busyDialog != null) {
                    UiMQObject.this.busyDialog.closeDialog(trace);
                }
                if (rc == 0) {
                    MessageBox.showSystemMessageById(trace, UiPlugin.getShell(), "AMQ4123", new String[]{UiMQObject.this.toString()}, "AMQ4123");
                } else if (exc != null) {
                    MessageBox.showExceptionMessage(trace, UiPlugin.getShell(), exc);
                } else {
                    MessageBox.showExceptionMessage(trace, UiPlugin.getShell(), new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                }
            }
        });
    }

    public abstract String getCharacterSetIdForByteArray(Trace var1, int var2);

    @Override
    public boolean testAttribute(Object target, String name, String value) {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (name.compareTo("QSGDisposition") == 0) {
            Attr attr = this.getDmObject().getAttribute(t, 63, 0);
            if (attr != null && attr instanceof AttrInt) {
                Integer intDisp = (Integer)((AttrInt)attr).getValue(t);
                int disp = intDisp;
                if (value.compareTo("Copy") == 0 && disp == 1) {
                    result = true;
                } else if (value.compareTo("Group") == 0 && disp == 3) {
                    result = true;
                } else if (value.compareTo("QueueManager") == 0 && disp == 0) {
                    result = true;
                } else if (value.compareTo("Shared") == 0 && disp == 2) {
                    result = true;
                }
            }
        } else if (name.compareTo("SystemObject") == 0) {
            boolean isSystem = this.getDmObject().isSystemObject(t);
            if (value.compareTo("System") == 0 && isSystem) {
                result = true;
            } else if (value.compareTo("NonSystem") == 0 && !isSystem) {
                result = true;
            }
        } else if (name.compareTo("IsSupportDelete") == 0) {
            boolean del = this.isSupportDelete();
            result = value.equalsIgnoreCase("true") ? del : !del;
        } else {
            result = super.testAttribute(target, name, value);
        }
        if (Trace.isTracing) {
            t.data(67, "UiMQObject.testAttribute", 300, "returning " + result);
        }
        return result;
    }

    public boolean isAttributeTypeBoolean(Trace t, int attrId) {
        boolean result = false;
        Attr attr = this.dmObject.getAttribute(t, attrId, 0);
        if (attr != null) {
            AttrType attrType = attr.getAttrType();
            result = attrType instanceof AttrTypeBoolean;
        }
        return result;
    }

    public boolean isSelectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter) {
        return false;
    }

    public String selectAttributeObjectFromDmObjectFilter(Trace t, int attrId, DmObjectFilter dmObjectFilter, String currentSelection, String helpId, Shell sh) {
        return null;
    }

    public boolean isMandatoryAttributesPresent(Trace t) {
        boolean result = true;
        int[] mandatoryAttrIds = this.dmObject.getMandatoryIds(t);
        int i = 0;
        while (i < mandatoryAttrIds.length) {
            String value;
            Attr attr = this.dmObject.getAttribute(t, mandatoryAttrIds[i], 0);
            if (attr == null) {
                result = false;
                break;
            }
            AttrType attrType = attr.getAttrType();
            if (attrType instanceof AttrTypeString && ((value = (String)attr.getValue(t)) == null || value.length() == 0)) {
                result = false;
                break;
            }
            ++i;
        }
        return result;
    }

    public String getHelpIdForProperties() {
        return "com.ibm.mq.explorer.ui.infopop.UI_PropertiesMenuItem";
    }

    public void setObjectAttributeControlValue(Trace t, int id, Object value) {
    }

    public Object getObjectAttributeControlValue(Trace t, int id) {
        return null;
    }

    public List<Integer> getGroupExclusions(Trace t) {
        return null;
    }

    public boolean isAttributeValidToDisplay(int id) {
        return true;
    }
}

