/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTable;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableContentProvider;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableSelectionChangedEvent;
import com.ibm.mq.explorer.ui.internal.splittreetable.SplitTreeTableSelectionChangedListener;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class SelectUiMQObjectLinkDialog
extends Dialog
implements SplitTreeTableSelectionChangedListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/objects/SelectUiMQObjectLinkDialog.java";
    private static final int NUM_COLS = 1;
    private Shell parentShell = null;
    private Shell shellDlg = null;
    private SplitTreeTable splitTreeTable = null;
    private Composite compositeButtons = null;
    private Button buttonOK = null;
    private Button buttonCancel = null;
    private boolean isOK = false;
    private UiMQObject selectedObject = null;

    public SelectUiMQObjectLinkDialog(Trace t, Shell parent, int style) {
        super(parent, style);
        this.parentShell = parent;
    }

    public void create(Trace t, String title, String description, String objectId, String genericObjectName, String attrOrderId, boolean isSecondaryOrder, boolean showSchemeBar, boolean showStatusBar, String helpId, SplitTreeTableContentProvider contentProvider, UiMQObject ownerObject) {
        this.createContent(t, contentProvider, ownerObject, genericObjectName, attrOrderId, showSchemeBar, showStatusBar);
        this.shellDlg.setText(title);
        this.splitTreeTable.beginUpdate(t);
        contentProvider.getInitialObjects(t, ownerObject);
        this.splitTreeTable.endUpdate(t);
    }

    public boolean open(Trace t) {
        this.shellDlg.layout();
        this.shellDlg.open();
        Display display = this.shellDlg.getDisplay();
        while (!this.shellDlg.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.isOK;
    }

    private void createContent(Trace t, SplitTreeTableContentProvider contentProvider, UiMQObject ownerObject, String genericObjectName, String attrOrderId, boolean showSchemeBar, boolean showStatusBar) {
        this.shellDlg = new Shell(this.parentShell, 68848);
        this.shellDlg.setText(this.getText());
        this.shellDlg.setImage(Icons.get(Icons.iconkeyExplorerSmall));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        this.shellDlg.setLayout((Layout)gridLayout);
        this.splitTreeTable = new SplitTreeTable(t, (Composite)this.shellDlg, 0, genericObjectName, showSchemeBar, showStatusBar, false, null, contentProvider);
        this.splitTreeTable.setViewPart(t, (ViewPart)UiPlugin.getMQNavigatorView());
        this.splitTreeTable.setAttributeOrderId(t, attrOrderId);
        this.splitTreeTable.setInstance(t, null, false);
        this.splitTreeTable.setOwnerObject(ownerObject);
        DmQueueManager dmQueueManager = UiQueueManager.findOwningQueueManager(t, ownerObject).getDmQueueManagerObject();
        this.splitTreeTable.setAssociatedDmQueueManager(t, dmQueueManager);
        this.splitTreeTable.setInstance(t, dmQueueManager.getTreeName(t), dmQueueManager.isZos());
        this.splitTreeTable.addSelChangedListener(t, this);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.splitTreeTable.setLayoutData(gridData);
        this.compositeButtons = new Composite((Composite)this.shellDlg, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.compositeButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeButtons.setLayoutData((Object)gridData);
        Label label = new Label(this.compositeButtons, 0);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.buttonOK = new Button(this.compositeButtons, 8);
        this.buttonOK.setText(UiPlugin.getNLSString(t, "KEY_General", "UI.GENERAL.OK"));
        GridData gridDataOK = new GridData();
        gridDataOK.horizontalAlignment = 3;
        this.buttonOK.setLayoutData((Object)gridDataOK);
        this.buttonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectUiMQObjectLinkDialog.this.isOK = true;
                SelectUiMQObjectLinkDialog.this.shellDlg.close();
            }
        });
        this.buttonOK.setEnabled(false);
        this.buttonCancel = new Button(this.compositeButtons, 8);
        this.buttonCancel.setText(UiPlugin.getNLSString(t, "KEY_General", "UI.GENERAL.CANCEL"));
        GridData gridDataCancel = new GridData();
        gridDataCancel.horizontalAlignment = 3;
        this.buttonCancel.setLayoutData((Object)gridDataCancel);
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectUiMQObjectLinkDialog.this.isOK = false;
                SelectUiMQObjectLinkDialog.this.shellDlg.close();
            }
        });
        int maxWidth = 0;
        Point sizeOK = this.buttonOK.computeSize(-1, -1);
        Point sizeCancel = this.buttonCancel.computeSize(-1, -1);
        if (sizeOK.x > maxWidth) {
            maxWidth = sizeOK.x;
        }
        if (sizeCancel.x > maxWidth) {
            maxWidth = sizeCancel.x;
        }
        gridDataOK.widthHint = maxWidth;
        gridDataCancel.widthHint = maxWidth;
        this.shellDlg.setDefaultButton(this.buttonOK);
    }

    public UiMQObject getSelectedObject() {
        return this.selectedObject;
    }

    @Override
    public void selChanged(SplitTreeTableSelectionChangedEvent event) {
        this.selectedObject = event.getObject();
        this.buttonOK.setEnabled(this.selectedObject != null);
    }

    public void showObjects(Trace t, UiMQObject parentObject, ArrayList<UiMQObject> objects) {
        if (this.splitTreeTable != null) {
            this.splitTreeTable.beginUpdate(t);
            if (parentObject != null) {
                this.splitTreeTable.removeLoadingChild(t, parentObject);
            }
            this.splitTreeTable.addSiblingObjects(t, objects.toArray(new UiMQObject[objects.size()]));
            this.splitTreeTable.endUpdate(t);
        }
    }

    public void refreshObjects(Trace t, UiMQObject parentObject, UiMQObject refreshObject, ArrayList<UiMQObject> objects) {
        this.splitTreeTable.beginUpdate(t);
        Iterator<UiMQObject> iterator = objects.iterator();
        while (iterator.hasNext()) {
            this.splitTreeTable.refreshObject(t, parentObject, refreshObject, iterator.next());
        }
        this.splitTreeTable.endUpdate(t);
    }
}

