/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.ObjectRegistrationManager;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.SelectUiMQObject;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SelectUiMQObjectDialog
extends TrayDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/objects/SelectUiMQObjectDialog.java";
    public static final int ICON_INFO = 0;
    public static final int ICON_WARNING = 1;
    public static final int ICON_ERROR = 2;
    private static final int NUM_COLS = 1;
    private boolean isListenToDataModel = false;
    private SelectUiMQObject selectUiMQObject = null;
    private int tableType = 0;
    private String title;
    private String description;
    private String objectId;
    private String genericObjectName;
    private String attrOrderId;
    private boolean isSecondaryOrder;
    private String filterId;
    private FilterProvider filterProvider;
    private Integer filterQSGDisposition;
    private ViewerFilter viewerFilter;
    private boolean showSchemeBar;
    private boolean showStatusBar;
    private String helpId;
    private IDmObservable listenQmgr;
    private int listenObjectId;
    private IUiMQObjectFactory objectFactory;
    private UiMQObject parentToNewObjects;
    private MQExtObject[] precheckedObjects;
    private DmObjectFilter explicitFilter;
    private String preselectObjectName;
    private String attrOrderUniversalId;
    private UiMQObject[] objects;
    private boolean isTickCross = false;
    private Image imgTick;
    private Image imgCross;
    private String noObjectMessage;
    private int noObjectIcon;

    public SelectUiMQObjectDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.tableType = 0;
    }

    public SelectUiMQObjectDialog(Shell parent, int tabType) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.tableType = tabType;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
        newShell.setImage(Icons.get(Icons.iconkeyExplorerSmall));
        UiPlugin.getHelpSystem().setHelp((Control)newShell, this.helpId);
    }

    public Control createDialogArea(Composite parent) {
        Trace t = Trace.getDefault();
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        this.selectUiMQObject = new SelectUiMQObject(t, composite, 0, this.tableType);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.selectUiMQObject.setLayoutData(gridData);
        if (this.precheckedObjects != null) {
            this.selectUiMQObject.setPreCheckedObjects(t, this.precheckedObjects);
        }
        if (this.explicitFilter != null) {
            this.selectUiMQObject.setExplicitFilter(t, this.explicitFilter);
        }
        if (this.preselectObjectName != null) {
            this.selectUiMQObject.setPreselectObjectName(this.preselectObjectName);
        }
        if (this.attrOrderUniversalId != null) {
            this.selectUiMQObject.setExplicitAttrOrderUniversalId(t, this.attrOrderUniversalId);
        }
        if (this.objects != null) {
            this.selectUiMQObject.setObjects(t, this.objects);
        }
        if (this.isTickCross) {
            this.selectUiMQObject.setTickCrossMode(t, this.isTickCross, this.imgTick, this.imgCross);
        }
        if (this.noObjectMessage != null) {
            this.selectUiMQObject.setNoObjectMessage(t, this.noObjectIcon, this.noObjectMessage);
        }
        this.selectUiMQObject.createContent(t, this.description, this.objectId, this.genericObjectName, this.attrOrderId, this.isSecondaryOrder, this.filterId, this.filterProvider, this.filterQSGDisposition, this.viewerFilter, this.showSchemeBar, this.showStatusBar);
        if (this.tableType == 0) {
            this.selectUiMQObject.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    SelectUiMQObjectDialog.this.okPressed();
                }
            });
        }
        if (this.isListenToDataModel) {
            this.selectUiMQObject.listenToDataModel(t, this.listenQmgr, this.listenObjectId, this.objectFactory, this.parentToNewObjects);
            this.startListening();
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setFocus();
        this.getShell().setDefaultButton(ok);
    }

    public void listenToDataModel(Trace t, IDmObservable _listenQmgr, int _listenObjectId, IUiMQObjectFactory _objectFactory, UiMQObject _parentToNewObjects) {
        this.listenQmgr = _listenQmgr;
        this.listenObjectId = _listenObjectId;
        this.objectFactory = _objectFactory;
        this.parentToNewObjects = _parentToNewObjects;
        this.isListenToDataModel = true;
    }

    public void setExplicitFilter(Trace t, DmObjectFilter filter) {
        this.explicitFilter = filter;
    }

    public boolean open(Trace t, String _title, String _description, String _objectId, String _genericObjectName, String _attrOrderId, boolean _isSecondaryOrder, String _filterId, FilterProvider _filterProvider, Integer _filterQSGDisposition, ViewerFilter _viewerFilter, boolean _showSchemeBar, boolean _showStatusBar, String _helpId) {
        this.title = _title;
        this.description = _description;
        this.objectId = _objectId;
        this.genericObjectName = _genericObjectName;
        this.attrOrderId = _attrOrderId;
        this.isSecondaryOrder = _isSecondaryOrder;
        this.filterId = _filterId;
        this.filterProvider = _filterProvider;
        this.filterQSGDisposition = _filterQSGDisposition;
        this.viewerFilter = _viewerFilter;
        this.showSchemeBar = _showSchemeBar;
        this.showStatusBar = _showStatusBar;
        this.helpId = _helpId;
        int ret = this.open();
        return ret == 0;
    }

    public boolean openToSelectQueueManager(Trace t, String _title, String _description, ViewerFilter _viewerFilter, String _helpId) {
        this.listenToDataModel(t, null, 2, ObjectRegistrationManager.getUiMQObjectFactory(t, "com.ibm.mq.explorer.queuemanager"), null);
        Message messageFile = UiPlugin.getUIMessages(t, "KEY_Object_Types");
        return this.open(t, _title, _description, "com.ibm.mq.explorer.queuemanager", messageFile.getMessage(t, "UI.OBJECT.Type.QueueManager"), "com.ibm.mq.explorer.orderid.qmgrs", false, null, null, null, _viewerFilter, true, true, _helpId);
    }

    public boolean openToSelectQueueManagerHandle(Trace t, String _title, String _description, ViewerFilter _viewerFilter, String _helpId) {
        this.listenToDataModel(t, null, 2, ObjectRegistrationManager.getUiMQObjectFactory(t, "com.ibm.mq.explorer.queuemanagerhandle"), null);
        Message messageFile = UiPlugin.getUIMessages(t, "KEY_Object_Types");
        return this.open(t, _title, _description, "com.ibm.mq.explorer.queuemanagerhandle", messageFile.getMessage(t, "UI.OBJECT.Type.QueueManager"), "com.ibm.mq.explorer.orderid.qmgrhandle", false, null, null, null, _viewerFilter, false, true, _helpId);
    }

    public void startListening() {
        Trace t = Trace.getDefault();
        if (this.selectUiMQObject != null) {
            this.selectUiMQObject.startListening(t);
        }
    }

    public void stopListening() {
        Trace t = Trace.getDefault();
        if (this.selectUiMQObject != null) {
            this.selectUiMQObject.stopListening(t);
        }
    }

    public UiMQObject getSelectedObject() {
        UiMQObject selObject = null;
        if (this.selectUiMQObject != null) {
            selObject = this.selectUiMQObject.getSelectedObject();
        }
        return selObject;
    }

    public void setObjects(Trace t, UiMQObject[] objects) {
        this.objects = objects;
    }

    public void setNoObjectMessage(Trace t, int iconId, String msg) {
        this.noObjectMessage = msg;
        this.noObjectIcon = iconId;
    }

    public void setExplicitAttrOrderUniversalId(Trace t, String id) {
        this.attrOrderUniversalId = id;
    }

    public int getObjectCountOnClose() {
        return this.selectUiMQObject.getObjectCountOnClose();
    }

    public void setPreselectObjectName(String name) {
        this.preselectObjectName = name;
    }

    public void setTickCrossMode(Trace t, boolean isTickCross, Image imgTick, Image imgCross) {
        this.isTickCross = isTickCross;
        this.imgTick = imgTick;
        this.imgCross = imgCross;
    }

    public ArrayList<UiMQObject> getCheckedObjects() {
        return this.selectUiMQObject.getCheckedObjects();
    }

    public void setPreCheckedObjects(Trace t, MQExtObject[] objects) {
        this.precheckedObjects = objects;
    }

    public void addViewerFilter(ViewerFilter vf) {
        this.viewerFilter = vf;
    }
}

