/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.InvalidCharsAttributeEvent;
import com.ibm.mq.explorer.ui.internal.properties.InvalidCharsEventListener;
import com.ibm.mq.explorer.ui.internal.properties.MandatoryAttributeEvent;
import com.ibm.mq.explorer.ui.internal.properties.MandatoryAttributeEventListener;
import com.ibm.mq.explorer.ui.internal.properties.PropertyControl;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class NewObjectWizPage2
extends WizPage
implements MandatoryAttributeEventListener,
InvalidCharsEventListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/objects/NewObjectWizPage2.java";
    private static final int NUM_COLS = 1;
    private Message msgFile;
    private NewObjectWiz wizard = null;
    private NewObjectProvider newObjectProvider = null;
    private String newObjectTypeId = null;
    private PropertyControl propertyControl = null;
    private UiMQObject uiMQObject = null;
    private Hashtable<Integer, MandatoryAttributeEvent> missingMandatoryAttrEvents = new Hashtable();
    private Hashtable<String, InvalidCharsAttributeEvent> invalidCharsAttrEvents = new Hashtable();
    private boolean firstOpen = true;
    private IDmObject initialDmObject = null;

    public NewObjectWizPage2(Trace t, String pageName) {
        super(pageName);
    }

    public NewObjectWizPage2(Trace t, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    private void setHeadingsInfo(Trace t) {
        this.newObjectTypeId = this.wizard.getNewObjectTypeId();
        String title = this.msgFile.getMessage(t, "UI.NewObject.WizPage2.Title");
        String description = this.newObjectProvider.getWizardPage2Description(t, this.newObjectTypeId);
        if (description == null || description.length() == 0) {
            description = this.msgFile.getMessage(t, "UI.GENERAL.NOT.FOUND");
        }
        super.setHeadings(title, description);
    }

    @Override
    public void createPageContent(Trace t, Composite parent) {
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_NewObject");
        this.wizard = (NewObjectWiz)this.getWizard();
        this.newObjectProvider = this.wizard.getNewObjectProvider();
        this.propertyControl = new PropertyControl(t, parent, 0, true, false, false);
        this.propertyControl.addMandatoryAttributeEventListener(t, this);
        this.propertyControl.addInvalidCharsEventListener(t, this);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.propertyControl.setLayoutData(gridData);
        this.propertyControl.layout();
    }

    @Override
    public boolean performFinish() {
        Trace t = Trace.getDefault();
        IDmObject dmObject = this.uiMQObject.getDmObject();
        boolean result = this.wizard.createObject(t, dmObject, this.propertyControl);
        return result;
    }

    @Override
    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean isEnableNext = false;
        boolean isEnableFinish = this.missingMandatoryAttrEvents.isEmpty() && this.invalidCharsAttrEvents.isEmpty();
        this.setPageComplete(isEnableNext);
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons(t);
    }

    @Override
    public void nextPressed() {
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Trace t = Trace.getDefault();
        if (visible) {
            this.setHeadingsInfo(t);
            UiMQObject uiMQObj = this.wizard.getNewUiMQObject();
            boolean isObjectChanged = false;
            isObjectChanged = this.firstOpen ? true : this.isObjectChanged(t, uiMQObj.getDmObject(), this.initialDmObject);
            if (isObjectChanged) {
                this.missingMandatoryAttrEvents.clear();
                this.uiMQObject = uiMQObj;
                this.propertyControl.setObject(t, this.uiMQObject, -1);
                this.initialDmObject = uiMQObj.getDmObject().clone(t, uiMQObj.toString());
            }
            this.firstOpen = false;
        }
    }

    @Override
    public void attributeValueMissing(MandatoryAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.addToMissingMandatoryAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.checkIfEnableButtons();
    }

    @Override
    public void attributeValuePresent(MandatoryAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.removeFromMissingMandatoryAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.checkIfEnableButtons();
    }

    @Override
    public void invalidCharsPresent(InvalidCharsAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.addToInvalidCharsAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.checkIfEnableButtons();
    }

    @Override
    public void invalidCharsAbsent(InvalidCharsAttributeEvent event) {
        Trace t = Trace.getDefault();
        this.removeFromInvalidCharsAttrEvents(t, event);
        this.updateErrorMessage(t);
        this.checkIfEnableButtons();
    }

    private void addToMissingMandatoryAttrEvents(Trace t, MandatoryAttributeEvent event) {
        Integer key = event.getAttributeId();
        if (!this.missingMandatoryAttrEvents.containsKey(key)) {
            this.missingMandatoryAttrEvents.put(key, event);
        }
    }

    private void removeFromMissingMandatoryAttrEvents(Trace t, MandatoryAttributeEvent event) {
        Integer key = event.getAttributeId();
        if (this.missingMandatoryAttrEvents.containsKey(key)) {
            this.missingMandatoryAttrEvents.remove(key);
        }
    }

    private void addToInvalidCharsAttrEvents(Trace t, InvalidCharsAttributeEvent event) {
        String key = event.getAttributeName();
        if (!this.invalidCharsAttrEvents.containsKey(key)) {
            this.invalidCharsAttrEvents.put(key, event);
        }
    }

    private void removeFromInvalidCharsAttrEvents(Trace t, InvalidCharsAttributeEvent event) {
        String key = event.getAttributeName();
        if (this.invalidCharsAttrEvents.containsKey(key)) {
            this.invalidCharsAttrEvents.remove(key);
        }
    }

    private void updateErrorMessage(Trace t) {
        if (!this.invalidCharsAttrEvents.isEmpty()) {
            Enumeration<String> keys = this.invalidCharsAttrEvents.keys();
            String key = keys.nextElement();
            InvalidCharsAttributeEvent event = this.invalidCharsAttrEvents.get(key);
            this.setErrorMessage(Message.format((String)this.msgFile.getMessage(t, "UI.NewObject.Wizard.InvalidChars"), (String)event.getAttributeName()));
        } else if (this.missingMandatoryAttrEvents.isEmpty()) {
            this.setErrorMessage(null);
        } else {
            Enumeration<Integer> keys = this.missingMandatoryAttrEvents.keys();
            Integer key = keys.nextElement();
            MandatoryAttributeEvent event = this.missingMandatoryAttrEvents.get(key);
            if (!this.firstOpen) {
                this.setErrorMessage(Message.format((String)this.msgFile.getMessage(t, "UI.NewObject.Wizard.ValueRequired"), (String)event.getAttributeName()));
            }
        }
    }

    public PropertyControl getPropertyControl() {
        return this.propertyControl;
    }

    private boolean isObjectChanged(Trace t, IDmObject dmObj1, IDmObject dmObj2) {
        int[] attrIds2;
        int[] attrIds1 = dmObj1.getAllAttributes(t);
        if (attrIds1.length != (attrIds2 = dmObj2.getAllAttributes(t)).length) {
            return true;
        }
        int i = 0;
        while (i < attrIds1.length) {
            Attr attr1 = null;
            Attr attr2 = null;
            String attrValue1 = null;
            String attrValue2 = null;
            boolean attrPresent1 = true;
            boolean attrPresent2 = true;
            boolean repeating = false;
            int index = 0;
            do {
                attr1 = dmObj1.getAttribute(t, attrIds1[i], index);
                attr2 = dmObj2.getAttribute(t, attrIds1[i], index);
                attrPresent1 = true;
                attrPresent2 = true;
                if (attr1 != null) {
                    attrValue1 = attr1.toString(t);
                } else {
                    attrPresent1 = false;
                }
                if (attr2 != null) {
                    attrValue2 = attr2.toString(t);
                } else {
                    attrPresent2 = false;
                }
                if (attrPresent1 && index == 0) {
                    repeating = attr1.getAttrType().isRepeating();
                }
                ++index;
                if (attrPresent1 == attrPresent2 && (!attrPresent1 || !attrPresent2 || attrValue1 == null || attrValue2 == null || attrValue1.compareTo(attrValue2) == 0)) continue;
                return true;
            } while (repeating && attrPresent1 && attrPresent2);
            ++i;
        }
        return false;
    }
}

