/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AbstractAttrTypeEnum;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeFixedLengthString;
import com.ibm.mq.explorer.core.internal.attrs.AttrTypeString;
import com.ibm.mq.explorer.core.internal.base.IDmObservable;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.SelectUiMQObjectDialog;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.mapping.MappedProperty;
import com.ibm.mq.explorer.ui.internal.utils.StringValidation;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class NewObjectWizPage1
extends WizPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/objects/NewObjectWizPage1.java";
    private static final int NUM_COLS = 1;
    private Message msgFile;
    private NewObjectWiz wizard = null;
    private NewObjectProvider newObjectProvider = null;
    private String newObjectTypeId = null;
    private Text textName = null;
    private Label labelLike = null;
    private Text textLike = null;
    private Button buttonSelect = null;
    private Button checkboxUseLike = null;
    private Shell shell = null;
    private IDmObject likeDmObject = null;
    private UiMQObject defaultUiMQObject = null;
    private UiMQObject userselUiMQObject = null;
    private int[] mandatoryAttrIds = null;
    private String nameCloned = null;
    private Pattern regularExpression = null;
    private boolean gotRegularExpression = false;
    private boolean firstOpen = true;

    public NewObjectWizPage1(Trace t, String pageName) {
        super(pageName);
    }

    public NewObjectWizPage1(Trace t, String pageName, String helpId) {
        super(pageName, helpId);
    }

    public NewObjectWizPage1(Trace t, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    private void setHeadingsInfo(Trace t) {
        this.newObjectTypeId = this.wizard.getNewObjectTypeId();
        this.mandatoryAttrIds = this.wizard.getMandatoryAttrIds();
        String title = this.newObjectProvider.getWizardPage1Title(t, this.newObjectTypeId);
        if (title == null || title.length() == 0) {
            title = this.msgFile.getMessage(t, "UI.GENERAL.NOT.FOUND");
        }
        String description = this.msgFile.getMessage(t, "UI.NewObject.WizPage1.Desc");
        super.setHeadings(title, description);
    }

    @Override
    public void createPageContent(Trace t, Composite parent) {
        this.shell = parent.getShell();
        this.nameCloned = "";
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_NewObject");
        this.wizard = (NewObjectWiz)this.getWizard();
        this.newObjectProvider = this.wizard.getNewObjectProvider();
        Label label = new Label(parent, 0);
        label.setVisible(false);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        label.setText(this.msgFile.getMessage(t, "UI.NewObject.WizPage1.NamePrompt"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.textName = new Text(parent, 2048);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.textName.setLayoutData((Object)gridData);
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewObjectWizPage1.this.checkIfEnableButtons();
            }
        });
        label = new Label(parent, 0);
        label.setVisible(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        label.setVisible(false);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        boolean isLikeCheckbox = this.newObjectProvider.isShowCreateLikeCheckbox(t);
        int indent = 0;
        if (isLikeCheckbox) {
            this.checkboxUseLike = new Button(parent, 32);
            String useLikeObjectPromptText = this.newObjectProvider.getUseLikeObjectPromptText(t);
            this.checkboxUseLike.setText(useLikeObjectPromptText);
            gridData = new GridData(768);
            gridData.horizontalSpan = 1;
            this.checkboxUseLike.setLayoutData((Object)gridData);
            this.checkboxUseLike.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewObjectWizPage1.this.likeCheckboxSelectionChanged();
                }
            });
            indent = 25;
        }
        this.labelLike = new Label(parent, 0);
        this.labelLike.setText(this.msgFile.getMessage(t, "UI.NewObject.WizPage1.LikePrompt"));
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalIndent = indent;
        this.labelLike.setLayoutData((Object)gridData);
        Composite compLike = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        compLike.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        gridData.horizontalIndent = indent;
        compLike.setLayoutData((Object)gridData);
        this.textLike = new Text(compLike, 2048);
        UiUtils.makeTextControlReadOnly(t, this.textLike, true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.textLike.setLayoutData((Object)gridData);
        this.buttonSelect = new Button(compLike, 8);
        this.buttonSelect.setText(this.msgFile.getMessage(t, "UI.NewObject.WizPage1.ButtonSelect"));
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        this.buttonSelect.setLayoutData((Object)gridData);
        this.buttonSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace t2 = Trace.getDefault();
                NewObjectWizPage1.this.selectLikeObject(t2);
            }
        });
        this.createMappingTable(t, parent);
        Composite customArea = this.newObjectProvider.addCustomArea(t, this.wizard, parent, this.getName(), 1);
        if (customArea != null) {
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            customArea.setLayoutData((Object)gridData);
        }
        this.textName.setFocus();
    }

    private void createMappingTable(Trace t, final Composite parent) {
        Collection propertiesToMap = this.newObjectProvider.getPropertiesToMap(t);
        if (propertiesToMap != null && propertiesToMap.size() > 0) {
            Label label = new Label(parent, 0);
            label.setText(String.valueOf(this.msgFile.getMessage(t, "UI.NewObject.WizPage1.MappedPropertiesLabel")) + this.msgFile.getMessage(t, "UI.PROP.Colon.Suffix"));
            GridData gridData = new GridData();
            gridData.horizontalSpan = 1;
            label.setLayoutData((Object)gridData);
            Table table = new Table(parent, 4);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            final TableColumn attributeColumn = new TableColumn(table, 16384);
            attributeColumn.setText(this.msgFile.getMessage(t, "UI.TABLES.Attribute.Label"));
            final TableColumn valueColumn = new TableColumn(table, 16384);
            valueColumn.setText(this.msgFile.getMessage(t, "UI.TABLES.Value.Label"));
            parent.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle clientArea = parent.getClientArea();
                    int columnWidth = (clientArea.width - 10) / 2;
                    attributeColumn.setWidth(columnWidth);
                    valueColumn.setWidth(columnWidth);
                }
            });
            for (MappedProperty property : propertiesToMap) {
                AttrType attrType = property.getToAttrType();
                if (attrType == null) continue;
                TableItem item = new TableItem(table, 0);
                String attribute = attrType.getDisplayTitle();
                Object toValue = property.getToValue();
                String value = null;
                if (attrType instanceof AbstractAttrTypeEnum && toValue instanceof Number) {
                    value = ((AbstractAttrTypeEnum)attrType).getEnumeratedValue(t, (Number)toValue);
                    if (value.equals("[not_found]")) {
                        value = toValue.toString();
                    }
                } else {
                    value = toValue.toString();
                }
                item.setText(new String[]{attribute, value});
            }
            gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            gridData.heightHint = propertiesToMap.size();
            table.setLayoutData((Object)gridData);
        }
    }

    @Override
    public boolean performFinish() {
        Trace t = Trace.getDefault();
        boolean result = false;
        IDmObject newDmObject = null;
        boolean usingLikeObjects = true;
        if (this.newObjectProvider.isShowCreateLikeCheckbox(t)) {
            usingLikeObjects = this.checkboxUseLike != null && this.checkboxUseLike.getSelection();
        }
        this.likeDmObject = this.getLikeObject(t);
        if (usingLikeObjects) {
            if (this.likeDmObject != null) {
                newDmObject = this.cloneLikeObject(t, this.likeDmObject);
            }
        } else {
            UiMQObject newUiObject = this.newObjectProvider.createInterimObject(t, this.wizard.getNewObjectTypeId(), this.textName.getText());
            if (newUiObject != null) {
                newDmObject = newUiObject.getDmObject();
            } else {
                t.FFST(67, "NewObjectWizPage1.performFinish", 10, 50020, 0, 0, "Failed to get interim UiMQObject from provider, typeId = " + this.wizard.getNewObjectTypeId(), null, null);
            }
        }
        if (newDmObject != null) {
            this.newObjectProvider.setFixedAttributes(t, newDmObject, this.wizard);
            result = this.wizard.createObject(t, newDmObject, null);
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void checkIfEnableButtons() {
        Trace t = Trace.getDefault();
        boolean isEnableNext = false;
        boolean isEnableFinish = false;
        if (this.textName.getText().length() > 0 && (this.defaultUiMQObject != null || this.userselUiMQObject != null)) {
            Pattern p = null;
            if (this.userselUiMQObject != null) {
                p = this.getRegularExpression(t, this.userselUiMQObject);
            } else if (this.defaultUiMQObject != null) {
                p = this.getRegularExpression(t, this.defaultUiMQObject);
            }
            boolean valid = false;
            String txt = this.textName.getText();
            String errMsg = this.msgFile.getMessage(t, "UI.GENERAL.NAME.INVALID.CHARS");
            if (p != null) {
                Matcher m = p.matcher(txt);
                if (m.matches()) {
                    valid = true;
                } else {
                    errMsg = StringValidation.getMessageForPattern(t, p);
                }
            } else {
                valid = StringValidation.isValidMQName(t, txt, Integer.MAX_VALUE);
                errMsg = this.msgFile.getMessage(t, "UI.GENERAL.MQ.NAME.INVALID.CHARS");
            }
            if (valid) {
                isEnableNext = true;
                isEnableFinish = this.isMandatoryAttributesPresent(t);
                this.setErrorMessage(null);
            } else {
                UiPlugin.getDisplay().beep();
                this.setErrorMessage(errMsg);
            }
        } else {
            boolean objectMustExist = true;
            if (this.checkboxUseLike != null && !this.checkboxUseLike.getSelection()) {
                objectMustExist = false;
            }
            if (objectMustExist) {
                if (this.defaultUiMQObject == null && this.userselUiMQObject == null) {
                    String errMsg = this.msgFile.getMessage(t, "UI.NewObject.Wizard.LikeNotAvailableWizError");
                    this.setErrorMessage(errMsg);
                } else if (this.textName.getText().length() == 0) {
                    if (!this.firstOpen) {
                        String errMsg = this.msgFile.getMessage(t, "UI.NewObject.Wizard.NoNameError");
                        this.setErrorMessage(errMsg);
                    }
                } else {
                    isEnableNext = true;
                    isEnableFinish = this.isMandatoryAttributesPresent(t);
                    this.setErrorMessage(null);
                }
            } else if (this.textName.getText().length() == 0) {
                String errMsg = this.msgFile.getMessage(t, "UI.NewObject.Wizard.NoNameError");
                this.setErrorMessage(errMsg);
            } else {
                isEnableNext = true;
                isEnableFinish = this.isMandatoryAttributesPresent(t);
                this.setErrorMessage(null);
            }
        }
        this.setPageComplete(isEnableNext);
        this.wizard.setEnableFinish(isEnableFinish);
        this.wizard.updateButtons(t);
        this.firstOpen = false;
    }

    @Override
    public void nextPressed() {
        Trace t = Trace.getDefault();
        this.setMessage(this.msgFile.getMessage(t, "UI.NewObject.Wizard.ChangesLostWarning"), 2);
        UiMQObject uiMQObject = null;
        boolean usingLikeObjects = true;
        if (this.newObjectProvider.isShowCreateLikeCheckbox(t)) {
            boolean bl = usingLikeObjects = this.checkboxUseLike != null && this.checkboxUseLike.getSelection();
        }
        if (usingLikeObjects) {
            IDmObject likeObject = this.getLikeObject(t);
            if (likeObject != null && (this.textName.getText().compareTo(this.nameCloned) != 0 || likeObject != this.likeDmObject || this.wizard.getNewUiMQObject() == null)) {
                this.likeDmObject = likeObject;
                IDmObject cloneObject = this.cloneLikeObject(t, this.likeDmObject);
                IUiMQObjectFactory factory = this.newObjectProvider.getUiMQObjectFactory(t);
                if (factory != null) {
                    uiMQObject = factory.create(t, cloneObject, this.newObjectProvider.getParent());
                }
                if (uiMQObject != null) {
                    this.wizard.setNewUiMQObject(uiMQObject);
                } else {
                    t.FFST(67, "NewObjectWizPage1.nextPressed", 10, 50020, 0, 0, "Failed to create UiMQObject from clone", cloneObject.getTitle(), null);
                }
            }
        } else {
            uiMQObject = this.newObjectProvider.createInterimObject(t, this.wizard.getNewObjectTypeId(), this.textName.getText());
            if (uiMQObject != null) {
                IDmObject dmObject = uiMQObject.getDmObject();
                this.newObjectProvider.setFixedAttributes(t, dmObject, this.wizard);
                this.wizard.setNewUiMQObject(uiMQObject);
            } else {
                t.FFST(67, "NewObjectWizPage1.nextPressed", 10, 50020, 0, 0, "Failed to get interim UiMQObject from provider, typeId = " + this.wizard.getNewObjectTypeId(), null, null);
            }
        }
    }

    private IDmObject getLikeObject(Trace t) {
        IDmObject likeObject = null;
        UiMQObject likeUiMQObject = this.userselUiMQObject;
        if (likeUiMQObject == null) {
            likeUiMQObject = this.defaultUiMQObject;
        }
        if (likeUiMQObject != null) {
            likeObject = likeUiMQObject.getDmObject();
        }
        return likeObject;
    }

    public void createControl(Composite parent) {
        super.createControl(parent, 1);
    }

    private void selectLikeObject(Trace t) {
        SelectUiMQObjectDialog selDlg = new SelectUiMQObjectDialog(this.shell);
        DmQueueManager dmQm = null;
        boolean isSecondaryOrder = false;
        if (this.newObjectProvider.supportsDataModelListen(t)) {
            dmQm = this.newObjectProvider.getDmQueueManagerObject(t);
            if (dmQm != null) {
                isSecondaryOrder = dmQm.isZos();
            }
            selDlg.listenToDataModel(t, (IDmObservable)dmQm, this.newObjectProvider.getDataModelObjectType(t, this.newObjectTypeId), this.newObjectProvider.getUiMQObjectFactory(t), this.newObjectProvider.getParent());
        } else {
            UiMQObject[] objects = this.newObjectProvider.getCandidateLikeObjects(t, this.newObjectTypeId);
            selDlg.setObjects(t, objects);
        }
        String filterId = this.newObjectProvider.getFilterId();
        FilterProvider filterProvider = this.newObjectProvider.getFilterProvider(t);
        boolean isFiltering = filterId != null && filterProvider != null;
        String noObjectMsg = this.newObjectProvider.getNoObjectMessage(t);
        if (noObjectMsg != null) {
            selDlg.setNoObjectMessage(t, 1, noObjectMsg);
        }
        if (selDlg.open(t, this.msgFile.getMessage(t, "UI.NewObject.SelDlg.Title"), null, this.newObjectProvider.getObjectId(), this.newObjectProvider.getGenericObjectName(t), this.newObjectProvider.getAttributeOrderId(), isSecondaryOrder, filterId, filterProvider, this.newObjectProvider.getQSGDisposition(), this.newObjectProvider.getViewerFilter(t, this.newObjectTypeId), isFiltering, true, "com.ibm.mq.explorer.ui.infopop.UI_SelectLikeObject")) {
            this.userselUiMQObject = selDlg.getSelectedObject();
            this.gotRegularExpression = false;
            if (this.userselUiMQObject != null) {
                this.textLike.setText(this.userselUiMQObject.toString());
                this.textName.setTextLimit(this.getNameMaximumLength(t, this.userselUiMQObject));
            }
            this.checkIfEnableButtons();
        }
    }

    private IDmObject cloneLikeObject(Trace t, IDmObject likeObject) {
        this.nameCloned = this.textName.getText();
        IDmObject cloneObject = likeObject.clone(t, this.nameCloned);
        this.newObjectProvider.setFixedAttributes(t, cloneObject, this.wizard);
        return cloneObject;
    }

    private boolean isMandatoryAttributesPresent(Trace t) {
        boolean result = false;
        if (this.checkboxUseLike != null && !this.checkboxUseLike.getSelection()) {
            result = this.newObjectProvider.isObjectComplete(t);
        } else {
            IDmObject likeObject = this.getLikeObject(t);
            if (likeObject == null) {
                result = false;
            } else {
                result = true;
                this.mandatoryAttrIds = this.newObjectProvider.getMandatoryAttributeIds(t, this.newObjectTypeId, likeObject);
                int i = 0;
                while (i < this.mandatoryAttrIds.length) {
                    String value;
                    Attr attr = likeObject.getAttribute(t, this.mandatoryAttrIds[i], 0);
                    if (attr == null) {
                        result = false;
                        break;
                    }
                    AttrType attrType = attr.getAttrType();
                    if (attrType instanceof AttrTypeString && ((value = (String)attr.getValue(t)) == null || value.length() == 0)) {
                        result = false;
                        break;
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    private Pattern getRegularExpression(Trace t, UiMQObject uiMQObject) {
        Pattern p = null;
        if (this.gotRegularExpression) {
            p = this.regularExpression;
        } else {
            AttrType attrType;
            int nameAttrId;
            Attr attr;
            IDmObject dmObject;
            int[] mandatoryIds;
            if (uiMQObject != null && (mandatoryIds = (dmObject = uiMQObject.getDmObject()).getMandatoryIds(t)) != null && mandatoryIds.length > 0 && (attr = dmObject.getAttribute(t, nameAttrId = mandatoryIds[0], 0)) != null && (attrType = attr.getAttrType()) instanceof AttrTypeString) {
                p = ((AttrTypeString)attrType).getRegularExpression();
            }
            this.gotRegularExpression = true;
            this.regularExpression = p;
        }
        return p;
    }

    private int getNameMaximumLength(Trace t, UiMQObject uiMQObject) {
        AttrType attrType;
        int nameAttrId;
        Attr attr;
        IDmObject dmObject;
        int[] mandatoryIds;
        int maxLen = 48;
        if (uiMQObject != null && (mandatoryIds = (dmObject = uiMQObject.getDmObject()).getMandatoryIds(t)) != null && mandatoryIds.length > 0 && (attr = dmObject.getAttribute(t, nameAttrId = mandatoryIds[0], 0)) != null && (attrType = attr.getAttrType()) instanceof AttrTypeFixedLengthString) {
            maxLen = ((AttrTypeFixedLengthString)attrType).getLength();
        }
        return maxLen;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Trace t = Trace.getDefault();
        if (visible) {
            IUiMQObjectFactory factory;
            this.setHeadingsInfo(t);
            String newObjectName = this.wizard.getNewObjectName();
            if (newObjectName != null && newObjectName.length() > 0) {
                this.textName.setText(newObjectName);
                boolean readOnlyName = this.newObjectProvider.isNameReadOnly(t, this.wizard);
                if (readOnlyName) {
                    UiUtils.makeTextControlReadOnly(t, this.textName, false);
                }
            }
            this.defaultUiMQObject = null;
            String defaultLikeObjectName = this.newObjectProvider.getDefaultLikeObjectName(t, this.newObjectTypeId);
            DmObject dmObject = DmObject.clone((Trace)t, (DmQueueManager)this.newObjectProvider.getDmQueueManagerObject(t), (String)defaultLikeObjectName, (int)this.newObjectProvider.getDataModelObjectType(t, this.newObjectTypeId), (int)this.newObjectProvider.getDataModelObjectSubType(t, this.newObjectTypeId));
            if (dmObject != null && (factory = this.newObjectProvider.getUiMQObjectFactory(t)) != null) {
                this.defaultUiMQObject = factory.create(t, (IDmObject)dmObject, this.newObjectProvider.getParent());
                this.gotRegularExpression = false;
            }
            if (this.userselUiMQObject != null) {
                this.validateLikeObject(t);
            }
            if (this.userselUiMQObject != null) {
                this.textLike.setText(this.userselUiMQObject.toString());
                this.textName.setTextLimit(this.getNameMaximumLength(t, this.userselUiMQObject));
            } else if (this.defaultUiMQObject != null) {
                this.textLike.setText(defaultLikeObjectName);
                this.textName.setTextLimit(this.getNameMaximumLength(t, this.defaultUiMQObject));
            } else {
                String name = this.msgFile.getMessage(t, "UI.NewObject.Wizard.LikeNotAvailable");
                this.textLike.setText(name);
            }
            if (this.checkboxUseLike != null) {
                this.likeCheckboxSelectionChanged();
            }
        }
    }

    private void validateLikeObject(Trace t) {
        boolean valid = false;
        IDmObject likeObject = this.getLikeObject(t);
        UiMQObject[] candidateObjects = this.newObjectProvider.getCandidateLikeObjects(t, this.newObjectTypeId);
        if (candidateObjects == null) {
            int expectedType;
            int likeObjectType = likeObject.getObjectSubType(t);
            if (likeObjectType == (expectedType = this.newObjectProvider.getDataModelObjectSubType(t, this.newObjectTypeId))) {
                valid = true;
            }
        } else {
            int i = 0;
            while (!valid && i < candidateObjects.length) {
                UiMQObject currentCandidateObject = candidateObjects[i];
                IDmObject currentCandidateDmObject = currentCandidateObject.getDmObject();
                if (likeObject.equals((Object)currentCandidateDmObject)) {
                    valid = true;
                }
                ++i;
            }
        }
        if (!valid) {
            this.userselUiMQObject = null;
            this.textLike.setText(new String());
        }
    }

    protected void likeCheckboxSelectionChanged() {
        boolean checked = this.checkboxUseLike.getSelection();
        this.labelLike.setEnabled(checked);
        this.textLike.setEnabled(checked);
        this.buttonSelect.setEnabled(checked);
        this.checkIfEnableButtons();
    }
}

