/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.CreateDmObject;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWizDlg;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWizStarter;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.PropertyControl;
import com.ibm.mq.explorer.ui.internal.properties.mapping.UnableToUseMappingObjectException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class NewObjectWiz
extends Wizard {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/objects/NewObjectWiz.java";
    public static final String PAGE_SELECT_LIKE_OBJECT = "PAGE_STD_SELECT_LIKE_OBJECT";
    public static final String PAGE_CHANGE_PROPERTIES = "PAGE_STD_CHANGE_PROPERTIES";
    public static final String[] DEFAULT_PAGE_IDS = new String[]{"PAGE_STD_SELECT_LIKE_OBJECT", "PAGE_STD_CHANGE_PROPERTIES"};
    public static final String PAGE_NEXT = "PAGE_DUMMY_NEXT";
    private NewObjectProvider newObjectProvider = null;
    private String newObjectTypeId = null;
    private boolean enableFinish = false;
    private NewObjectWizDlg newObjectWizDlg = null;
    private UiMQObject newUiMQObject = null;
    private int[] mandatoryAttrIds = null;
    private Message msgFile;
    private WizPage[] wizPages = null;
    private String newObjectName = null;
    private String nextObjectId;
    private NewObjectProvider nextNewObjectProvider;
    private IDmObject createdObject;

    public NewObjectWiz(Trace t, NewObjectProvider newObjProvider, String typeId) {
        this.newObjectProvider = newObjProvider;
        this.newObjectProvider.instanceOpened(t, (Object)this);
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_NewObject");
        this.setNewObjectTypeId(typeId);
        this.newObjectName = this.newObjectProvider.getFixedName(t);
        String[] ids = this.newObjectProvider.getPageIds(t, typeId);
        if (ids == null || ids.length == 0) {
            ids = DEFAULT_PAGE_IDS;
        }
        this.wizPages = new WizPage[ids.length];
        int i = 0;
        while (i < ids.length) {
            this.wizPages[i] = this.newObjectProvider.getWizardPage(t, ids[i], this);
            if (this.wizPages[i] == null) {
                t.FFST(67, "NewObjectWiz.NewObjectWiz", 10, 50009, "Null wizard page returned for page id " + ids[i]);
            }
            ++i;
        }
        String title = this.newObjectProvider.getWizardTitle(t, this.newObjectTypeId);
        if (title == null || title.length() == 0) {
            title = this.msgFile.getMessage(t, "UI.GENERAL.NOT.FOUND");
        }
        this.setWindowTitle(title);
    }

    public boolean performFinish() {
        WizPage page = (WizPage)this.newObjectWizDlg.getCurrentPage();
        return page.performFinish();
    }

    public void setEnableFinish(boolean enableFinishValue) {
        this.enableFinish = enableFinishValue;
    }

    public boolean canFinish() {
        return this.enableFinish;
    }

    public void updateButtons(Trace t) {
        if (this.newObjectWizDlg == null) {
            this.newObjectWizDlg = (NewObjectWizDlg)this.getContainer();
        }
        this.newObjectWizDlg.updateButtons();
    }

    public void addPages() {
        int i = 0;
        while (i < this.wizPages.length) {
            if (this.wizPages[i] != null) {
                this.addPage((IWizardPage)this.wizPages[i]);
            }
            ++i;
        }
        this.setNeedsProgressMonitor(true);
    }

    public NewObjectProvider getNewObjectProvider() {
        return this.newObjectProvider;
    }

    public String getNewObjectTypeId() {
        return this.newObjectTypeId;
    }

    public void setNewObjectTypeId(String typeId) {
        Trace t = Trace.getDefault();
        this.newObjectTypeId = typeId;
        this.mandatoryAttrIds = this.newObjectProvider.getMandatoryAttributeIds(t, this.newObjectTypeId);
        if (this.mandatoryAttrIds == null) {
            this.mandatoryAttrIds = new int[0];
        }
    }

    public UiMQObject getNewUiMQObject() {
        return this.newUiMQObject;
    }

    public void setNewUiMQObject(UiMQObject object) {
        this.newUiMQObject = object;
    }

    public boolean createObject(Trace t, IDmObject dmObject, PropertyControl propertyControl) {
        boolean result = false;
        DmActionEvent dmActionEvent = null;
        String taskName = "";
        String objectName = dmObject.getTitle();
        if (objectName != null && objectName.length() > 0) {
            String taskNameRoot = this.newObjectProvider.getWizardCreatingTaskText(t, this.newObjectTypeId);
            if (taskNameRoot != null && taskNameRoot.length() > 0) {
                taskName = Message.format((String)taskNameRoot, (String)objectName);
            } else if (taskNameRoot == null || taskNameRoot.length() == 0) {
                taskName = this.msgFile.getMessage(t, "UI.GENERAL.NOT.FOUND");
            }
        }
        CreateDmObject createDmObject = new CreateDmObject(t, dmObject, propertyControl, taskName);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)createDmObject);
            dmActionEvent = createDmObject.getDmActionEvent();
            if (dmActionEvent.getReasonCode() == 0) {
                String successMsgId = this.newObjectProvider.getSuccessMessage();
                MessageBox.showSystemMessageById(t, this.getShell(), successMsgId, null, successMsgId);
                result = true;
            } else {
                DmCoreException dmCoreException = dmActionEvent.getException();
                if (dmCoreException != null) {
                    MessageBox.showExceptionMessage(t, this.getShell(), dmCoreException);
                } else {
                    String sysMsgId = CommonServices.getSystemMessageId((Trace)t, (int)dmActionEvent.getReasonCode());
                    String sysMsg = CommonServices.getSystemMessage((Trace)t, (String)sysMsgId);
                    MessageBox.showMessageFailure(t, this.getShell(), sysMsg);
                }
            }
        }
        catch (InvocationTargetException e) {
            t.FFST(67, "NewObjectWiz.createObject", 10, 50037, 0, 0, "InvocationTragetException", e.getMessage(), null);
        }
        catch (InterruptedException e) {
            t.FFST(67, "NewObjectWiz.createObject", 20, 50038, 0, 0, "InterruptedException", e.getMessage(), null);
        }
        if (result) {
            this.createdObject = dmObject;
        }
        return result;
    }

    public int[] getMandatoryAttrIds() {
        return this.mandatoryAttrIds;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage wizPage;
        if (this.newObjectWizDlg == null) {
            this.newObjectWizDlg = (NewObjectWizDlg)this.getContainer();
        }
        if ((wizPage = this.newObjectWizDlg.getNextPage()) == null) {
            wizPage = super.getNextPage(page);
        }
        return wizPage;
    }

    public void setNextPage(Trace t, String id) {
        IWizardPage nextPage = id.compareTo(PAGE_NEXT) == 0 ? null : super.getPage(id);
        if (this.newObjectWizDlg == null) {
            this.newObjectWizDlg = (NewObjectWizDlg)this.getContainer();
        }
        this.newObjectWizDlg.setNextPage(nextPage);
    }

    public String getNewObjectName() {
        return this.newObjectName;
    }

    public void setNewObjectName(String name) {
        this.newObjectName = name;
    }

    public void dispose() {
        Trace t = Trace.getDefault();
        this.newObjectProvider.instanceClosed(t, (Object)this);
        super.dispose();
    }

    public void setNextObjectId(Trace t, String nextObjectId) {
        this.nextObjectId = nextObjectId;
    }

    public void setNextNewObjectProvider(Trace t, NewObjectProvider nextNewObjectProvider) {
        this.nextNewObjectProvider = nextNewObjectProvider;
    }

    public NewObjectWizStarter getNextWizardStarter(Trace t) {
        NewObjectWizStarter nextWizStarter = null;
        if (this.nextObjectId != null && this.nextNewObjectProvider != null) {
            try {
                this.nextNewObjectProvider.setObjectToMapPropertiesFrom(t, this.createdObject);
                nextWizStarter = new NewObjectWizStarter(t, this.nextNewObjectProvider, this.nextObjectId);
            }
            catch (UnableToUseMappingObjectException e) {
                MessageBox.showMessageFailure(t, UiPlugin.getShell(), e.getMessage(), e.getMessageId());
            }
        }
        return nextWizStarter;
    }
}

