/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectFilter;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.DmQueueManager;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.WizPage;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.objects.IExplorerProvider;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.MappingArea;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWizPage1;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWizPage2;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.mapping.ClassNotSupportedException;
import com.ibm.mq.explorer.ui.internal.properties.mapping.IPropertyMapper;
import com.ibm.mq.explorer.ui.internal.properties.mapping.MappedProperty;
import com.ibm.mq.explorer.ui.internal.properties.mapping.PropertyMapperFactory;
import com.ibm.mq.explorer.ui.internal.properties.mapping.UnableToUseMappingObjectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public abstract class NewObjectProvider
implements IExplorerProvider,
DmObjectListListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/objects/NewObjectProvider.java";
    public static final int CUSTOM_AREA_POSITION_BOTTOM = 1;
    private UiMQObject parent = null;
    protected IDmObject propertyMappingObject;
    protected String fixedName;
    protected BusyDialog busyDialog = null;
    protected DmObjectListEvent dmObjectListEvent = null;

    public NewObjectProvider() {
    }

    public NewObjectProvider(Trace t, UiMQObject parent) {
        this.setParent(t, parent);
    }

    public UiMQObject getParent() {
        return this.parent;
    }

    public void setParent(Trace t, UiMQObject parent) {
        this.parent = parent;
    }

    public abstract int getNewObjectTypeCount(Trace var1);

    public abstract String[] getNewObjectTypes(Trace var1);

    public abstract String getMenuTextForNewObjectType(Trace var1, String var2);

    public abstract String getHelpIdForNewObjectType(Trace var1, String var2);

    public abstract String getNameForNewObjectType(Trace var1, String var2);

    public String getDescriptionForNewObjectType(Trace t, String typeId) {
        return null;
    }

    public abstract String getDefaultLikeObjectName(Trace var1, String var2);

    public abstract String getGenericObjectName(Trace var1);

    public abstract FilterProvider getFilterProvider(Trace var1);

    public abstract boolean supportsDataModelListen(Trace var1);

    public abstract DmQueueManager getDmQueueManagerObject(Trace var1);

    public abstract int getDataModelObjectType(Trace var1, String var2);

    public abstract int getDataModelObjectSubType(Trace var1, String var2);

    public abstract IUiMQObjectFactory getUiMQObjectFactory(Trace var1);

    public abstract ViewerFilter getViewerFilter(Trace var1, String var2);

    public String getFixedName(Trace t) {
        return this.fixedName;
    }

    public void setFixedAttributes(Trace t, IDmObject object, NewObjectWiz wizard) {
        Collection propertiesToMap = this.getPropertiesToMap(t);
        if (propertiesToMap != null) {
            for (MappedProperty property : propertiesToMap) {
                int id = property.getToId();
                Object value = property.getToValue();
                if (value == null) continue;
                this.setFixedAttribute(t, object, id, value);
            }
        }
    }

    public boolean isModifiable(Trace t, int id, boolean currentlyModifiable) {
        return currentlyModifiable;
    }

    protected void setFixedAttribute(Trace t, IDmObject object, int id, Object value) {
        boolean valueReplaced = false;
        valueReplaced = object instanceof DmObject ? ((DmObject)object).replaceAttributeValue(t, id, 0, value, false) : object.replaceAttributeValue(t, id, 0, value);
        if (!valueReplaced && Trace.isTracing) {
            t.data(67, "NewObjectProvider.setFixedAttribute", 900, "replaceAttributeValue failed - attribute id: " + id + ", value: " + value.toString());
        }
    }

    public abstract int[] getMandatoryAttributeIds(Trace var1, String var2);

    public int[] getMandatoryAttributeIds(Trace t, String typeId, IDmObject likeObject) {
        return likeObject.getMandatoryIds(t);
    }

    public abstract String getWizardTitle(Trace var1, String var2);

    public abstract String getWizardPage1Title(Trace var1, String var2);

    public abstract String getWizardPage2Description(Trace var1, String var2);

    public abstract String getWizardCreatingTaskText(Trace var1, String var2);

    public String[] getPageIds(Trace t, String typeId) {
        String[] pageIds = null;
        pageIds = this.getPropertyMappingPageIds(t, typeId, pageIds);
        return pageIds;
    }

    protected String[] getPropertyMappingPageIds(Trace t, String typeId, String[] defaultPageIds) {
        IPropertyMapper propertyMapper;
        String[] pageIds = defaultPageIds;
        boolean mapping = this.isMappingProperties();
        if (mapping && (propertyMapper = this.getPropertyMapper(t)) != null) {
            pageIds = propertyMapper.getPageIds(t, typeId, this, pageIds);
        }
        return pageIds;
    }

    public WizPage getWizardPage(Trace t, String pageId, NewObjectWiz wizard) {
        IPropertyMapper propertyMapper;
        WizPage wizPage = null;
        boolean mapping = this.isMappingProperties();
        if (mapping && (propertyMapper = this.getPropertyMapper(t)) != null) {
            wizPage = propertyMapper.getWizardPage(t, pageId, wizard, this, this.propertyMappingObject);
        }
        if (wizPage == null) {
            if (pageId.compareTo("PAGE_STD_SELECT_LIKE_OBJECT") == 0) {
                wizPage = new NewObjectWizPage1(t, pageId);
            } else if (pageId.compareTo("PAGE_STD_CHANGE_PROPERTIES") == 0) {
                wizPage = new NewObjectWizPage2(t, pageId);
            }
        }
        return wizPage;
    }

    public boolean isShowCreateLikeCheckbox(Trace t) {
        boolean result = false;
        return result;
    }

    public UiMQObject[] getCandidateLikeObjects(Trace t, String typeId) {
        UiMQObject[] likeObjects = null;
        return likeObjects;
    }

    public UiMQObject createInterimObject(Trace t, String typeId, String name) {
        UiMQObject uiMQObject = null;
        return uiMQObject;
    }

    public boolean isObjectComplete(Trace t) {
        return true;
    }

    public Pattern getNewObjectNameRegularExpression(Trace t) {
        return null;
    }

    public String getUseLikeObjectPromptText(Trace t) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_NewObject");
        String prompt = msgFile.getMessage(t, "UI.NewObject.WizPage1.UseLikeObject");
        return prompt;
    }

    public void instanceOpened(Trace t, Object handle) {
    }

    public void instanceClosed(Trace t, Object handle) {
    }

    public String getNoObjectMessage(Trace t) {
        return null;
    }

    public String getLikeObjectHelpId() {
        return "com.ibm.mq.explorer.ui.infopop.UI_SelectLikeObject";
    }

    public void setObjectToMapPropertiesFrom(Trace t, IDmObject object) throws UnableToUseMappingObjectException {
        IPropertyMapper propertyMapper;
        this.propertyMappingObject = object;
        String objectName = object.getAttributeValue(t, 2092, 0);
        DmObjectFilter filter = new DmObjectFilter(t, objectName, 174);
        DmQueueManager dmQmgr = object.getQueueManager();
        ArrayList objectList = null;
        if (dmQmgr != null) {
            Message msgFile = UiPlugin.getUIMessages(t, "KEY_NewObject");
            this.busyDialog = new BusyDialog(UiPlugin.getShell(), msgFile.getMessage(t, "UI.NewObject.Wizard.Mapping.BusyText"));
            dmQmgr.getObjects(t, (DmObjectListListener)this, filter);
            this.busyDialog.showDialog(t);
            this.busyDialog = null;
            if (this.dmObjectListEvent != null) {
                DmCoreException e = this.dmObjectListEvent.getException();
                if (e != null) {
                    if (Trace.isTracing) {
                        t.data(67, "NewObjectProvider.setObjectToMapPropertiesFrom", 900, "Error attempting to get a handle to newly created object: " + e.toString());
                    }
                } else {
                    objectList = this.dmObjectListEvent.getList();
                    if (objectList != null && objectList.size() > 0) {
                        this.propertyMappingObject = (IDmObject)objectList.get(0);
                    }
                }
            }
        }
        if ((propertyMapper = this.getPropertyMapper(t)) != null) {
            propertyMapper.validateFromObject(t, object);
            this.fixedName = propertyMapper.getNewObjectName(t, object);
        }
    }

    public void dmObjectListDone(DmObjectListEvent event) {
        this.dmObjectListEvent = event;
        if (this.busyDialog != null) {
            UiPlugin.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NewObjectProvider.this.busyDialog.closeDialog(Trace.getDefault());
                }
            });
        }
    }

    protected IPropertyMapper getPropertyMapper(Trace t) {
        IPropertyMapper propertyMapper = null;
        if (this.propertyMappingObject != null) {
            Class<?> fromClass = this.propertyMappingObject.getClass();
            Class toClass = this.getNewObjectClass(t);
            PropertyMapperFactory factory = PropertyMapperFactory.getFactory();
            propertyMapper = factory.getPropertyMapper(t, fromClass, toClass);
            if (propertyMapper == null) {
                t.FFST(67, 67, 0, 0, "Failed to load the expected property mapper, from: " + fromClass.toString() + ", to: " + toClass.toString());
            }
        }
        return propertyMapper;
    }

    protected Collection getPossiblePropertyMappers(Trace t) {
        PropertyMapperFactory factory;
        Collection propertyMappers = null;
        Class fromClass = this.getNewObjectClass(t);
        if (fromClass != null && (propertyMappers = (factory = PropertyMapperFactory.getFactory()).getPropertyMappersFrom(t, fromClass)) != null) {
            Iterator mappersIterator = propertyMappers.iterator();
            while (mappersIterator.hasNext()) {
                IPropertyMapper mapper = (IPropertyMapper)mappersIterator.next();
                Collection requiredPlugins = mapper.getRequiredPlugins();
                Iterator pluginsIterator = requiredPlugins.iterator();
                boolean mapperIsValid = true;
                while (pluginsIterator.hasNext() && mapperIsValid) {
                    String pluginId = (String)pluginsIterator.next();
                    if (UiPlugin.isPluginEnabled(pluginId)) continue;
                    mapperIsValid = false;
                    mappersIterator.remove();
                }
            }
        }
        return propertyMappers;
    }

    protected Class getNewObjectClass(Trace t) {
        return null;
    }

    protected Collection getPropertiesToMap(Trace t) {
        IPropertyMapper mapper;
        Collection propertiesToMap = null;
        if (this.propertyMappingObject != null && (mapper = this.getPropertyMapper(t)) != null) {
            try {
                propertiesToMap = mapper.map(t, this.propertyMappingObject);
            }
            catch (ClassNotSupportedException e) {
                String errorMessage = e.getMessage();
                t.FFST(67, "NewObjectProvider.getPropertiesToMap", 0, 0, errorMessage);
            }
        }
        return propertiesToMap;
    }

    public boolean isMappingProperties() {
        return this.propertyMappingObject != null;
    }

    public Composite addCustomArea(Trace t, NewObjectWiz wizard, Composite parentComposite, String pageId, int position) {
        return null;
    }

    protected Composite addMappingArea(Trace t, NewObjectWiz wizard, Composite parentComposite) {
        Collection mappers;
        MappingArea customArea = null;
        if (!this.isMappingProperties() && (mappers = this.getPossiblePropertyMappers(t)) != null && mappers.size() > 0) {
            customArea = new MappingArea(t, parentComposite, wizard);
            customArea.addPropertyMappers(t, mappers);
        }
        return customArea;
    }

    public boolean isNameReadOnly(Trace t, NewObjectWiz wizard) {
        boolean readOnly = false;
        if (this.fixedName != null && this.fixedName.length() > 0) {
            readOnly = true;
        } else {
            String currentName = wizard.getNewObjectName();
            if (currentName != null && currentName.length() > 0) {
                readOnly = true;
            }
        }
        return readOnly;
    }

    public String getSuccessMessage() {
        return "AMQ4148";
    }

    public boolean isObjectTypesDynamic() {
        return false;
    }
}

