/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.objects;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWiz;
import com.ibm.mq.explorer.ui.internal.properties.mapping.IPropertyMapper;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MappingArea
extends Composite {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/objects/MappingArea.java";
    private NewObjectWiz wizard;
    private IPropertyMapper currentPropertyMapper;

    public MappingArea(Trace t, Composite parent, NewObjectWiz wizard) {
        super(parent, 0);
        this.wizard = wizard;
        this.initialiseContent(t);
    }

    protected void initialiseContent(Trace t) {
        GridLayout gridLayout = new GridLayout();
        this.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)this, 0);
        Message messageFile = UiPlugin.getUIMessages(t, "KEY_NewObject");
        String labelText = messageFile.getMessage("UI.NewObject.Wizard.Mapping.HelpText");
        label.setText(labelText);
    }

    protected Map<IPropertyMapper, Control> addControlsForPropertyMappers(final Trace t, Collection mappers, Composite parent) {
        int numberOfPropertyMappers = mappers.size();
        HashMap<IPropertyMapper, Control> mappingControls = new HashMap<IPropertyMapper, Control>(numberOfPropertyMappers);
        for (final IPropertyMapper mapper : mappers) {
            Button button = null;
            if (mappers.size() == 1) {
                button = new Button(parent, 32);
            } else if (mappers.size() > 1) {
                button = new Button(parent, 16);
            }
            if (button == null) continue;
            mappingControls.put(mapper, (Control)button);
            String buttonText = mapper.getStartMappingWizardText();
            button.setText(buttonText);
            GridData layoutData = new GridData(768);
            button.setLayoutData((Object)layoutData);
            UiUtils.createBlankLine(parent, 1);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean buttonIsCheckbox;
                    Button selectedButton = (Button)e.widget;
                    boolean selected = selectedButton.getSelection();
                    boolean bl = buttonIsCheckbox = (selectedButton.getStyle() & 0x20) != 0;
                    if (selected) {
                        MappingArea.this.setCurrentPropertyMapper(t, mapper);
                    } else if (buttonIsCheckbox) {
                        MappingArea.this.setCurrentPropertyMapper(t, null);
                    }
                    MappingArea.this.updateWizard(t);
                }
            });
        }
        return mappingControls;
    }

    public void addPropertyMappers(Trace t, Collection mappers) {
        this.addControlsForPropertyMappers(t, mappers, this);
    }

    private void updateWizard(Trace t) {
        if (this.currentPropertyMapper != null) {
            String nextObjectId = this.currentPropertyMapper.getToObjectId(t);
            NewObjectProvider nextNewObjectProvider = this.currentPropertyMapper.getToNewObjectProvider(t);
            this.wizard.setNextObjectId(t, nextObjectId);
            this.wizard.setNextNewObjectProvider(t, nextNewObjectProvider);
        } else {
            this.wizard.setNextObjectId(t, null);
            this.wizard.setNextNewObjectProvider(t, null);
        }
    }

    protected void setCurrentPropertyMapper(Trace t, IPropertyMapper mapper) {
        this.currentPropertyMapper = mapper;
    }
}

