/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.navigator;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.navigator.DottedDecimal;
import com.ibm.mq.explorer.ui.internal.navigator.ITreeNodeComparator;
import com.ibm.mq.explorer.ui.internal.navigator.LoadingTreeNodeFactory;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectProvider;
import com.ibm.mq.explorer.ui.internal.objects.NewObjectWizStarter;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.objects.UiObject;
import com.ibm.mq.explorer.ui.internal.status.StatusDialog;
import com.ibm.mq.explorer.ui.internal.status.UiStatusProvider;
import com.ibm.mq.explorer.ui.internal.views.MQNavigatorView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class TreeNodeBase
extends PlatformObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/navigator/TreeNodeBase.java";
    private static final String THIS_VERSION = "1.0.0";
    public static final String ENCODING_TYPE = "UTF-8";
    private TreeNode parent = null;
    private TreeNode thisTreeNode = null;
    private Object object = null;
    private ArrayList<TreeNode> children = null;
    private ArrayList<TreeNode> visibleChildren = null;
    private int complexity = 0;
    private boolean isChildrenAdded = false;
    private boolean isRealChildrenAdded = false;
    private boolean isVisible = true;
    private boolean isExpanded = false;
    private boolean isLoadingTreeNode = false;
    private String plugin_id = null;
    private NewObjectProvider newObjectProvider = null;
    private Action[] actionNewObjectArray = null;
    private Action actionStatus = null;
    private Action[] actionStatusArray = null;
    private Shell shell = null;
    private UiStatusProvider uiStatusProvider = null;
    private UiMQObject uiObject = null;
    private String treeNodeId = "";
    protected boolean isRefreshTimerRunning = false;
    private static boolean isBadTreeNodeFFSTGenerated = false;
    private ITreeNodeComparator treeNodeComparator = null;

    public TreeNodeBase(TreeNode parnt, Object obj, String pluginId) {
        Object intObj;
        this.parent = parnt;
        this.object = obj;
        this.children = new ArrayList();
        this.visibleChildren = new ArrayList();
        this.plugin_id = pluginId;
        MQExtObject extObj = (MQExtObject)this.object;
        if (extObj != null && (intObj = extObj.getInternalObject()) instanceof UiMQObject) {
            this.uiObject = (UiMQObject)intObj;
        }
    }

    public void setOwningTreeNode(TreeNode treeNode) {
        this.thisTreeNode = treeNode;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public TreeNode getRealParent(Trace t) {
        TreeNode realParent = this.parent;
        return realParent;
    }

    public void setParent(TreeNode newParent) {
        this.parent = newParent;
    }

    public TreeNode[] getChildren() {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "TreeNodeBase.getChildren", 300, "get visible children for node: " + ((Object)((Object)this)).toString());
            TreeNode realParent = this.getRealParent(t);
            if (realParent != null) {
                t.data(67, "TreeNodeBase.getChildren", 300, "(parent is: " + realParent.toString() + ")");
            }
            int i = 0;
            while (i < this.visibleChildren.size()) {
                TreeNode child = this.visibleChildren.get(i);
                if (Trace.isTracing) {
                    t.data(67, "TreeNodeBase.getChildren", 300, "        child: " + child.toString());
                }
                ++i;
            }
        }
        return this.visibleChildren.toArray(new TreeNode[this.visibleChildren.size()]);
    }

    public TreeNode[] getRealChildren() {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "TreeNodeBase.getRealChildren", 300, "get real children for node: " + ((Object)((Object)this)).toString());
            TreeNode realParent = this.getRealParent(t);
            if (realParent != null) {
                t.data(67, "TreeNodeBase.getRealChildren", 300, "(parent is: " + realParent.toString() + ")");
            }
            int i = 0;
            while (i < this.children.size()) {
                TreeNode child = this.children.get(i);
                if (Trace.isTracing) {
                    t.data(67, "TreeNodeBase.getRealChildren", 300, "        child: " + child.toString());
                }
                ++i;
            }
        }
        return this.children.toArray(new TreeNode[this.children.size()]);
    }

    public boolean hasChildren() {
        Trace t = Trace.getDefault();
        boolean result = this.hasChildren(t);
        return result;
    }

    public boolean hasChildren(Trace t) {
        boolean result;
        boolean bl = result = this.visibleChildren.size() > 0;
        if (Trace.isTracing) {
            t.data(67, "TreeNodeBase.hasChildren", 300, "hasChildren for node: " + ((Object)((Object)this)).toString() + " - ");
            TreeNode realParent = this.getRealParent(t);
            if (realParent != null) {
                t.data(67, "TreeNodeBase.hasChildren", 300, "(parent is: " + realParent.toString() + ")");
            }
            t.data(67, "TreeNodeBase.hasChildren", 300, "result = " + result);
        }
        return result;
    }

    public void setChildren(ArrayList<TreeNode> childlist) {
        Trace t = Trace.getDefault();
        this.children = childlist;
        if (Trace.isTracing) {
            t.data(67, "TreeNodeBase.setChildren", 300, "setChildren for node: " + ((Object)((Object)this)).toString() + " - ");
            TreeNode realParent = this.getRealParent(t);
            if (realParent != null) {
                t.data(67, "TreeNodeBase.setChildren", 300, "(parent is: " + realParent.toString() + ")");
            }
            int i = 0;
            while (i < this.children.size()) {
                TreeNode child = this.children.get(i);
                if (Trace.isTracing) {
                    t.data(67, "TreeNodeBase.setChildren", 300, "        child: " + child.toString());
                }
                ++i;
            }
        }
        this.refreshVisibleChildren();
    }

    public void addChildToNode(TreeNode child, int complex) {
        Trace t = Trace.getDefault();
        boolean isValidTreeNode = true;
        String name = "";
        if (child == null) {
            if (Trace.isTracing) {
                t.data(67, "TreeNodeBase.addChildToNode", 900, "null TreeNode specified");
            }
            if (!isBadTreeNodeFFSTGenerated) {
                t.FFST(67, "TreeNodeBase.addChildToNode", 10, 50999, 0, 0, "Null TreeNode passed to addChildToNode", "", "");
                isBadTreeNodeFFSTGenerated = true;
            }
            isValidTreeNode = false;
        } else {
            String contentId;
            String seq;
            String id;
            if (isValidTreeNode && ((name = child.toString()) == null || name.length() == 0)) {
                if (Trace.isTracing) {
                    t.data(67, "TreeNodeBase.addChildToNode", 900, "TreeNode has invalid name");
                }
                if (!isBadTreeNodeFFSTGenerated) {
                    t.FFST(67, "TreeNodeBase.addChildToNode", 20, 50999, 0, 0, "TreeNode with invalid name passed to addChildToNode", "", "");
                    isBadTreeNodeFFSTGenerated = true;
                }
                isValidTreeNode = false;
            }
            if (isValidTreeNode && ((id = child.getId()) == null || id.length() == 0)) {
                if (Trace.isTracing) {
                    t.data(67, "TreeNodeBase.addChildToNode", 900, "TreeNode '" + name + "' has invalid id");
                }
                if (!isBadTreeNodeFFSTGenerated) {
                    t.FFST(67, "TreeNodeBase.addChildToNode", 30, 50999, 0, 0, "TreeNode with invalid id passed to addChildToNode", "name = '" + name + "'", "");
                    isBadTreeNodeFFSTGenerated = true;
                }
                isValidTreeNode = false;
            }
            if (isValidTreeNode && ((seq = child.getSequence()) == null || seq.length() == 0)) {
                if (Trace.isTracing) {
                    t.data(67, "TreeNodeBase.addChildToNode", 900, "TreeNode '" + name + "' has invalid sequence");
                }
                if (!isBadTreeNodeFFSTGenerated) {
                    t.FFST(67, "TreeNodeBase.addChildToNode", 40, 50999, 0, 0, "TreeNode with invalid sequence passed to addChildToNode", "name = '" + name + "'", "");
                    isBadTreeNodeFFSTGenerated = true;
                }
                isValidTreeNode = false;
            }
            if (isValidTreeNode && ((contentId = child.getContentPageId()) == null || contentId.length() == 0)) {
                if (Trace.isTracing) {
                    t.data(67, "TreeNodeBase.addChildToNode", 900, "TreeNode '" + name + "' has invalid content page id");
                }
                if (!isBadTreeNodeFFSTGenerated) {
                    t.FFST(67, "TreeNodeBase.addChildToNode", 50, 50999, 0, 0, "TreeNode with invalid content page id passed to addChildToNode", "name = '" + name + "'", "");
                    isBadTreeNodeFFSTGenerated = true;
                }
                isValidTreeNode = false;
            }
            if (isValidTreeNode && this.isChildExist(id = child.getId())) {
                if (Trace.isTracing) {
                    t.data(67, "TreeNodeBase.addChildToNode", 900, "TreeNode '" + name + "' is already a child");
                }
                isValidTreeNode = false;
            }
            if (isValidTreeNode) {
                String childId = child.getId();
                String parentId = this.treeNodeId;
                if (parentId != null && childId.compareTo(parentId) == 0) {
                    if (Trace.isTracing) {
                        t.data(67, "TreeNodeBase.addChildToNode", 900, "Id of TreeNode '" + name + "' is the same as the parent");
                    }
                    if (!isBadTreeNodeFFSTGenerated) {
                        t.FFST(67, "TreeNodeBase.addChildToNode", 60, 50999, 0, 0, "TreeNode with TreeNodeId the same as parent passed to addChildToNode", "name = '" + name + "'", "id = '" + childId + "'");
                        isBadTreeNodeFFSTGenerated = true;
                    }
                    isValidTreeNode = false;
                }
            }
        }
        if (isValidTreeNode && child != null) {
            if (Trace.isTracing) {
                t.data(67, "TreeNodeBase.addChildToNode", 300, "addChildToNode for node: " + ((Object)((Object)this)).toString() + " - ");
                TreeNode realParent = this.getRealParent(t);
                if (realParent != null) {
                    t.data(67, "TreeNodeBase.addChildToNode", 300, "(parent is: " + realParent.toString() + ")");
                }
                t.data(67, "TreeNodeBase.addChildToNode", 300, "    adding child: " + child.toString());
            }
            child.setComplexity(complex);
            if (!this.children.contains((Object)child)) {
                this.children.add(child);
                if (child.isVisible()) {
                    this.visibleChildren.add(child);
                }
            }
        }
    }

    public void removeChildFromNode(TreeNode child) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "TreeNodeBase.removeChildFromNode", 300, "TreeNode: " + ((Object)((Object)this)).toString() + " - ");
            TreeNode realParent = this.getRealParent(t);
            if (realParent != null) {
                t.data(67, "TreeNodeBase.removeChildFromNode", 300, "(parent is: " + realParent.toString() + ")");
            }
            if (child != null) {
                t.data(67, "TreeNodeBase.removeChildFromNode", 300, "removing child: " + child.toString());
            }
        }
        if (child != null) {
            this.notifyChildTreeNodesDeleted(t, child);
            UiPlugin.treeNodeDeleted(t, child);
            if (this.children.remove((Object)child) && Trace.isTracing) {
                t.data(67, "TreeNodeBase.removeChildFromNode", 300, "child removed");
            }
            if (child.isVisible()) {
                this.visibleChildren.remove((Object)child);
            }
        } else if (Trace.isTracing) {
            t.data(67, "TreeNodeBase.removeChildFromNode", 900, "null child TreeNode specified");
        }
    }

    private void notifyChildTreeNodesDeleted(Trace t, TreeNode parentTreeNode) {
        TreeNode[] parentsChildren = parentTreeNode.getRealChildren();
        int i = 0;
        while (i < parentsChildren.length) {
            TreeNode child = parentsChildren[i];
            this.notifyChildTreeNodesDeleted(t, child);
            UiPlugin.treeNodeDeleted(t, child);
            ++i;
        }
    }

    public void setChildrenAdded(boolean isAdded) {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            t.data(67, "TreeNodeBase.setChildrenAdded", 300, "setChildrenAdded for node: " + ((Object)((Object)this)).toString() + " - ");
            TreeNode realParent = this.getRealParent(t);
            if (realParent != null) {
                t.data(67, "TreeNodeBase.setChildrenAdded", 300, "(parent is: " + realParent.toString() + ")");
            }
            t.data(67, "TreeNodeBase.setChildrenAdded", 300, "    setChildrenAdded: " + isAdded);
        }
        this.isChildrenAdded = isAdded;
    }

    public boolean isChildrenAdded() {
        return this.isChildrenAdded;
    }

    public boolean isRealChildrenAdded() {
        return this.isRealChildrenAdded;
    }

    public void setRealChildrenAdded(boolean added) {
        this.isRealChildrenAdded = added;
    }

    public void setObject(Object obj) {
        this.object = obj;
    }

    public Object getObject() {
        return this.object;
    }

    public void setComplexity(int complex) {
        this.complexity = complex;
    }

    public int getComplexity() {
        return this.complexity;
    }

    public static int compareBySequence(TreeNode child1, TreeNode child2) {
        DottedDecimal ddSeq2;
        DottedDecimal ddSeq1;
        int result;
        String seq2;
        Trace t = Trace.getDefault();
        String seq1 = child1.getSequence();
        if (seq1 == null) {
            seq1 = "999999999999";
        }
        if ((seq2 = child2.getSequence()) == null) {
            seq2 = "999999999999";
        }
        if ((result = (ddSeq1 = new DottedDecimal(t, seq1)).compareTo(ddSeq2 = new DottedDecimal(t, seq2))) == 99) {
            result = 0;
        }
        return result;
    }

    public static int compareByName(TreeNode child1, TreeNode child2) {
        String string1 = child1.toString();
        String string2 = child2.toString();
        Collator collator = Collator.getInstance(Locale.getDefault());
        int result = collator.compare(string1, string2);
        return result;
    }

    public void setVisible(boolean isVis) {
        this.isVisible = isVis;
        if (this.parent != null) {
            this.parent.refreshVisibleChildren();
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void refreshVisibleChildren() {
        this.visibleChildren.clear();
        int i = 0;
        while (i < this.children.size()) {
            TreeNode child = this.children.get(i);
            if (child.isVisible()) {
                this.visibleChildren.add(child);
            }
            ++i;
        }
    }

    public boolean isChildExist(String childId) {
        boolean exists = false;
        int i = 0;
        while (i < this.children.size()) {
            TreeNode child = this.children.get(i);
            if (child.getTreeNodeId().compareTo(childId) == 0) {
                exists = true;
                break;
            }
            ++i;
        }
        return exists;
    }

    public String getPlugin_id() {
        return this.plugin_id;
    }

    public void setPlugin_id(String string) {
        this.plugin_id = string;
    }

    public void setMqNavigatorView(MQNavigatorView view) {
    }

    public void addCommonChoicesToContextMenu(Trace t, Shell sh, IMenuManager manager, Object contextObject) {
        MenuManager submanager;
        this.shell = sh;
        this.newObjectProvider = this.getNewObjectProvider(t);
        if (this.newObjectProvider != null) {
            int i;
            String[] newObjectTypes = this.newObjectProvider.getNewObjectTypes(t);
            submanager = new MenuManager(TreeNodeBase.getNLSString(t, "KEY_NewObject", "UI.NewObject.New.MenuItem"));
            manager.add((IContributionItem)submanager);
            if (this.actionNewObjectArray == null || this.newObjectProvider.isObjectTypesDynamic()) {
                this.actionNewObjectArray = new Action[newObjectTypes.length];
                i = 0;
                while (i < newObjectTypes.length) {
                    this.actionNewObjectArray[i] = new Action(){

                        public void run() {
                            Trace tr = Trace.getDefault();
                            TreeNodeBase.this.showNewObjectWizard(tr, this.getId());
                        }
                    };
                    this.actionNewObjectArray[i].setText(this.newObjectProvider.getMenuTextForNewObjectType(t, newObjectTypes[i]));
                    this.actionNewObjectArray[i].setId(newObjectTypes[i]);
                    UiPlugin.getHelpSystem().setHelp((IAction)this.actionNewObjectArray[i], this.newObjectProvider.getHelpIdForNewObjectType(t, newObjectTypes[i]));
                    ++i;
                }
            }
            i = 0;
            while (i < newObjectTypes.length) {
                submanager.add((IAction)this.actionNewObjectArray[i]);
                ++i;
            }
        }
        if (this.uiStatusProvider != null && this.uiStatusProvider.getStatusInstances(t, this.uiObject, contextObject) != 0) {
            String[] statusTypes = this.uiStatusProvider.getStatusTypes(t, this.uiObject);
            if (statusTypes.length == 1) {
                if (this.actionStatus == null) {
                    final Object contextObj = contextObject;
                    this.actionStatus = new Action(){

                        public void run() {
                            Trace tr = Trace.getDefault();
                            TreeNodeBase.this.showStatus(tr, this.getId(), contextObj);
                        }
                    };
                    this.actionStatus.setText(this.uiStatusProvider.getActionText(t));
                    UiPlugin.getHelpSystem().setHelp((IAction)this.actionStatus, "com.ibm.mq.explorer.ui.infopop.UI_StatusGenericMenuItem");
                    this.actionStatus.setId(statusTypes[0]);
                }
                manager.add((IAction)this.actionStatus);
            } else if (statusTypes.length > 1) {
                submanager = new MenuManager(this.uiStatusProvider.getMenuText(t));
                manager.add((IContributionItem)submanager);
                if (this.actionStatusArray == null) {
                    final Object contextObj = contextObject;
                    this.actionStatusArray = new Action[statusTypes.length];
                    int i = 0;
                    while (i < statusTypes.length) {
                        this.actionStatusArray[i] = new Action(){

                            public void run() {
                                Trace tr = Trace.getDefault();
                                TreeNodeBase.this.showStatus(tr, this.getId(), contextObj);
                            }
                        };
                        this.actionStatusArray[i].setText(this.uiStatusProvider.getMenuTextForStatusType(t, statusTypes[i]));
                        this.actionStatusArray[i].setId(statusTypes[i]);
                        String helpId = this.uiStatusProvider.getMenuHelpIdForStatusType(t, statusTypes[i]);
                        if (helpId == null) {
                            helpId = this.uiStatusProvider.isGenericStatus(t) ? "com.ibm.mq.explorer.ui.infopop.UI_StatusGenericMenuItem" : "com.ibm.mq.explorer.ui.infopop.UI_StatusMenuItem";
                        }
                        UiPlugin.getHelpSystem().setHelp((IAction)this.actionStatusArray[i], helpId);
                        ++i;
                    }
                }
                int i = 0;
                while (i < statusTypes.length) {
                    submanager.add((IAction)this.actionStatusArray[i]);
                    ++i;
                }
            }
        }
    }

    public void showStatus(Trace t, String statusType, Object contextObject) {
        if (this.uiStatusProvider != null) {
            StatusDialog statusDialog = new StatusDialog(this.shell, 0);
            statusDialog.open(t, this.uiStatusProvider, statusType, this.uiObject, contextObject);
        }
    }

    public NewObjectProvider getNewObjectProvider(Trace t) {
        return this.newObjectProvider;
    }

    public void setNewObjectProvider(Trace t, NewObjectProvider provider) {
        this.newObjectProvider = provider;
    }

    protected void showNewObjectWizard(Trace t, String typeId) {
        String objectId = null;
        if (this.object instanceof UiObject) {
            objectId = ((UiObject)this.object).getId();
        }
        NewObjectWizStarter wizardStarter = new NewObjectWizStarter(t, this.newObjectProvider, typeId, objectId);
        wizardStarter.start(t);
    }

    public static String getNLSString(Trace t, String fileKey, String textKey) {
        String nlsString = "+++" + textKey + "+++";
        Message msgFile = UiPlugin.getUIMessages(t, fileKey);
        if (msgFile != null) {
            nlsString = msgFile.getMessage(t, textKey);
        }
        return nlsString;
    }

    public MQNavigatorView getMqNavigatorView() {
        return UiPlugin.getMQNavigatorView();
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    public boolean isAdvancedTreeNode() {
        return false;
    }

    public boolean isLoadingTreeNode() {
        return this.isLoadingTreeNode;
    }

    public void setLoadingTreeNode(boolean isLoadTreeNode) {
        this.isLoadingTreeNode = isLoadTreeNode;
    }

    public boolean isLoadingAChildTreeNode(Trace t) {
        boolean result = false;
        TreeNode[] ourChildren = this.getChildren();
        int i = 0;
        while (i < ourChildren.length) {
            if (ourChildren[i].isLoadingTreeNode()) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public TreeNode getLoadingChildTreeNode(Trace t, boolean create) {
        TreeNode loadingChild = null;
        int i = 0;
        while (i < this.children.size()) {
            TreeNode child = this.children.get(i);
            if (child.isLoadingTreeNode()) {
                loadingChild = child;
                break;
            }
            ++i;
        }
        if (loadingChild == null && create) {
            loadingChild = LoadingTreeNodeFactory.createLoadingTreeNode(this.thisTreeNode);
        }
        return loadingChild;
    }

    public UiStatusProvider getUiStatusProvider() {
        return this.uiStatusProvider;
    }

    public void setUiStatusProvider(UiStatusProvider uiStatProv) {
        this.uiStatusProvider = uiStatProv;
    }

    public void update() {
        this.updateItem();
        TreeNode[] ourChildren = this.getChildren();
        int i = 0;
        while (i < ourChildren.length) {
            ourChildren[i].update();
            ++i;
        }
    }

    public void updateItem() {
        MQNavigatorView mqNavigatorView = UiPlugin.getMQNavigatorView();
        if (mqNavigatorView != null) {
            mqNavigatorView.getTreeViewer().update((Object)this, null);
        }
    }

    public void refresh() {
        Trace t = Trace.getDefault();
        if (Trace.isTracing) {
            Date date = new Date();
            t.data(67, "TreeNodeBase.refresh", 300, "refresh at " + date.toString());
        }
        if (this.isRefreshTimerRunning) {
            if (Trace.isTracing) {
                t.data(67, "TreeNodeBase.refresh", 300, "refresh timer running - suppressing refresh");
            }
        } else {
            int refreshTimerDelay = UiPlugin.getRefreshTimerDelay();
            if (refreshTimerDelay > 0) {
                UiPlugin.getDisplay().timerExec(refreshTimerDelay, new Runnable(){

                    @Override
                    public void run() {
                        Trace tr = Trace.getDefault();
                        if (Trace.isTracing) {
                            tr.data(67, "TreeNodeBase.refresh", 300, "refresh timer popped - doing refresh");
                        }
                        TreeNodeBase.this.doRefresh(tr);
                        TreeNodeBase.this.isRefreshTimerRunning = false;
                    }
                });
                this.isRefreshTimerRunning = true;
                if (Trace.isTracing) {
                    t.data(67, "TreeNodeBase.refresh", 300, "starting refresh timer");
                }
            } else {
                this.doRefresh(t);
                if (Trace.isTracing) {
                    t.data(67, "TreeNodeBase.refresh", 300, "no refresh timer delay - doing refresh immediately");
                }
            }
        }
    }

    protected void doRefresh(Trace t) {
        UiPlugin.refreshNavigatorViews(t, this.thisTreeNode, true);
    }

    public void setChildrenVisibility(Trace t, boolean visible) {
        if (Trace.isTracing) {
            t.data(67, "TreeNodeBase.setChildrenVisibility", 300, "setChildrenVisibility to " + visible + " for node " + ((Object)((Object)this)).toString() + " with " + this.children.size() + " children");
        }
        int i = 0;
        while (i < this.children.size()) {
            TreeNode child = this.children.get(i);
            child.setVisible(visible);
            ++i;
        }
    }

    public String getTreeNodeId() {
        if ((this.treeNodeId == null || this.treeNodeId.length() == 0) && this.thisTreeNode != null) {
            this.treeNodeId = this.thisTreeNode.getId();
        }
        return this.treeNodeId;
    }

    public void resetTreeNodeId() {
        this.treeNodeId = null;
    }

    public String getUniqueIdentifier(Trace t) {
        String identifier = this.thisTreeNode.toString();
        if (!(identifier != null && identifier.length() != 0 || (identifier = this.thisTreeNode.getTreeNodeId()) != null && identifier.length() != 0)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss:SSS");
            identifier = dateFormat.format(new Date());
        }
        if (Trace.isTracing) {
            t.data(67, "TreeNodeBase.getUniqueIdentifier", 300, "indentifier = " + identifier);
        }
        return identifier;
    }

    public ITreeNodeComparator getTreeNodeComparator() {
        return this.treeNodeComparator;
    }

    public void setTreeNodeComparator(ITreeNodeComparator treeNodeComparator) {
        this.treeNodeComparator = treeNodeComparator;
    }

    public File createDragDropFile() {
        Trace t = Trace.getDefault();
        File file = null;
        XMLMemento rootWrite = this.createXMLMementoForDragDropFile(t);
        this.addStandardInfoForDragDropFile(t, rootWrite);
        file = this.createDragDropFile(t, rootWrite);
        return file;
    }

    public XMLMemento createXMLMementoForDragDropFile(Trace t) {
        XMLMemento rootWrite = XMLMemento.createWriteRoot((String)"TreeNode");
        return rootWrite;
    }

    public XMLMemento createXMLMementoForExportDragDropFile(Trace t) {
        XMLMemento rootWrite = XMLMemento.createWriteRoot((String)"MQExplorer");
        return rootWrite;
    }

    public IMemento createImportExportChild(Trace t, XMLMemento rootWrite, String category, String subcategory) {
        IMemento categoryMemento = rootWrite.createChild("category", category);
        IMemento subcategoryMemento = categoryMemento.createChild("subcategory", subcategory);
        return subcategoryMemento;
    }

    public void addStandardInfoForDragDropFile(Trace t, XMLMemento rootWrite) {
        if (rootWrite != null) {
            IMemento child;
            rootWrite.putString("FileVersion", THIS_VERSION);
            rootWrite.putString("Name", this.thisTreeNode.toString());
            rootWrite.putString("Id", this.thisTreeNode.getTreeNodeId());
            rootWrite.putString("PluginId", this.thisTreeNode.getPlugin_id());
            if (this.parent != null && (child = this.openChild(t, (IMemento)rootWrite, "Parent")) != null) {
                child.putString("Name", this.parent.toString());
                child.putString("Id", this.parent.getTreeNodeId());
                child.putString("PluginId", this.parent.getPlugin_id());
            }
        }
    }

    public File createDragDropFile(Trace t, XMLMemento rootWrite) {
        File file = null;
        if (rootWrite != null) {
            OutputStreamWriter writer = null;
            try {
                try {
                    try {
                        file = File.createTempFile(String.valueOf(this.thisTreeNode.toString()) + "_", ".xml");
                    }
                    catch (IOException iOException) {
                        file = File.createTempFile(this.encodeUrl(t, String.valueOf(this.thisTreeNode.toString()) + "_"), ".xml");
                    }
                    FileOutputStream output = new FileOutputStream(file);
                    writer = new OutputStreamWriter(output);
                    rootWrite.save((Writer)writer);
                }
                catch (IOException e) {
                    t.FFST(67, "TreeNodeBase.createDragDropFile", 10, -1, 0, 0, e.getMessage(), null, null);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException e1) {
                        t.FFST(67, "TreeNodeBase.createDragDropFile", 20, -1, 0, 0, e1.getMessage(), null, null);
                    }
                }
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e1) {
                    t.FFST(67, "TreeNodeBase.createDragDropFile", 20, -1, 0, 0, e1.getMessage(), null, null);
                }
            }
        }
        return file;
    }

    public IMemento openChild(Trace t, IMemento parentMemento, String childName) {
        IMemento child = null;
        child = parentMemento.getChild(childName);
        if (child == null) {
            child = parentMemento.createChild(childName);
        }
        return child;
    }

    private String encodeUrl(Trace t, String inputURL) {
        String encodedURL;
        block2: {
            encodedURL = inputURL;
            try {
                encodedURL = URLEncoder.encode(encodedURL, ENCODING_TYPE);
            }
            catch (UnsupportedEncodingException e) {
                if (!Trace.isTracing) break block2;
                t.data(67, "TreeNodeBase.encodeUrl", 900, "UnsupportedEncodingException decoding the URL:" + inputURL);
                t.data(67, "TreeNodeBase.encodeUrl", 900, e.getMessage());
            }
        }
        return encodedURL;
    }
}

