/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.navigator;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.IExplorerExternalDragDrop;
import com.ibm.mq.explorer.ui.extensions.IExplorerTreeNodeDragDrop;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.dragdrop.MultipleTreeNodeDragDrop;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class NavigatorDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/navigator/NavigatorDropAdapterAssistant.java";

    public boolean isSupportedType(TransferData aTransferType) {
        return super.isSupportedType(aTransferType) || FileTransfer.getInstance().isSupportedType(aTransferType);
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent event, Object target) {
        Trace t = Trace.getDefault();
        IStatus status = Status.CANCEL_STATUS;
        if (target instanceof IExplorerExternalDragDrop) {
            IExplorerExternalDragDrop explorerDragDropTarget = (IExplorerExternalDragDrop)target;
            boolean success = explorerDragDropTarget.dropAction(event.data, event.detail);
            if (success) {
                status = Status.OK_STATUS;
            }
        } else if (target instanceof IExplorerTreeNodeDragDrop) {
            List<TreeNode> nodes;
            boolean success;
            IExplorerTreeNodeDragDrop dragdropNode = (IExplorerTreeNodeDragDrop)target;
            Object item = event.data;
            if (item instanceof IStructuredSelection && (success = MultipleTreeNodeDragDrop.dropAction(t, dragdropNode, event.detail, nodes = this.getTreeNodesFromSelection((IStructuredSelection)item)))) {
                status = Status.OK_STATUS;
            }
        }
        return status;
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        IExplorerTreeNodeDragDrop dragdropNode;
        int supportedDrops;
        IStructuredSelection selection;
        List<TreeNode> treeNodes;
        Trace t = Trace.getDefault();
        IStatus status = Status.CANCEL_STATUS;
        boolean isFile = FileTransfer.getInstance().isSupportedType(transferType);
        if (target instanceof IExplorerExternalDragDrop && isFile) {
            IExplorerExternalDragDrop explorerDragDropTarget = (IExplorerExternalDragDrop)target;
            int supportedDrops2 = explorerDragDropTarget.getAcceptedOperations(transferType);
            if (supportedDrops2 != 0) {
                status = Status.OK_STATUS;
                if ((supportedDrops2 & operation) == 0) {
                    this.getCommonDropAdapter().overrideOperation(supportedDrops2);
                }
            }
        } else if (target instanceof IExplorerTreeNodeDragDrop && !isFile && (treeNodes = this.getTreeNodesFromSelection(selection = (IStructuredSelection)UiPlugin.getMQNavigatorViewSelection(Trace.getDefault()))).size() > 0 && (supportedDrops = MultipleTreeNodeDragDrop.getAcceptedOperations(t, dragdropNode = (IExplorerTreeNodeDragDrop)target, treeNodes)) != 0) {
            status = Status.OK_STATUS;
            if ((supportedDrops & operation) == 0) {
                this.getCommonDropAdapter().overrideOperation(supportedDrops);
            }
        }
        return status;
    }

    private List<TreeNode> getTreeNodesFromSelection(IStructuredSelection selection) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (Object obj : selection.toList()) {
            if (!(obj instanceof TreeNode)) continue;
            nodes.add((TreeNode)((Object)obj));
        }
        return nodes;
    }
}

