/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.navigator;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;

public class NavigatorDragAdapterAssistant
extends CommonDragAdapterAssistant {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/navigator/NavigatorDragAdapterAssistant.java";

    public Transfer[] getSupportedTransferTypes() {
        Transfer[] transfers = UiPlugin.getDragDropManager().getDragSourceTransferClasses(Trace.getDefault(), "com.ibm.mq.explorer.ui.internal.views.mqnavigator");
        return transfers;
    }

    public boolean setDragData(DragSourceEvent event, IStructuredSelection selection) {
        List<TreeNode> nodes;
        if (selection != null && (nodes = this.getTreeNodesFromSelection(selection)).size() > 0) {
            if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                ArrayList<String> paths = new ArrayList<String>(nodes.size());
                for (TreeNode treeNode : nodes) {
                    File xferFile = treeNode.createDragDropFile();
                    if (xferFile == null) continue;
                    paths.add(xferFile.getAbsolutePath());
                }
                event.data = paths.toArray(new String[0]);
                return true;
            }
            event.data = nodes;
            return true;
        }
        return false;
    }

    private List<TreeNode> getTreeNodesFromSelection(IStructuredSelection selection) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (Object obj : selection.toList()) {
            if (!(obj instanceof TreeNode)) continue;
            nodes.add((TreeNode)((Object)obj));
        }
        return nodes;
    }
}

