/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.navigator;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.ITreeNodeFactory;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.TreeNodeDeletedEvent;
import com.ibm.mq.explorer.ui.internal.base.TreeNodeDeletedListener;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.machine.MachineTreeNode;
import com.ibm.mq.explorer.ui.internal.machine.UiMachine;
import com.ibm.mq.explorer.ui.internal.navigator.RootTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class NavigatorContentProvider
implements ICommonContentProvider,
TreeNodeDeletedListener,
ITreeViewerListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/navigator/NavigatorContentProvider.java";
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private CommonViewer viewer;
    private MachineTreeNode machTreeNode;
    private List<ITreeNodeFactory> factories = null;
    private Map<String, TreeNode> allTreeNodes = new HashMap<String, TreeNode>();
    private boolean isRebuildTree = false;

    public Object[] getChildren(Object parentElement) {
        Trace t = Trace.getDefault();
        Object[] childrenArray = EMPTY_ARRAY;
        if (parentElement instanceof RootTreeNode) {
            if (this.machTreeNode == null && UiPlugin.isInitialized()) {
                this.factories = UiPlugin.getTreeNodeFactoriesArray();
                this.addChildren(t, (TreeNode)((Object)parentElement), false);
                UiMachine uiMachine = UiPlugin.getUiMachineObject();
                this.machTreeNode = (MachineTreeNode)uiMachine.getTreeNode();
                UiPlugin.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UiPlugin.sendInitialization(Trace.getDefault(), NavigatorContentProvider.this);
                        NavigatorContentProvider.this.viewer.expandToLevel(2);
                    }
                });
            }
            if (this.machTreeNode == null) {
                return new Object[]{new MachineTreeNode((TreeNode)((Object)parentElement), null)};
            }
            childrenArray = new Object[]{this.machTreeNode};
        } else if (parentElement instanceof TreeNode) {
            TreeNode parentTreeNode = (TreeNode)((Object)parentElement);
            if (this.isRebuildTree) {
                parentTreeNode.setChildrenAdded(false);
            }
            if (!parentTreeNode.isChildrenAdded()) {
                this.addChildrenToNode(Trace.getDefault(), parentTreeNode, false);
            }
            TreeNode[] children = parentTreeNode.getChildren();
            ArrayList<TreeNode> enabledChildren = new ArrayList<TreeNode>();
            int i = 0;
            while (i < children.length) {
                TreeNode child = children[i];
                if (child.isVisible() && UiPlugin.isPluginEnabled(child.getPlugin_id())) {
                    enabledChildren.add(child);
                }
                ++i;
            }
            childrenArray = enabledChildren.toArray(new TreeNode[enabledChildren.size()]);
        }
        return childrenArray;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof RootTreeNode) {
            return true;
        }
        if (element instanceof TreeNode) {
            TreeNode node = (TreeNode)((Object)element);
            return node.hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void inputChanged(Viewer view, Object oldInput, Object newInput) {
        if (view instanceof CommonViewer) {
            this.viewer = (CommonViewer)view;
            this.viewer.setAutoExpandLevel(2);
            this.viewer.addTreeListener((ITreeViewerListener)this);
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object obj;
                    ISelection selection = NavigatorContentProvider.this.viewer.getSelection();
                    if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof TreeNode) {
                        TreeNode treeNode = (TreeNode)((Object)obj);
                        UiPlugin.getHelpSystem().setHelp(NavigatorContentProvider.this.viewer.getControl(), treeNode.getHelpId());
                    }
                }
            });
        }
    }

    public void init(ICommonContentExtensionSite aConfig) {
        Trace t = Trace.getDefault();
        UiPlugin.addITreeNodeDeletedListener(t, this);
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void addChildrenToNode(Trace t, TreeNode parentTreeNode, boolean expandingNode) {
        if (Trace.isTracing) {
            t.data(67, "NavigatorContentProvider.addChildrenToNode", 300, "addChildren to TreeNode: " + parentTreeNode.toString());
        }
        this.addChildren(t, parentTreeNode, expandingNode);
    }

    protected void addChildren(Trace t, TreeNode parent, boolean expandingNode) {
        if (Trace.isTracing) {
            t.data(67, "NavigatorContentProvider.addChildren", 300, "addChildren to TreeNode: " + parent.toString());
        }
        if (!parent.isChildrenAdded() || this.isRebuildTree) {
            if (!expandingNode && parent.isAddChildrenWhenExpanded() && !parent.isRealChildrenAdded()) {
                if (Trace.isTracing) {
                    t.data(67, "NavigatorContentProvider.addChildren", 300, "adding 'loading...' TreeNode");
                }
                if (!parent.isLoadingAChildTreeNode(t)) {
                    parent.getLoadingChildTreeNode(t, true);
                    parent.setChildrenAdded(false);
                }
            } else {
                this.getChildTreeNodesFromFactory(t, parent);
            }
        }
    }

    private void getChildTreeNodesFromFactory(Trace t, TreeNode parent) {
        for (ITreeNodeFactory factory : this.factories) {
            if (UiPlugin.isPluginEnabledForTreeNodeFactory(t, factory)) {
                if (Trace.isTracing) {
                    t.data(67, "NavigatorContentProvider.getChildTreeNodesFromFactory", 300, "  adding children from factory: " + factory.toString());
                }
                factory.addChildrenToTreeNode(parent);
                continue;
            }
            if (!Trace.isTracing) continue;
            t.data(67, "NavigatorContentProvider.getChildTreeNodesFromFactory", 300, "  ignoring factory: " + factory.toString() + ", its plug-in is disabled");
        }
        parent.setChildrenAdded(true);
        TreeNode[] children = parent.getChildren();
        if (children.length > 0) {
            TreeNode[] treeNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                TreeNode treeNode = treeNodeArray[n2];
                this.allTreeNodes.put(treeNode.getTreeNodeId(), treeNode);
                this.addChildren(t, treeNode, false);
                ++n2;
            }
        }
    }

    public TreeNode findTreeNode(Trace t, String treeNodeId) {
        return this.allTreeNodes.get(treeNodeId);
    }

    @Override
    public void treeNodeDeleted(TreeNodeDeletedEvent event) {
        IStructuredSelection ssel;
        TreeNode treeNode = event.getDeletedTreeNode();
        this.allTreeNodes.remove(treeNode.getTreeNodeId());
        ISelection sel = this.viewer.getSelection();
        if (sel instanceof IStructuredSelection && (ssel = (IStructuredSelection)sel).size() == 1 && ((Object)((Object)treeNode)).equals(ssel.getFirstElement())) {
            final TreeNode parent = treeNode.getParent();
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    NavigatorContentProvider.this.viewer.setSelection((ISelection)new StructuredSelection((Object)parent), true);
                    NavigatorContentProvider.this.viewer.reveal((Object)parent);
                }
            });
        }
    }

    public void loadRealChildren(Trace t, TreeNode treeNode) {
        if (treeNode.isLoadingAChildTreeNode(t)) {
            TreeNode loadingTreeNode = treeNode.getLoadingChildTreeNode(t, false);
            treeNode.removeChildFromNode(loadingTreeNode);
        }
        this.getChildTreeNodesFromFactory(t, treeNode);
        treeNode.setRealChildrenAdded(true);
    }

    public void setRebuildTree(boolean isRebuildTree) {
        this.isRebuildTree = isRebuildTree;
    }

    public void dispose() {
        Trace t = Trace.getDefault();
        UiPlugin.removeTreeNodeDeletedListener(t, this);
    }

    private void treeNodeExpansionChanged(Trace t, TreeNode treeNode, boolean expanded) {
        treeNode.setExpanded(expanded);
        if (expanded && treeNode.isAddChildrenWhenExpanded() && !treeNode.isRealChildrenAdded()) {
            this.loadRealChildren(t, treeNode);
            Display display = UiPlugin.getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Trace tr = Trace.getDefault();
                    UiPlugin.refreshNavigatorViews(tr, false);
                }
            });
        }
    }

    public void treeCollapsed(TreeExpansionEvent event) {
        Trace t = Trace.getDefault();
        if (event.getElement() instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)((Object)event.getElement());
            this.treeNodeExpansionChanged(t, treeNode, false);
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Trace t = Trace.getDefault();
        if (event.getElement() instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)((Object)event.getElement());
            this.treeNodeExpansionChanged(t, treeNode, true);
        }
    }
}

