/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.navigator;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.actions.MultipleSelectionAction;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;

public class NavigatorActionProvider
extends CommonActionProvider {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/navigator/NavigatorActionProvider.java";
    private IAction refreshAction;

    public void fillActionBars(IActionBars bars) {
        if (this.refreshAction == null) {
            this.refreshAction = new Action(){

                public void run() {
                    UiPlugin.refreshNavigatorViews(Trace.getDefault(), true);
                }
            };
        }
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.refreshAction);
        bars.updateActionBars();
    }

    public void fillContextMenu(IMenuManager manager) {
        Trace t = Trace.getDefault();
        ISelection selection = this.getActionSite().getStructuredViewer().getSelection();
        if (selection != null) {
            IStructuredSelection iss = (IStructuredSelection)selection;
            Object obj = iss.getFirstElement();
            if (obj != null && obj instanceof TreeNode) {
                TreeNode treeNode = (TreeNode)((Object)obj);
                Shell shell = this.getActionSite().getViewSite().getShell();
                if (iss.size() == 1) {
                    if (treeNode.isContextMenuFromUiObject()) {
                        MQExtObject extObj = (MQExtObject)treeNode.getObject();
                        if (extObj != null) {
                            UiMQObject uiMQObject = (UiMQObject)extObj.getInternalObject();
                            uiMQObject.appendToContextMenu(shell, manager, treeNode.getTreeNodeId());
                        }
                    } else {
                        treeNode.addCommonChoicesToContextMenu(t, shell, manager, treeNode.getTreeNodeId());
                        treeNode.appendToContextMenu(shell, manager);
                    }
                } else {
                    MultipleSelectionAction.createMultipleSelectionEntries(t, shell, manager, this.getTreeNodesFromSelection(iss));
                }
            }
            manager.remove("additions");
            manager.add((IContributionItem)new Separator("additions"));
        }
    }

    private List<TreeNode> getTreeNodesFromSelection(IStructuredSelection selection) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        for (Object obj : selection.toList()) {
            if (!(obj instanceof TreeNode)) continue;
            nodes.add((TreeNode)((Object)obj));
        }
        return nodes;
    }
}

