/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.messagebox;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class MessageBoxWithDetails
extends ErrorDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/messagebox/MessageBoxWithDetails.java";
    private String[] buttons;
    private int defaultIndex;
    private boolean isQuestion;
    private boolean showToggle;
    private boolean showDetails;
    private boolean toggleState;

    protected MessageBoxWithDetails(Trace t, Shell parentShell, String dialogTitle, IStatus status, boolean isQuestion, String[] buttons, int defaultIndex, boolean showToggle, boolean showDetails) {
        super(parentShell, dialogTitle, null, status, 7);
        this.isQuestion = isQuestion;
        this.buttons = buttons;
        this.defaultIndex = defaultIndex;
        this.showToggle = showToggle;
        this.showDetails = showDetails;
    }

    public static int showMessageWithDetails(Trace t, Shell parent, String title, String message, int imageType, String[] strButtonsAry, int defaultIndex, String help) {
        boolean suppressIsChecked;
        boolean successDialogsAreSuppressed;
        int severity = CommonServices.getSystemMessageSeverity((Trace)t, (String)help);
        int statusSev = 2;
        boolean showToggle = false;
        switch (severity) {
            case 0: {
                statusSev = 1;
                showToggle = true;
                break;
            }
            case 5: {
                statusSev = 1;
                break;
            }
            case 10: {
                statusSev = 2;
                break;
            }
            default: {
                statusSev = 4;
            }
        }
        IPreferenceStore prefStore = UiPlugin.getPrefStore();
        if (showToggle && (successDialogsAreSuppressed = prefStore.getBoolean("SuppressSuccessDialog"))) {
            return 0;
        }
        String messageXPL = CommonServices.getSystemMessage((String)(String.valueOf(help) + ".XPL"));
        String messageURESP = CommonServices.getSystemMessage((String)(String.valueOf(help) + ".URESP"));
        boolean validXPL = help != null && !messageXPL.equals("");
        boolean validURESP = help != null && !messageURESP.equals("");
        boolean showDetails = validXPL | validURESP;
        String detailSeverity = CommonServices.getSystemMessage((String)"Details.severity");
        String detailExplain = CommonServices.getSystemMessage((String)"Details.explanation");
        String detailResponse = CommonServices.getSystemMessage((String)"Details.response");
        String sevNum = CommonServices.getSystemMessage((String)(String.valueOf(help) + ".SEVERITY"));
        String sevString = CommonServices.getSystemMessage((String)sevNum);
        String severityStr = Message.format((String)detailSeverity, (String)sevNum, (String)sevString);
        String explain = Message.format((String)detailExplain, (String)messageXPL);
        String response = Message.format((String)detailResponse, (String)messageURESP);
        MultiStatus info = new MultiStatus(UiPlugin.getPluginId(), 1, message, null);
        boolean isQuestion = imageType == 3;
        MessageBoxWithDetails.addToStatus(info, statusSev, message);
        MessageBoxWithDetails.addToStatus(info, statusSev, severityStr);
        if (validXPL) {
            MessageBoxWithDetails.addToStatus(info, statusSev, explain);
        }
        if (validURESP) {
            MessageBoxWithDetails.addToStatus(info, statusSev, response);
        }
        MessageBoxWithDetails mb = new MessageBoxWithDetails(t, parent, title, (IStatus)info, isQuestion, strButtonsAry, defaultIndex, showToggle, showDetails);
        int pressed = mb.open();
        if (showToggle && (suppressIsChecked = mb.getToggleState()) != prefStore.getBoolean("SuppressSuccessDialog")) {
            prefStore.setValue("SuppressSuccessDialog", suppressIsChecked);
        }
        return pressed;
    }

    private static void addToStatus(MultiStatus info, int severity, String message) {
        String[] lines = message.split("\n");
        int i = 0;
        while (i < lines.length) {
            info.add((IStatus)new Status(severity, UiPlugin.getPluginId(), 1, lines[i], null));
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        if (this.showToggle) {
            this.createToggleArea(dialogAreaComposite);
        }
        return dialogAreaComposite;
    }

    private void createToggleArea(Composite parent) {
        final Button button = new Button(parent, 16416);
        Label labelReenableInfo = new Label(parent, 0);
        Trace t = Trace.getDefault();
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        final String toggleButtonMsg = msgFile.getMessage(t, "UI.Dialog.Success.Suppress");
        final String toggleLabelMsg = msgFile.getMessage(t, "UI.Dialog.Success.SuppressInfo");
        GridData data = new GridData(0);
        data.horizontalSpan = 2;
        data.verticalIndent = 10;
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        button.setText(toggleButtonMsg);
        data = new GridData(0);
        data.horizontalSpan = 2;
        labelReenableInfo.setLayoutData((Object)data);
        labelReenableInfo.setFont(parent.getFont());
        labelReenableInfo.setText(toggleLabelMsg);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBoxWithDetails.this.toggleState = button.getSelection();
            }
        });
        button.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = String.valueOf(toggleButtonMsg) + ". " + toggleLabelMsg;
            }
        });
    }

    private boolean getToggleState() {
        return this.toggleState;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        int i = 0;
        while (i < this.buttons.length) {
            boolean isDefault = this.defaultIndex == i;
            this.createButton(parent, i, this.buttons[i], isDefault);
            ++i;
        }
        this.createDetailsButton(parent);
    }

    protected Image getImage() {
        if (this.isQuestion) {
            return this.getQuestionImage();
        }
        return super.getImage();
    }

    public void create() {
        super.create();
        if (this.showDetails) {
            UiPlugin.getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.mq.explorer.ui.infopop.UI_MessageBoxWithDetails");
        } else {
            UiPlugin.getHelpSystem().setHelp((Control)this.getShell(), "com.ibm.mq.explorer.ui.infopop.UI_MessageBox");
        }
        Button defaultButton = this.getShell().getDefaultButton();
        if (defaultButton != null) {
            defaultButton.setFocus();
        }
    }

    protected boolean shouldShowDetailsButton() {
        if (this.showDetails) {
            return super.shouldShowDetailsButton();
        }
        return false;
    }
}

