/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.messagebox;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBoxWithDetails;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageInfo;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class MessageBox {
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/messagebox/MessageBox.java";
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final int YES = 0;
    public static final int NO = 1;
    public static final int OK = 0;
    public static final int CANCEL = 1;
    public static final int X = -1;
    private static List<MessageInfo> queue = Collections.synchronizedList(new LinkedList());
    private static MessageInfo currentMessage = null;

    public static void showSystemMessageById(Trace t, Shell shell, String messageID) {
        MessageBox.showSystemMessageById(t, shell, messageID, null);
    }

    public static void showSystemMessageById(Trace t, Shell shell, String messageID, String[] inserts) {
        MessageBox.showSystemMessageByMessageId(t, shell, messageID, inserts, null, null);
    }

    @Deprecated
    public static void showSystemMessageById(Trace t, Shell shell, String messageID, String[] inserts, String help) {
        MessageBox.showSystemMessageByMessageId(t, shell, messageID, inserts, null, null);
    }

    @Deprecated
    public static void showSystemMessageById(Trace t, Shell shell, String messageID, String[] inserts, String help, Image titleImage) {
        MessageBox.showSystemMessageByMessageId(t, shell, messageID, inserts, titleImage, null);
    }

    public static void showSystemMessageById(Trace t, Shell shell, String messageID, String[] inserts, Image titleImage) {
        MessageBox.showSystemMessageByMessageId(t, shell, messageID, inserts, titleImage, null);
    }

    @Deprecated
    public static void showSystemMessageById(Trace t, Shell shell, String messageID, String[] inserts, String help, Image titleImage, String messageOverride) {
        MessageBox.showSystemMessageByMessageId(t, shell, messageID, inserts, titleImage, messageOverride);
    }

    public static void showSystemMessageByMessageId(Trace t, Shell shell, String messageID, String[] inserts, Image titleImage, String messageOverride) {
        String message = messageOverride != null ? messageOverride : (inserts != null ? CommonServices.getSystemMessage((String)messageID, (String[])inserts) : CommonServices.getSystemMessage((String)messageID));
        int severity = CommonServices.getSystemMessageSeverity((Trace)t, (String)messageID);
        switch (severity) {
            case 0: 
            case 5: {
                MessageBox.showMessageSuccess(t, shell, message, messageID, titleImage);
                break;
            }
            case 10: {
                MessageBox.showMessageFailure(t, shell, message, messageID, titleImage);
                break;
            }
            default: {
                MessageBox.showException(t, shell, new MessageInfo(message, messageID, severity));
            }
        }
    }

    public static int showMessage(Trace t, Shell parent, String title, Image titleImage, String message, int imageType, String[] strButtonsAry, int defaultIndex, String help) {
        int pressed = 0;
        pressed = parent != null && parent.isDisposed() || titleImage != null && titleImage.isDisposed() ? 1 : MessageBoxWithDetails.showMessageWithDetails(t, parent, title, message, imageType, strButtonsAry, defaultIndex, help);
        return pressed;
    }

    public static int showMessage(Trace t, Shell parent, String message, int imageType, String[] strButtonsAry, int defaultIndex, String help) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        String title = msgFile.getMessage(t, "UI.GENERAL.MQ");
        return MessageBox.showMessage(t, parent, title, null, message, imageType, strButtonsAry, defaultIndex, help);
    }

    public static int showExceptionMessage(Trace t, Shell shell, DmCoreException e) {
        String message = e.getMessage();
        String messageId = e.getMessageID();
        int severity = e.getSeverity();
        MessageInfo mi = new MessageInfo(message, messageId, severity);
        int i = MessageBox.showException(t, shell, mi);
        return i;
    }

    public static int showExceptionMessage(Trace t, Shell shell, CommonServicesException e) {
        String message = e.getMessage();
        String messageId = e.getMessageID();
        int severity = e.getSeverity();
        MessageInfo mi = new MessageInfo(message, messageId, severity);
        int i = MessageBox.showException(t, shell, mi);
        return i;
    }

    private static int showException(Trace t, Shell shell, MessageInfo info) {
        int rc = -1;
        if (info != null && !queue.contains(info)) {
            queue.add(info);
        }
        if (currentMessage == null && queue.size() > 0) {
            int img;
            currentMessage = queue.get(0);
            String message = currentMessage.getMessage();
            String messageId = currentMessage.getMessageId();
            int severity = currentMessage.getSeverity();
            Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
            String title = msgFile.getMessage(t, "UI.GENERAL.MQ");
            switch (severity) {
                case 0: {
                    img = 2;
                    break;
                }
                case 10: {
                    img = 4;
                    break;
                }
                case 40: {
                    img = 1;
                    break;
                }
                default: {
                    img = 1;
                }
            }
            String[] buttons = new String[]{msgFile.getMessage(t, "UI.GENERAL.CLOSE")};
            if (Trace.isTracing) {
                t.data(67, "MessageBox.showException", 900, "Showing Exception message box...");
                t.data(67, "MessageBox.showException", 900, message);
            }
            rc = MessageBox.showMessage(t, shell, title, Icons.get(Icons.iconkeyExplorerSmall), message, img, buttons, 0, messageId);
            currentMessage = null;
            queue.remove(0);
            MessageBox.showException(t, shell, null);
        }
        return rc;
    }

    public static int showYesNoMessage(Trace t, Shell shell, String message, int def, String helpId) {
        return MessageBox.showYesNoMessage(t, shell, null, null, message, def, helpId);
    }

    public static int showYesNoMessage(Trace t, Shell shell, String title, String message, int def, String helpId) {
        return MessageBox.showYesNoMessage(t, shell, title, null, message, def, helpId);
    }

    public static int showYesNoMessage(Trace t, Shell shell, String title, Image titleImage, String message, int def, String helpId) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        int i = MessageBox.showMessage(t, shell, title == null ? msgFile.getMessage(t, "UI.GENERAL.MQ") : title, titleImage == null ? Icons.get(Icons.iconkeyExplorerSmall) : titleImage, message, 3, new String[]{msgFile.getMessage(t, "UI.GENERAL.YES.UNDERLINE"), msgFile.getMessage(t, "UI.GENERAL.NO.UNDERLINE")}, def, helpId);
        return i;
    }

    public static int showDeleteCancelMessage(Trace t, Shell shell, String message, int def, String helpId) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        int i = MessageBox.showMessage(t, shell, msgFile.getMessage(t, "UI.GENERAL.MQ"), Icons.get(Icons.iconkeyExplorerSmall), message, 4, new String[]{msgFile.getMessage(t, "UI.Dialog.Delete.Button.Text"), msgFile.getMessage(t, "UI.GENERAL.CANCEL")}, def, helpId);
        return i;
    }

    public static void showMessageSuccess(Trace t, Shell shell, String message) {
        MessageBox.showMessageSuccess(t, shell, message, null, null);
    }

    public static void showMessageSuccess(Trace t, Shell shell, String message, String help, Image titleImage) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        String title = msgFile.getMessage(t, "UI.GENERAL.MQ");
        MessageBox.showMessage(t, shell, title, titleImage == null ? Icons.get(Icons.iconkeyExplorerSmall) : titleImage, message, 2, new String[]{msgFile.getMessage(t, "UI.GENERAL.OK")}, 0, help);
    }

    public static void showMessageFailure(Trace t, Shell shell, String message) {
        MessageBox.showMessageFailure(t, shell, message, null);
    }

    public static void showMessageFailure(Trace t, Shell shell, String message, Image titleImage) {
        MessageBox.showMessageFailure(t, shell, message, null, titleImage);
    }

    public static void showMessageFailure(Trace t, Shell shell, String message, String help) {
        MessageBox.showMessageFailure(t, shell, message, help, null);
    }

    public static void showMessageFailure(Trace t, Shell shell, String message, String help, Image titleImage) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        String title = msgFile.getMessage(t, "UI.GENERAL.MQ");
        if (Trace.isTracing) {
            t.data(67, "MessageBox.showMessageFailure", 900, "Showing failure message box...");
            t.data(67, "MessageBox.showMessageFailure", 900, message);
        }
        MessageBox.showMessage(t, shell, title, titleImage == null ? Icons.get(Icons.iconkeyExplorerSmall) : titleImage, message, 1, new String[]{msgFile.getMessage(t, "UI.GENERAL.CLOSE")}, 0, help);
    }

    public static void showMessageFailure(Trace t, Shell shell, String message, Exception e, String help) {
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        String title = msgFile.getMessage(t, "UI.GENERAL.MQ");
        String reason = msgFile.getMessage(t, "UI.GENERAL.REASON");
        String combinedMessage = String.valueOf(message) + "\n\n" + reason + "\n" + e.getMessage();
        if (Trace.isTracing) {
            t.data(67, "MessageBox.showMessageFailure", 900, "Showing failure message box...");
            t.data(67, "MessageBox.showMessageFailure", 900, combinedMessage);
        }
        MessageBox.showMessage(t, shell, title, Icons.get(Icons.iconkeyExplorerSmall), combinedMessage, 1, new String[]{msgFile.getMessage(t, "UI.GENERAL.CLOSE")}, 0, help);
    }
}

