/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.messagebox;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.console.ConsoleAnimation;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class BusyDialog
extends Dialog {
    public static final int DEFAULT_MINIMUM_OPEN_TIME_SEC = 3;
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/messagebox/BusyDialog.java";
    private static final int DEFAULT_CANVAS_HEIGHT = 50;
    private static final int DEFAULT_CANVAS_WIDTH = 50;
    private static final int DEFAULT_TIMEOUT_VALUE = 300000;
    private static final int INVISIBLE_TIME = 800;
    private Shell shell;
    private Shell parent;
    private Display display;
    private ImageLoader loader = null;
    private Canvas canvas;
    private long openedTime = 0L;
    private boolean isShowCloseButton = false;
    private Label labelBottomPad = null;
    private Button buttonClose = null;
    private String completed = null;
    private String closeText = "";
    private String cancelText = "";
    private boolean closed = false;
    private GC gc = null;
    private ConsoleAnimation animation = null;
    private static Image image = null;
    private boolean isShowCancelButton = false;

    public BusyDialog(Shell parentShell, String text, boolean cancel) {
        super(parentShell);
        this.parent = parentShell;
        this.display = this.parent.getDisplay();
        this.isShowCancelButton = cancel;
        this.init(Trace.getDefault(), text);
    }

    public BusyDialog(Shell parentShell, String text) {
        this(parentShell, text, false);
    }

    private void init(Trace t, String text) {
        this.shell = new Shell(this.parent, 67616);
        this.shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (BusyDialog.this.gc != null) {
                    BusyDialog.this.gc.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
        });
        Message msgFile = UiPlugin.getUIMessages(t, "KEY_General");
        String nlsTitle = "";
        if (msgFile != null) {
            nlsTitle = msgFile.getMessage(t, "UI.GENERAL.MQ");
            this.completed = msgFile.getMessage(t, "UI.GENERAL.COMPLETED");
            this.closeText = msgFile.getMessage(t, "UI.GENERAL.CLOSE");
            this.cancelText = msgFile.getMessage(t, "UI.GENERAL.CANCEL");
        }
        this.shell.setText(nlsTitle);
        this.shell.setImage(Icons.get(Icons.iconkeyExplorerSmall));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.shell.setLayout((Layout)gridLayout);
        int canvasHeight = 50;
        int canvasWidth = 50;
        String gif = "/com/ibm/mq/explorer/ui/internal/console/amqiin8n.gif";
        this.loader = new ImageLoader();
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream(gif);
            if (is == null) {
                t.FFST(67, "BusyDialog.init", 1, 50036, 0, 0, gif, null, null);
            } else {
                this.loader.load(is);
                canvasHeight = this.loader.logicalScreenHeight;
                canvasWidth = this.loader.logicalScreenWidth;
                image = new Image((Device)this.display, this.loader.data[0]);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                t.data(67, "BusyDialog.init", e.toString());
            }
        }
        this.canvas = new Canvas((Composite)this.shell, 262144);
        GridData data = new GridData();
        data.verticalSpan = 3;
        data.horizontalSpan = 2;
        data.heightHint = canvasHeight;
        data.widthHint = canvasWidth;
        this.canvas.setLayoutData((Object)data);
        if (this.gc != null) {
            this.gc.dispose();
        }
        this.gc = new GC((Drawable)image);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                block2: {
                    try {
                        event.gc.drawImage(image, 0, 0);
                    }
                    catch (IllegalArgumentException e) {
                        if (!Trace.isTracing) break block2;
                        Trace.getDefault().data(67, "BusyDialog.init", 300, "illegal argument exception " + e.getMessage());
                    }
                }
            }
        });
        if (UiPlugin.isShowAnimations()) {
            this.animation = new ConsoleAnimation(this.display, this.canvas, this.loader, this.gc);
        }
        Label pad = new Label((Composite)this.shell, 0);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        pad.setLayoutData((Object)gridData);
        Label label = new Label((Composite)this.shell, 0);
        label.setText(text);
        this.labelBottomPad = new Label((Composite)this.shell, 0);
        gridData = new GridData();
        gridData.grabExcessVerticalSpace = true;
        this.labelBottomPad.setLayoutData((Object)gridData);
        if (this.isShowCloseButton || this.isShowCancelButton) {
            pad = new Label((Composite)this.shell, 0);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalSpan = 2;
            pad.setLayoutData((Object)gridData);
            this.buttonClose = new Button((Composite)this.shell, 8);
            if (this.isShowCancelButton) {
                this.buttonClose.setText(this.cancelText);
                this.buttonClose.setEnabled(true);
            } else {
                this.buttonClose.setText(this.closeText);
                this.buttonClose.setEnabled(false);
            }
            gridData = new GridData();
            gridData.horizontalAlignment = 3;
            this.buttonClose.setLayoutData((Object)gridData);
            this.buttonClose.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Trace t2 = Trace.getDefault();
                    BusyDialog.this.closeButtonSelected(t2);
                }
            });
        }
        this.shell.layout();
        this.shell.pack();
        UiUtils.makeShellCenteredOnParent(t, this.parent, this.shell);
    }

    public synchronized void closeDialog(final Trace t) {
        if (!this.closed) {
            this.closed = true;
            if (this.openedTime != 0L) {
                Thread thread = new Thread("BusyDialog"){

                    @Override
                    public void run() {
                        Display dis;
                        if (!BusyDialog.this.shell.isDisposed() && !(dis = BusyDialog.this.shell.getDisplay()).isDisposed()) {
                            dis.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (BusyDialog.this.isShowCloseButton) {
                                        if (BusyDialog.this.animation != null) {
                                            BusyDialog.this.animation.stopAtEnd(t);
                                        }
                                        BusyDialog.this.labelBottomPad.setText(BusyDialog.this.completed);
                                        BusyDialog.this.buttonClose.setText(BusyDialog.this.closeText);
                                        BusyDialog.this.shell.layout();
                                        BusyDialog.this.buttonClose.setEnabled(true);
                                    } else {
                                        if (BusyDialog.this.animation != null) {
                                            BusyDialog.this.animation.quit(t);
                                        }
                                        if (BusyDialog.this.shell != null) {
                                            BusyDialog.this.shell.dispose();
                                        }
                                    }
                                }
                            });
                        }
                    }
                };
                thread.start();
                while (!this.shell.isDisposed()) {
                    if (this.display.readAndDispatch()) continue;
                    this.display.sleep();
                }
            } else {
                if (this.animation != null) {
                    this.animation.quit(t);
                }
                if (this.shell != null) {
                    this.shell.dispose();
                }
            }
        }
    }

    public void showDialog(Trace t) {
        if (!this.closed) {
            this.shell.setVisible(false);
            this.display.timerExec(800, new Runnable(){

                @Override
                public void run() {
                    if (!BusyDialog.this.closed) {
                        BusyDialog.this.openDialog(Trace.getDefault());
                    }
                }
            });
            while (!this.shell.isDisposed()) {
                if (this.display.readAndDispatch()) continue;
                this.display.sleep();
            }
        }
    }

    private synchronized void openDialog(Trace t) {
        if (!this.closed) {
            this.openedTime = System.currentTimeMillis();
            this.shell.open();
            if (this.animation != null) {
                this.animation.start();
            }
            this.startTimer();
        }
    }

    private void startTimer() {
        this.display.timerExec(300000, new Runnable(){

            @Override
            public void run() {
                if (!BusyDialog.this.closed) {
                    BusyDialog.this.processTimer();
                }
            }
        });
    }

    private void processTimer() {
        String msg;
        Trace t = Trace.getDefault();
        int rc = MessageBox.showYesNoMessage(t, this.shell, msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4181"), 0, "AMQ4181");
        if (rc == 0) {
            this.startTimer();
        } else {
            msg = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4195");
            rc = MessageBox.showYesNoMessage(t, this.shell, msg, 0, "AMQ4195");
            if (rc == 0) {
                UiPlugin.setAbnormalShutdownPending(true);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        PlatformUI.getWorkbench().restart();
                    }
                });
                this.closeButtonSelected(t);
            } else {
                this.closeButtonSelected(t);
            }
        }
    }

    private void closeButtonSelected(final Trace t) {
        if (!this.shell.isDisposed()) {
            this.shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (BusyDialog.this.animation != null) {
                        BusyDialog.this.animation.quit(t);
                    }
                    if (BusyDialog.this.shell != null) {
                        BusyDialog.this.shell.dispose();
                    }
                }
            });
        }
    }

    public boolean isClosed() {
        return this.closed;
    }
}

