/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.machine;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.commonservices.internal.utils.NativeCalls;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.ContentTitleBar;
import com.ibm.mq.explorer.ui.internal.actions.ViewInstallationsAction;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.content.TextOnlyContentPage;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class WelcomeContentPage
extends TextOnlyContentPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/machine/WelcomeContentPage.java";
    private static final int DESCRIPTION_WIDTH_HINT = 550;
    private Message msgFile = null;

    public WelcomeContentPage(Composite parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Machine");
    }

    @Override
    public void init() {
        final Trace t = Trace.getDefault();
        boolean server = false;
        boolean nonmqm = false;
        int mqInstallType = CommonServices.getMqInstallType();
        if (CommonServices.isMqjbnd() && mqInstallType == 1) {
            server = true;
            if (!NativeCalls.isUserAuthorized((Trace)t)) {
                nonmqm = true;
            }
        }
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        final ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 768);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        Composite bannerComp = new Composite(composite, 0);
        GridData gridData = new GridData(768);
        bannerComp.setLayoutData((Object)gridData);
        this.createBanner(bannerComp);
        Composite compMain = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginTop = 3;
        gridLayout.marginLeft = 3;
        gridLayout.marginBottom = 3;
        gridLayout.marginRight = 3;
        compMain.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        compMain.setLayoutData((Object)gridData);
        ContentTitleBar contentTitleBar = new ContentTitleBar(compMain, 0);
        contentTitleBar.setText(this.msgFile.getMessage(t, "UI.WELCOME.ContentPage.Page.Title"));
        gridData = new GridData(768);
        contentTitleBar.setLayoutData(gridData);
        Text text = new Text(compMain, 66);
        if (server) {
            if (nonmqm) {
                text.setText(this.msgFile.getMessage(t, "UI.WELCOME.ContentPage.Non.Mqm.Description"));
            } else {
                text.setText(this.msgFile.getMessage(t, "UI.WELCOME.ContentPage.Server.Description"));
            }
        } else {
            text.setText(this.msgFile.getMessage(t, "UI.WELCOME.ContentPage.Non.Server.Description"));
        }
        gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 550;
        text.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, text, true);
        HyperlinkGroup linkGroup = new HyperlinkGroup(Display.getCurrent());
        Hyperlink explorerHelplink = new Hyperlink(compMain, 0);
        explorerHelplink.setText(this.msgFile.getMessage(Trace.getDefault(), "UI.WELCOME.ContentPage.Explorer.Help.Button.Text"));
        gridData = new GridData();
        explorerHelplink.setLayoutData((Object)gridData);
        explorerHelplink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                UiPlugin.showBusyCursor(Trace.getDefault(), WelcomeContentPage.this.getShell(), true);
                UiPlugin.getHelpSystem().displayHelpResource("/com.ibm.mq.explorer.doc/help_home_wmq.html");
                UiPlugin.showBusyCursor(Trace.getDefault(), WelcomeContentPage.this.getShell(), false);
            }
        });
        linkGroup.add(explorerHelplink);
        Label label = new Label(compMain, 258);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        contentTitleBar = new ContentTitleBar(compMain, 0);
        contentTitleBar.setText(this.msgFile.getMessage(Trace.getDefault(), "UI.WELCOME.ContentPage.Second.Title"));
        gridData = new GridData(768);
        contentTitleBar.setLayoutData(gridData);
        Composite compSecondSection = new Composite(compMain, 66);
        gridData = new GridData(4, 1, true, false);
        gridData.widthHint = 550;
        compSecondSection.setLayoutData((Object)gridData);
        GridLayout glSecondSection = new GridLayout(4, false);
        glSecondSection.verticalSpacing = 10;
        compSecondSection.setLayout((Layout)glSecondSection);
        int width_hint = 225;
        if (server) {
            Label instIcon = new Label(compSecondSection, 0);
            gridData = new GridData(1, 1, false, false);
            gridData.verticalIndent = 10;
            instIcon.setLayoutData((Object)gridData);
            instIcon.setImage(Icons.get(Icons.iconkeyInst));
            Composite instComp = new Composite(compSecondSection, 0);
            gridData = new GridData(4, 1, true, false);
            gridData.horizontalSpan = 3;
            instComp.setLayoutData((Object)gridData);
            instComp.setLayout((Layout)new GridLayout(1, false));
            text = new Text(instComp, 66);
            text.setText(this.msgFile.getMessage(t, "UI.WELCOME.ContentPage.Installations.Text"));
            gridData = new GridData(4, 0x1000000, true, false);
            gridData.widthHint = width_hint;
            text.setLayoutData((Object)gridData);
            UiUtils.makeTextControlReadOnly(t, text, true);
            Hyperlink instLink = new Hyperlink(instComp, 0);
            instLink.setText(this.msgFile.getMessage(t, "UI.WELCOME.ContentPage.Installations.Link.Text"));
            instLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){
                private ViewInstallationsAction action;

                public void linkActivated(HyperlinkEvent e) {
                    if (this.action == null) {
                        this.action = new ViewInstallationsAction();
                    }
                    this.action.run(null);
                }
            });
            linkGroup.add(instLink);
        }
        Label webIcon = new Label(compSecondSection, 0);
        gridData = new GridData(1, 1, false, false);
        gridData.verticalIndent = 10;
        webIcon.setLayoutData((Object)gridData);
        webIcon.setImage(Icons.get(Icons.iconkeyWeb));
        Composite mqlinkComp = new Composite(compSecondSection, 0);
        gridData = new GridData(4, 1, true, false);
        mqlinkComp.setLayoutData((Object)gridData);
        mqlinkComp.setLayout((Layout)new GridLayout(1, false));
        text = new Text(mqlinkComp, 66);
        text.setText(this.msgFile.getMessage(Trace.getDefault(), "UI.WELCOME.ContentPage.Web.Text"));
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = width_hint;
        text.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, text, true);
        Hyperlink webSphereMQLink = new Hyperlink(mqlinkComp, 0);
        webSphereMQLink.setText(this.msgFile.getMessage(Trace.getDefault(), "UI.WELCOME.ContentPage.Web.Link.Text"));
        webSphereMQLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                URL actualURL = null;
                try {
                    actualURL = new URL("http://www.ibm.com/software/products/en/ibm-mq");
                }
                catch (MalformedURLException malformedURLException) {
                    if (Trace.isTracing) {
                        t.data(66, "WelcomeContentPage.init", 900, "MalformedURLException for http://www.ibm.com/software/products/en/ibm-mq: " + e.getLabel());
                    }
                    String txt = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4548", (String)"http://www.ibm.com/software/products/en/ibm-mq");
                    MessageBox.showMessageFailure(t, UiPlugin.getShell(), txt, "AMQ4548");
                }
                try {
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(136, "com.ibm.mq.explorer.ui", "IBM MQ Web page", "");
                    browser.openURL(actualURL);
                }
                catch (PartInitException err) {
                    if (Trace.isTracing) {
                        t.data(66, "WelcomeContentPage.init", 900, "PartInitException for http://www.ibm.com/software/products/en/ibm-mq: " + err.getMessage());
                    }
                    String txt = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4548", (String)"http://www.ibm.com/software/products/en/ibm-mq");
                    MessageBox.showMessageFailure(t, UiPlugin.getShell(), txt, "AMQ4548");
                }
            }
        });
        linkGroup.add(webSphereMQLink);
        Label infoCenterIcon = new Label(compSecondSection, 0);
        gridData = new GridData(1, 1, false, false);
        gridData.verticalIndent = 10;
        infoCenterIcon.setLayoutData((Object)gridData);
        infoCenterIcon.setImage(Icons.get(Icons.iconkeyInfoCenter));
        Composite infocenterComp = new Composite(compSecondSection, 0);
        gridData = new GridData(4, 1, true, false);
        infocenterComp.setLayoutData((Object)gridData);
        infocenterComp.setLayout((Layout)new GridLayout(1, false));
        Text infoCenterText = new Text(infocenterComp, 66);
        infoCenterText.setText(this.msgFile.getMessage(Trace.getDefault(), "UI.WELCOME.ContentPage.Infocenter.Text"));
        gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = width_hint;
        infoCenterText.setLayoutData((Object)gridData);
        UiUtils.makeTextControlReadOnly(t, infoCenterText, true);
        Hyperlink infoCenterLink = new Hyperlink(infocenterComp, 0);
        infoCenterLink.setText(this.msgFile.getMessage(Trace.getDefault(), "UI.WELCOME.ContentPage.Infocenter.Link.Text"));
        infoCenterLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                URL actualURL = null;
                try {
                    actualURL = new URL("https://www.ibm.com/docs/ibm-mq");
                }
                catch (MalformedURLException malformedURLException) {
                    if (Trace.isTracing) {
                        t.data(66, "WelcomeContentPage.init", 900, "MalformedURLException for https://www.ibm.com/docs/ibm-mq: " + e.getLabel());
                    }
                    String txt = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4548", (String)"https://www.ibm.com/docs/ibm-mq");
                    MessageBox.showMessageFailure(t, UiPlugin.getShell(), txt, "AMQ4548");
                }
                try {
                    IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(136, "com.ibm.mq.explorer.ui", "Info Center Web page", "");
                    browser.openURL(actualURL);
                }
                catch (PartInitException err) {
                    if (Trace.isTracing) {
                        t.data(66, "WelcomeContentPage.init", 900, "PartInitException for https://www.ibm.com/docs/ibm-mq: " + err.getMessage());
                    }
                    String txt = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4548", (String)"https://www.ibm.com/docs/ibm-mq");
                    MessageBox.showMessageFailure(t, UiPlugin.getShell(), txt, "AMQ4548");
                }
            }
        });
        linkGroup.add(infoCenterLink);
        composite.layout();
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        final int minCompWidth = compSecondSection.computeSize((int)-1, (int)-1).x;
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrolledComposite.getClientArea();
                scrolledComposite.setMinSize(scrolledComposite.getContent().computeSize(Math.max(r.width, minCompWidth), -1));
            }
        });
        UiUtils.addScrollListeners(scrolledComposite);
    }

    @Override
    public String getId() {
        return "com.ibm.mq.explorer.contentpage.wmq";
    }

    @Override
    public boolean isCreateBanner() {
        return true;
    }

    @Override
    public String getPageTitle() {
        return null;
    }

    @Override
    public String getPageDescription() {
        return null;
    }

    @Override
    public String getPageButtonText() {
        return null;
    }

    @Override
    public String getIconsTitle() {
        return null;
    }

    @Override
    public String getIconsDescription() {
        return null;
    }

    @Override
    public String[] getIconsText() {
        return null;
    }

    @Override
    public Image[] getIcons() {
        return null;
    }

    @Override
    public String getIconsButtonText() {
        return null;
    }

    @Override
    public String getBottomTitle() {
        return null;
    }

    @Override
    public String getBottomText() {
        return null;
    }

    @Override
    public String getPageButtonHelpTopic() {
        return null;
    }

    @Override
    public String getIconsButtonHelpTopic() {
        return null;
    }

    @Override
    public boolean isEnableSystemObjectsAction() {
        return false;
    }

    @Override
    public void showSystemObjects(boolean show) {
    }

    public void runApp(String appName) {
        Trace t = Trace.getDefault();
        try {
            String dir = QueryValue.queryInstallDir((Trace)t);
            if (Trace.isTracing) {
                t.data(67, "WelcomeContentPage.runApp", 300, "MQ install location = " + dir);
                t.data(67, "WelcomeContentPage.runApp", 300, "Trying to run app: " + appName);
            }
            Runtime runTime = Runtime.getRuntime();
            String execStr = String.valueOf(dir) + File.separator + appName;
            String[] cmdarray = new String[]{execStr};
            try {
                runTime.exec(cmdarray);
            }
            catch (IOException e) {
                String exMessage = e.getMessage();
                if (!exMessage.contains(execStr)) {
                    int truncatePos = execStr.indexOf(" ");
                    int commandPos = exMessage.indexOf(execStr.substring(0, truncatePos));
                    if (exMessage.contains(execStr.substring(0, truncatePos))) {
                        exMessage = String.valueOf(exMessage.substring(0, commandPos)) + execStr + exMessage.substring(commandPos + truncatePos);
                    }
                }
                t.FFST(67, "WelcomeContentPage.runApp", 10, 50044, exMessage);
                String txt = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4570");
                MessageBox.showMessageFailure(t, UiPlugin.getShell(), txt, "AMQ4570");
            }
        }
        catch (CommonServicesException e) {
            t.FFST(67, "WelcomeContentPage.runApp", 20, 50043, e.getMessage());
            String txt = CommonServices.getSystemMessage((Trace)t, (String)"AMQ4570");
            MessageBox.showMessageFailure(t, UiPlugin.getShell(), txt, "AMQ4570");
        }
    }
}

