/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.machine;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DmMachine;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.apiexits.APIExitCustomItemProvider;
import com.ibm.mq.explorer.ui.internal.apiexits.ApiExit;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.machine.MachineSpecialPropertyPage;
import com.ibm.mq.explorer.ui.internal.objects.RepeatingValueObject;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.RepeatingValuesCustomPropertyItem;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.queuemanager.UiQueueManager;
import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class UiMachine
extends UiMQObject {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/machine/UiMachine.java";
    private static final String ID_MAIN_PREFERENCE_PAGE = "com.ibm.mq.explorer.prefmain";
    private UiMQObject uiQmgrs = null;
    private UiMQObject uiQSGs = null;
    private String objectName = "";
    private String objectType = "";
    public static final String UNEXPECTED_ERROR = "AMQ4082";
    private APIExitCustomItemProvider templateAPIExitCustomItemProvider = null;
    private APIExitCustomItemProvider commonAPIExitCustomItemProvider = null;
    private ArrayList<ApiExit> pendingApiExits = null;

    public UiMachine() {
    }

    public UiMachine(Trace t, IDmObject dmMachine, UiMQObject parent) {
        super(t, dmMachine);
        this.pendingApiExits = new ArrayList();
        this.objectName = UiPlugin.getNLSString(t, "KEY_Machine", "UI.MACH.Machine.Title");
        this.objectType = UiPlugin.getNLSString(t, "KEY_Object_Types", "UI.OBJECT.Type.Machine");
        this.templateAPIExitCustomItemProvider = new APIExitCustomItemProvider(t, this, 1);
        this.commonAPIExitCustomItemProvider = new APIExitCustomItemProvider(t, this, 0);
        this.updateIcon();
    }

    @Override
    public String getId() {
        return "com.ibm.mq.explorer.wmq";
    }

    @Override
    public String toString() {
        return this.objectName;
    }

    public void setUiQmgrsObject(UiMQObject uiQmgrs) {
        this.uiQmgrs = uiQmgrs;
    }

    public UiMQObject getUiQmgrsObject() {
        return this.uiQmgrs;
    }

    public void setUiQSGsObject(UiMQObject uiQSGs) {
        this.uiQSGs = uiQSGs;
    }

    public UiMQObject getUiQSGsObject() {
        return this.uiQSGs;
    }

    @Override
    public boolean isCustomGroup(Trace t, UiDisplayGroup uiDisplayGroup) {
        boolean isCustom = false;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 87: {
                isCustom = true;
            }
        }
        return isCustom;
    }

    @Override
    public boolean isCustomItem(Trace t, Attr attr) {
        boolean result = false;
        int attrId = attr.getAttributeID();
        if (this.templateAPIExitCustomItemProvider.isAttributeProcessed(t, attrId) || this.commonAPIExitCustomItemProvider.isAttributeProcessed(t, attrId)) {
            result = true;
        }
        return result;
    }

    @Override
    public CustomPropertyPage createCustomPropertyPage(Trace t, Composite parent, int style, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        MachineSpecialPropertyPage customPage = null;
        switch (uiDisplayGroup.getDisplayGroup().getId()) {
            case 87: {
                if (!this.isCustomGroup(t, uiDisplayGroup)) break;
                customPage = new MachineSpecialPropertyPage(t, parent, style, this, uiDisplayGroup, readonly);
                if (!Trace.isTracing) break;
                t.data(67, "UiMachine.createCustomPropertyPage", "Match found in createCustomPropertyPage for Machine_EXTRA (fake page).");
            }
        }
        return customPage;
    }

    @Override
    public CustomPropertyItem createCustomPropertyItem(Trace t, Composite parent, int style, Attr attr, boolean readonly) {
        RepeatingValuesCustomPropertyItem customPropItem = null;
        int attrId = attr.getAttributeID();
        switch (attrId) {
            case 10525: {
                customPropItem = new RepeatingValuesCustomPropertyItem(t, parent, style, this, attr, readonly, this.templateAPIExitCustomItemProvider);
                break;
            }
            case 10520: {
                customPropItem = new RepeatingValuesCustomPropertyItem(t, parent, style, this, attr, readonly, this.commonAPIExitCustomItemProvider);
            }
        }
        return customPropItem;
    }

    @Override
    public boolean isNotifyChangedOnPropertyPage(Attr attr) {
        return false;
    }

    @Override
    public boolean attrValueChangedOnPropertyPage(Trace t, Attr attr, Object newValue) {
        return false;
    }

    @Override
    public String getObjectType() {
        return this.objectType;
    }

    public ArrayList<RepeatingValueObject> getApiExitsArray(Trace t) {
        ApiExit apiExit;
        ArrayList<RepeatingValueObject> apiExits = new ArrayList<RepeatingValueObject>();
        DmMachine dmMachine = (DmMachine)this.getDmObject();
        int repeatIndex = 0;
        boolean done = false;
        while (!done) {
            apiExit = ApiExit.loadApiExit(t, (DmObject)dmMachine, repeatIndex, 0, 10520, 10537, 10522, 10521, 10524, 10523);
            if (apiExit != null) {
                apiExits.add(apiExit);
                ++repeatIndex;
                continue;
            }
            done = true;
        }
        repeatIndex = 0;
        done = false;
        while (!done) {
            apiExit = ApiExit.loadApiExit(t, (DmObject)dmMachine, repeatIndex, 1, 10525, 10538, 10527, 10526, 10529, 10528);
            if (apiExit != null) {
                apiExits.add(apiExit);
                ++repeatIndex;
                continue;
            }
            done = true;
        }
        UiQueueManager[] uiQMs = UiPlugin.getKnownUiQueueManagers(t, true);
        int i = 0;
        while (i < uiQMs.length) {
            UiQueueManager uiQmgr = uiQMs[i];
            if (uiQmgr.isLocal()) {
                uiQmgr.appendApiExitsToArray(t, apiExits);
            }
            ++i;
        }
        return apiExits;
    }

    @Override
    public String getNLSResourceFileKey() {
        return "KEY_Machine";
    }

    public static UiQueueManager[] getQueueManagers(Trace t, UiQueueManager uiQueueManager) {
        UiQueueManager[] uiQMs = UiPlugin.getKnownUiQueueManagers(t, false);
        ArrayList<UiQueueManager> otherQmgrs = new ArrayList<UiQueueManager>();
        int i = 0;
        while (i < uiQMs.length) {
            if (uiQMs[i].isConnected()) {
                otherQmgrs.add(uiQMs[i]);
            }
            ++i;
        }
        int size = otherQmgrs.size();
        return otherQmgrs.toArray(new UiQueueManager[size]);
    }

    @Override
    public void updateIcon() {
        Image image = Icons.get(Icons.iconkeyExplorerSmall);
        super.setImage(image);
    }

    @Override
    public int getDataModelObjectType(Trace t) {
        return 1001;
    }

    @Override
    public boolean isSupportDelete() {
        return false;
    }

    @Override
    public void deleteMenuAction(Trace t) {
    }

    @Override
    public boolean isChangeProperties(Trace t) {
        return true;
    }

    @Override
    public String getAttributeValue(Trace t, int attrId) {
        return null;
    }

    @Override
    public boolean isAllowProperties() {
        return true;
    }

    @Override
    public boolean isAllowApplyProperties() {
        return true;
    }

    @Override
    public boolean isDefaultDataModeEbcdic(Trace t) {
        return false;
    }

    @Override
    public String getAttributeName(Trace t, int attrId) {
        return null;
    }

    public ArrayList<ApiExit> getPendingApiExits() {
        return this.pendingApiExits;
    }

    @Override
    public String getCharacterSetIdForByteArray(Trace t, int attrId) {
        return null;
    }

    public void showPreferenceDialog(Trace t) {
        PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)UiPlugin.getShell(), (String)ID_MAIN_PREFERENCE_PAGE, null, (Object)"");
        ArrayList<String> childIds = new ArrayList<String>();
        TreeViewer treeViewer = prefDialog.getTreeViewer();
        ISelection selection = treeViewer.getSelection();
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            Object object = treeSelection.getFirstElement();
            if (object instanceof PreferenceNode) {
                PreferenceNode node = (PreferenceNode)object;
                this.addChildIdsToArrayList(node, childIds);
            }
            if (childIds.size() > 0) {
                prefDialog.close();
                prefDialog = PreferencesUtil.createPreferenceDialogOn((Shell)UiPlugin.getShell(), (String)ID_MAIN_PREFERENCE_PAGE, (String[])childIds.toArray(new String[childIds.size()]), (Object)"");
                treeViewer = prefDialog.getTreeViewer();
                treeViewer.expandAll();
            }
        }
        prefDialog.open();
    }

    private void addChildIdsToArrayList(PreferenceNode node, ArrayList<String> ids) {
        IPreferenceNode[] children = node.getSubNodes();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof PreferenceNode) {
                    ids.add(children[i].getId());
                    this.addChildIdsToArrayList((PreferenceNode)children[i], ids);
                }
                ++i;
            }
        }
    }
}

