/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.machine;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.extensions.IExplorerExternalDragDrop;
import com.ibm.mq.explorer.ui.extensions.IExplorerImportManager;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.extensions.TreeNode;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;

public class MachineTreeNode
extends TreeNode
implements IExplorerExternalDragDrop {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/machine/MachineTreeNode.java";
    private String nodeName = "";

    public MachineTreeNode(TreeNode parent, MQExtObject object) {
        super(parent, object, "com.ibm.mq.explorer.ui");
        Trace t = Trace.getDefault();
        this.nodeName = UiPlugin.getNLSString(t, "KEY_Machine", "UI.MACH.Machine.Title");
    }

    @Override
    public String toString() {
        return this.nodeName;
    }

    @Override
    public String getId() {
        return "com.ibm.mq.explorer.treenode.wmq";
    }

    @Override
    public String getSequence() {
        return "100";
    }

    @Override
    public String getContentPageId() {
        return "com.ibm.mq.explorer.contentpage.wmq";
    }

    @Override
    public Image getIcon() {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public int compare(TreeNode child1, TreeNode child2) {
        return TreeNode.compareBySequence(child1, child2);
    }

    @Override
    public boolean isContextMenuFromUiObject() {
        return true;
    }

    @Override
    public boolean isAddChildrenWhenExpanded() {
        return false;
    }

    @Override
    public String getHelpId() {
        return "com.ibm.mq.explorer.ui.infopop.UI_MachineTreeNode";
    }

    @Override
    public boolean dropAction(Object droppedObject, int action) {
        Trace t = Trace.getDefault();
        boolean result = false;
        if (droppedObject != null && droppedObject instanceof String[]) {
            result = true;
            String[] filenames = (String[])droppedObject;
            int i = 0;
            while (i < filenames.length) {
                IExplorerImportManager im = ImportExportUtils.getImportManagerById(t, "com.ibm.mq.explorer.importexport.internal.ImportManager");
                if (im != null) {
                    im.setImportSource(t, (IPath)new Path(filenames[i]));
                    im.importAll(t);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    public int getAcceptedOperations(TransferData dataType) {
        int operations = 0;
        if (FileTransfer.getInstance().isSupportedType(dataType)) {
            operations = 1;
        }
        return operations;
    }

    @Override
    public TransferData getPreferredTransferData(TransferData[] dataTypes) {
        int i = 0;
        while (i < dataTypes.length) {
            if (FileTransfer.getInstance().isSupportedType(dataTypes[i])) {
                return dataTypes[i];
            }
            ++i;
        }
        return null;
    }
}

