/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.machine;

import com.ibm.mq.commonservices.CommonServicesException;
import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.QueryValue;
import com.ibm.mq.explorer.core.internal.attrs.Attr;
import com.ibm.mq.explorer.core.internal.objects.DisplayGroup;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.properties.CustomPropertyPage;
import com.ibm.mq.explorer.ui.internal.properties.PropertyControl;
import com.ibm.mq.explorer.ui.internal.properties.UiAttr;
import com.ibm.mq.explorer.ui.internal.properties.UiDisplayGroup;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MachineSpecialPropertyPage
extends CustomPropertyPage {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/machine/MachineSpecialPropertyPage.java";
    private static final int NUMCOLUMNS_WITH_PAD = 4;
    private UiMQObject uiMQObject = null;
    private IDmObject dmObject = null;
    private Attr attr = null;
    private ArrayList<UiAttr> uiAttrs = new ArrayList();
    private static final String PSEUDO_EMPTY_STRING = " ";
    private DisplayGroup displayGroup = null;
    private static final int[] HANDLEDATTRIDS = new int[]{10539};
    private static final int WIDTH_HINT = 280;

    public MachineSpecialPropertyPage(Trace t, Composite parent, int style, UiMQObject uiMQObject_, UiDisplayGroup uiDisplayGroup, boolean readonly) {
        super(t, parent, style, uiMQObject_, uiDisplayGroup, readonly);
        this.uiMQObject = uiMQObject_;
        this.displayGroup = uiDisplayGroup.getDisplayGroup();
    }

    @Override
    public void init(Trace t) {
        String mqVer;
        String cmvc;
        String buildType;
        String jbnd;
        String installType;
        String buildTypeLabel;
        String cmvcLabel;
        String mqVerLabel;
        String jbndLabel;
        String installTypeLabel;
        block14: {
            this.dmObject = this.uiMQObject.getDmObject();
            this.uiAttrs = this.getValidHandledAttrs(t);
            PropertyControl.sortAttributesBySequenceNumber(t, this.uiAttrs);
            String file = this.uiMQObject.getNLSResourceFileKey();
            installTypeLabel = UiPlugin.getNLSString(t, file, "UI.MACH.Config.PropertyPage.installTypeLabel");
            jbndLabel = UiPlugin.getNLSString(t, file, "UI.MACH.Config.PropertyPage.jbndLabel");
            mqVerLabel = UiPlugin.getNLSString(t, file, "UI.MACH.Config.PropertyPage.mqVerLabel");
            cmvcLabel = UiPlugin.getNLSString(t, file, "UI.MACH.Config.PropertyPage.cmvcLabel");
            buildTypeLabel = UiPlugin.getNLSString(t, file, "UI.MACH.Config.PropertyPage.buildTypeLabel");
            installType = "";
            jbnd = "";
            buildType = "";
            cmvc = "";
            mqVer = "";
            switch (CommonServices.getMqInstallType()) {
                case 1: {
                    installType = UiPlugin.getNLSString(t, file, "UI.MACH.Config.PropertyPage.ServerInstall");
                    break;
                }
                case 2: {
                    installType = UiPlugin.getNLSString(t, file, "UI.MACH.Config.PropertyPage.ClientInstall");
                    break;
                }
                case 3: {
                    installType = UiPlugin.getNLSString(t, file, "UI.MACH.Config.PropertyPage.JavaInstall");
                }
            }
            jbnd = CommonServices.isMqjbnd() ? UiPlugin.getNLSString(t, file, "UI.GENERAL.YES") : UiPlugin.getNLSString(t, file, "UI.GENERAL.NO");
            if (CommonServices.isMqjbnd()) {
                block13: {
                    block12: {
                        try {
                            buildType = QueryValue.queryBuildType((Trace)t);
                        }
                        catch (CommonServicesException commonServicesException) {
                            if (!Trace.isTracing) break block12;
                            t.data(67, "MachineSpecialPropertyPage.init", 900, "Failed to get build type from QueryValue");
                        }
                    }
                    try {
                        mqVer = QueryValue.queryVersionAsString((Trace)t);
                    }
                    catch (CommonServicesException commonServicesException) {
                        if (!Trace.isTracing) break block13;
                        t.data(67, "MachineSpecialPropertyPage.init", 900, "Failed to get versionAsString from QueryValue");
                    }
                }
                try {
                    cmvc = QueryValue.queryCMVCLevel((Trace)t);
                }
                catch (CommonServicesException commonServicesException) {
                    if (!Trace.isTracing) break block14;
                    t.data(67, "MachineSpecialPropertyPage.init", 900, "Failed to get cmvc level from QueryValue");
                }
            }
        }
        int numColumns = 3;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = numColumns;
        gridLayout.verticalSpacing = 10;
        this.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = numColumns;
        this.setLayoutData(gridData);
        Label label = new Label((Composite)this, 0);
        label.setText(installTypeLabel);
        Text text = new Text((Composite)this, 2048);
        text.setText(installType);
        UiUtils.makeTextControlReadOnly(t, text, true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = numColumns - 1;
        gridData.widthHint = 280;
        text.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        label.setText(jbndLabel);
        text = new Text((Composite)this, 2048);
        text.setText(jbnd);
        UiUtils.makeTextControlReadOnly(t, text, true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = numColumns - 1;
        text.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        label.setText(mqVerLabel);
        text = new Text((Composite)this, 2048);
        text.setText(mqVer);
        UiUtils.makeTextControlReadOnly(t, text, true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = numColumns - 1;
        text.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        label.setText(cmvcLabel);
        text = new Text((Composite)this, 2048);
        text.setText(cmvc);
        UiUtils.makeTextControlReadOnly(t, text, true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = numColumns - 1;
        text.setLayoutData((Object)gridData);
        label = new Label((Composite)this, 0);
        label.setText(buildTypeLabel);
        text = new Text((Composite)this, 2048);
        text.setText(buildType);
        UiUtils.makeTextControlReadOnly(t, text, true);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = numColumns - 1;
        text.setLayoutData((Object)gridData);
        super.addUnexpectedAttributes(t, this, HANDLEDATTRIDS);
    }

    private ArrayList<UiAttr> getValidHandledAttrs(Trace t) {
        ArrayList<UiAttr> list = new ArrayList<UiAttr>();
        int[] validAttrs = this.dmObject.getAllAttributes(t);
        int i = 0;
        while (i < HANDLEDATTRIDS.length) {
            int j = 0;
            while (j < validAttrs.length) {
                if (HANDLEDATTRIDS[i] == validAttrs[j]) {
                    this.attr = this.dmObject.getAttribute(t, HANDLEDATTRIDS[i], 0);
                    UiAttr uiAttr = new UiAttr(t, this.attr, this.displayGroup);
                    list.add(uiAttr);
                    if (!Trace.isTracing) break;
                    t.data(67, "MachineSpecialPropertyPage.getValidHandledAttrs", 300, "QueueManager General Property Panel to display attribute with id: " + this.attr.getAttributeID());
                    break;
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    @Override
    public void restoreDefaults(Trace t) {
    }

    @Override
    public boolean apply(Trace t, Object job) {
        boolean result = false;
        int i = 0;
        while (i < this.uiAttrs.size()) {
            Object currentValue;
            UiAttr uiAttr = this.uiAttrs.get(i);
            if (uiAttr == null) {
                t.FFST(67, "MachineSpecialPropertyPage.apply", 10, 50006, 0, 0, "Null value detected for uiAttr, unable to update data model value.", "", "");
                if (Trace.isTracing) {
                    t.data(67, "MachineSpecialPropertyPage.apply", 900, "Null value detected for uiAttr, unable to update data model value.");
                }
            } else if (uiAttr.getAttr().getAttributeID() == 2014 && uiAttr.getAttributeControl().isChanged(t)) {
                currentValue = uiAttr.getAttributeControl().getValue(t).toString();
                if (currentValue == null || ((String)currentValue).trim().compareTo("") == 0) {
                    currentValue = PSEUDO_EMPTY_STRING;
                }
                result = this.dmObject.setAttributeValue(t, job, 2014, 0, currentValue);
                if (Trace.isTracing) {
                    t.data(67, "MachineSpecialPropertyPage.apply", 300, "CMQC.MQCA_Q_MGR_DESC attribute value set to: " + (String)currentValue);
                }
            } else if (uiAttr.getAttr().getAttributeID() == 10146 && uiAttr.getAttributeControl().isChanged(t)) {
                currentValue = uiAttr.getAttributeControl().getValue(t);
                result = this.dmObject.setAttributeValue(t, job, 10146, 0, currentValue);
                if (Trace.isTracing) {
                    t.data(67, "MachineSpecialPropertyPage.apply", 300, "PseudoPCF.PARAM_INSTANCEDATA_STARTUP attribute value set to: " + currentValue);
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    public boolean isAnyControlEnabled(Trace t) {
        return false;
    }

    @Override
    public void changesApplied(Trace t) {
    }
}

