/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.importexport;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.IExplorerImportManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ImportExportUtils {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/importexport/ImportExportUtils.java";
    public static final String EXPLORER_IMPORT_MANAGER_ID = "com.ibm.mq.explorer.importexport.internal.ImportManager";
    private static final String importManagerExtensionPoint = "internal_addImportManager";
    private static Map<String, IExplorerImportManager> importManagers = new HashMap<String, IExplorerImportManager>();
    private static boolean loadedExtensionPt = false;

    private static synchronized void loadImportManagers(Trace t) {
        if (!loadedExtensionPt) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", importManagerExtensionPoint);
            if (extensionPoint != null) {
                ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "    label = " + extensionPoint.getLabel());
                ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "    schemaReference = " + extensionPoint.getSchemaReference());
                ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
                ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
                IExtension[] extensionArray = extensionPoint.getExtensions();
                ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "    Number of Extensions = " + extensionArray.length);
                int i = 0;
                while (i < extensionArray.length) {
                    IExtension extension = extensionArray[i];
                    ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "        label = " + extension.getLabel());
                    ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                    ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                    IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                    ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "        Number of Import Manager ConfigurationElements = " + configArray2.length);
                    int j = 0;
                    while (j < configArray2.length) {
                        IConfigurationElement element = configArray2[j];
                        String plugin_id = element.getDeclaringExtension().getNamespaceIdentifier();
                        ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "            element.name  = " + element.getName());
                        ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "            element.value = " + element.getValue());
                        ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "            pluginId = " + plugin_id);
                        String importManagerId = element.getAttribute("importManagerId");
                        ImportExportUtils.trace(t, "ImportExportUtils.loadImportManagers", "            importManagerId = " + importManagerId);
                        String className = null;
                        String extensionValue = element.getAttribute("class");
                        int indexOfForwardSlash = extensionValue.indexOf("/");
                        className = indexOfForwardSlash == -1 ? extensionValue : extensionValue.substring(indexOfForwardSlash + 1, extensionValue.length());
                        try {
                            Bundle classBundle = Platform.getBundle((String)plugin_id);
                            if (classBundle != null) {
                                IExplorerImportManager impexp = (IExplorerImportManager)classBundle.loadClass(className).newInstance();
                                if (impexp != null) {
                                    ImportExportUtils.addImportManager(t, plugin_id, importManagerId, impexp);
                                } else {
                                    if (Trace.isTracing) {
                                        t.data(67, "ImportExportUtils.loadImportManagers", 900, "Unable to load the class '" + className + "' for pluginId '" + plugin_id + "'");
                                    }
                                    t.FFST(67, "ImportExportUtils.loadImportManagers", 110, 50999, 0, 0, "Unable to load class specified in internal_addImportManager extension point", "pluginId = '" + plugin_id + "'", "class = '" + className + "'");
                                }
                            } else {
                                if (Trace.isTracing) {
                                    t.data(67, "ImportExportUtils.loadImportManagers", 900, "Unable to get the bundle for plug-in id 'internal_addImportManager'");
                                }
                                t.FFST(67, "ImportExportUtils.loadImportManagers", 120, 50999, 0, 0, "Invalid plugin_id specified in internal_addImportManager extension point", "pluginId = '" + plugin_id + "'", "");
                            }
                        }
                        catch (NullPointerException e) {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportUtils.loadImportManagers", 900, "NullPointerException trying to load extension:");
                                t.data(67, "ImportExportUtils.loadImportManagers", 900, e.getLocalizedMessage());
                            }
                            t.FFST(67, "ImportExportUtils.loadImportManagers", 130, 50999, 0, 0, "NullPointerException loading internal_addImportManager extension point", "pluginId = '" + plugin_id + "'", "");
                        }
                        catch (InstantiationException e) {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportUtils.loadImportManagers", 900, "InstantiationException trying to load extension:");
                                t.data(67, "ImportExportUtils.loadImportManagers", 900, e.getLocalizedMessage());
                            }
                            t.FFST(67, "ImportExportUtils.loadImportManagers", 140, 50999, 0, 0, "InstantiationException loading internal_addImportManager extension point", "pluginId = '" + plugin_id + "'", "");
                        }
                        catch (IllegalAccessException e) {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportUtils.loadImportManagers", 900, "IllegalAccessException trying to load extension:");
                                t.data(67, "ImportExportUtils.loadImportManagers", 900, e.getLocalizedMessage());
                            }
                            t.FFST(67, "ImportExportUtils.loadImportManagers", 150, 50999, 0, 0, "IllegalAccessException loading internal_addImportManager extension point", "pluginId = '" + plugin_id + "'", "");
                        }
                        catch (ClassNotFoundException e) {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportUtils.loadImportManagers", 900, "ClassNotFoundException trying to load extension:");
                                t.data(67, "ImportExportUtils.loadImportManagers", 900, e.getLocalizedMessage());
                            }
                            t.FFST(67, "ImportExportUtils.loadImportManagers", 160, 50999, 0, 0, "ClassNotFoundException loading internal_addImportManager extension point", "pluginId = '" + plugin_id + "'", "class = '" + className + "'");
                        }
                        catch (Throwable e) {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportUtils.loadImportManagers", 900, "Throwable trying to load extension:");
                                t.data(67, "ImportExportUtils.loadImportManagers", 900, e.getLocalizedMessage());
                            }
                            t.FFST(67, "ImportExportUtils.loadImportManagers", 170, 50999, 0, 0, "Throwable loading internal_addImportManager extension point", "pluginId = '" + plugin_id + "'", "");
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            loadedExtensionPt = true;
        }
    }

    private static void addImportManager(Trace t, String plugin_id, String importManagerId, IExplorerImportManager impexp) {
        if (!importManagers.containsKey(importManagerId)) {
            importManagers.put(importManagerId, impexp);
        } else {
            t.FFST(67, "ImportExportUtils.addImportManager", 180, 50999, 0, 0, "Unable to add import manager, duplicate importManagerId", "pluginId = '" + plugin_id + "'", "importManagerId = '" + importManagerId + "'");
        }
    }

    public static IExplorerImportManager getImportManagerById(Trace t, String importManagerId) {
        if (!loadedExtensionPt) {
            ImportExportUtils.loadImportManagers(t);
        }
        IExplorerImportManager importManager = null;
        if (importManagers.containsKey(importManagerId)) {
            importManager = importManagers.get(importManagerId);
        }
        return importManager;
    }

    public static Map<String, IExplorerImportManager> getAllImportManagers(Trace t) {
        if (!loadedExtensionPt) {
            ImportExportUtils.loadImportManagers(t);
        }
        HashMap<String, IExplorerImportManager> toReturn = new HashMap<String, IExplorerImportManager>();
        for (String key : importManagers.keySet()) {
            toReturn.put(key, importManagers.get(key));
        }
        return toReturn;
    }

    private static void trace(Trace t, String fid, String msg) {
        t.data(67, fid, 300, msg);
    }
}

