/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.importexport;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.IExplorerAbstractImportExport;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportCategory;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportSubcategory;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ImportExportCategoryManager {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/importexport/ImportExportCategoryManager.java";
    private Hashtable<String, ImportExportCategory> categories = new Hashtable();

    public ImportExportCategoryManager(Trace t) {
    }

    public void loadImportExportCategories(Trace t) {
        this.loadCategoryExtensionPoint(t, "addImportExportCategory");
        this.loadCategoryExtensionPoint(t, "addRuntimeImportExportCategory");
        this.loadSubcategoryExtensionPoint(t, "addImportExportSubcategory");
        this.loadSubcategoryExtensionPoint(t, "addRuntimeImportExportSubcategory");
        this.removeEmptyCategories(t);
    }

    private void removeEmptyCategories(Trace t) {
        Enumeration<String> catIds = this.categories.keys();
        ArrayList<String> removeCatIds = new ArrayList<String>();
        while (catIds.hasMoreElements()) {
            String catId = catIds.nextElement();
            ImportExportCategory cat = this.categories.get(catId);
            if (cat.getSubcategories(t).size() != 0) continue;
            removeCatIds.add(catId);
        }
        int i = 0;
        while (i < removeCatIds.size()) {
            String catId = (String)removeCatIds.get(i);
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.removeEmptyCategories", "removing empty category, id=" + catId);
            this.categories.remove(catId);
            ++i;
        }
    }

    public ImportExportCategory[] getImportExportCategories(Trace t) {
        ImportExportCategory[] cats = new ImportExportCategory[this.categories.size()];
        Enumeration<String> catIds = this.categories.keys();
        int index = 0;
        while (catIds.hasMoreElements()) {
            String catId = catIds.nextElement();
            ImportExportCategory cat = this.categories.get(catId);
            cats[index++] = cat;
        }
        return cats;
    }

    private void loadCategoryExtensionPoint(Trace t, String extensionPointName) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", extensionPointName);
        if (extensionPoint != null) {
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "    label = " + extensionPoint.getLabel());
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "    schemaReference = " + extensionPoint.getSchemaReference());
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            IExtension[] extensionArray = extensionPoint.getExtensions();
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "    Number of Extensions = " + extensionArray.length);
            int i = 0;
            while (i < extensionArray.length) {
                IExtension extension = extensionArray[i];
                ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "        label = " + extension.getLabel());
                ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "        Number of Category ConfigurationElements = " + configArray2.length);
                int j = 0;
                while (j < configArray2.length) {
                    IConfigurationElement catElement = configArray2[j];
                    String plugin_id = catElement.getDeclaringExtension().getNamespaceIdentifier();
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "            element.name  = " + catElement.getName());
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "            element.value = " + catElement.getValue());
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "            pluginId = " + plugin_id);
                    String categoryName = catElement.getAttribute("categoryName");
                    String categoryId = catElement.getAttribute("categoryId");
                    String sequence = catElement.getAttribute("sequence");
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "            categoryName = " + categoryName);
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "            categoryId = " + categoryId);
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "            sequence = " + sequence);
                    this.addCategory(t, plugin_id, categoryId, categoryName, sequence);
                    IConfigurationElement[] configArray3 = catElement.getChildren();
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "            Number of Subcategory ConfigurationElements = " + configArray3.length);
                    int k = 0;
                    while (k < configArray3.length) {
                        IConfigurationElement subElement = configArray3[k];
                        ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "                element.name  = " + subElement.getName());
                        ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "                element.value = " + subElement.getValue());
                        String subcategoryName = subElement.getAttribute("subcategoryName");
                        String subcategoryId = subElement.getAttribute("subcategoryId");
                        String subsequence = subElement.getAttribute("sequence");
                        String subhide = subElement.getAttribute("hide");
                        ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "                subcategoryName = " + subcategoryName);
                        ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "                subcategoryId = " + subcategoryId);
                        ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "                subsequence = " + subsequence);
                        ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "                subhide = " + subhide);
                        String className = null;
                        String extensionValue = subElement.getAttribute("class");
                        int indexOfForwardSlash = extensionValue.indexOf("/");
                        className = indexOfForwardSlash == -1 ? extensionValue : extensionValue.substring(indexOfForwardSlash + 1, extensionValue.length());
                        try {
                            Bundle classBundle = Platform.getBundle((String)plugin_id);
                            if (classBundle != null) {
                                IExplorerAbstractImportExport impexp = (IExplorerAbstractImportExport)classBundle.loadClass(className).newInstance();
                                if (impexp != null) {
                                    this.addSubcategory(t, plugin_id, categoryId, subcategoryId, subcategoryName, subsequence, impexp, Boolean.valueOf(subhide));
                                } else {
                                    if (Trace.isTracing) {
                                        t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, "Unable to load the class '" + className + "' for pluginId '" + plugin_id + "'");
                                    }
                                    t.FFST(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 10, 50999, 0, 0, "Unable to load class specified in " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "class = '" + className + "'");
                                }
                            } else {
                                if (Trace.isTracing) {
                                    t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, "Unable to get the bundle for plug-in id '" + plugin_id + "'");
                                }
                                t.FFST(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 20, 50999, 0, 0, "Invalid plugin_id specified in " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "");
                            }
                        }
                        catch (NullPointerException e) {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, "NullPointerException trying to load extension:");
                                t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, e.getLocalizedMessage());
                            }
                            t.FFST(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 30, 50999, 0, 0, "NullPointerException loading " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "");
                        }
                        catch (InstantiationException e) {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, "InstantiationException trying to load extension:");
                                t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, e.getLocalizedMessage());
                            }
                            t.FFST(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 40, 50999, 0, 0, "InstantiationException loading " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "");
                        }
                        catch (IllegalAccessException e) {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, "IllegalAccessException trying to load extension:");
                                t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, e.getLocalizedMessage());
                            }
                            t.FFST(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 50, 50999, 0, 0, "IllegalAccessException loading " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "");
                        }
                        catch (ClassNotFoundException e) {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, "ClassNotFoundException trying to load extension:");
                                t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, e.getLocalizedMessage());
                            }
                            t.FFST(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 60, 50999, 0, 0, "ClassNotFoundException loading " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "class = '" + className + "'");
                        }
                        catch (Throwable e) {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, "Throwable trying to load extension:");
                                t.data(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 900, e.getLocalizedMessage());
                            }
                            t.FFST(67, "ImportExportCategoryManager.loadCategoryExtensionPoint", 70, 50999, 0, 0, "Throwable loading " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "");
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "");
        ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadCategoryExtensionPoint", "");
    }

    private void addCategory(Trace t, String plugin_id, String categoryId, String categoryName, String sequence) {
        if (!this.categories.containsKey(categoryId)) {
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.addCategory", "adding category, Id='" + categoryId + "', Name = '" + categoryName + "'");
            ImportExportCategory cat = new ImportExportCategory(t, plugin_id, categoryId, categoryName, sequence);
            this.categories.put(categoryId, cat);
        } else {
            t.FFST(67, "ImportExportCategoryManager.addCategory", 80, 50999, 0, 0, "Unable to add category, duplicate categoryId", "pluginId = '" + plugin_id + "'", "categoryId = '" + categoryId + "'");
        }
    }

    private void loadSubcategoryExtensionPoint(Trace t, String extensionPointName) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.mq.explorer.ui", extensionPointName);
        if (extensionPoint != null) {
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "    label = " + extensionPoint.getLabel());
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "    schemaReference = " + extensionPoint.getSchemaReference());
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "    simpleIdentifier = " + extensionPoint.getSimpleIdentifier());
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "    uniqueIdentifier = " + extensionPoint.getUniqueIdentifier());
            IExtension[] extensionArray = extensionPoint.getExtensions();
            ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "    Number of Extensions = " + extensionArray.length);
            int i = 0;
            while (i < extensionArray.length) {
                IExtension extension = extensionArray[i];
                ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "        label = " + extension.getLabel());
                ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "        simpleIdentifier = " + extension.getSimpleIdentifier());
                ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "        uniqueIdentifier = " + extension.getUniqueIdentifier());
                IConfigurationElement[] configArray2 = extension.getConfigurationElements();
                ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "        Number of Subcategory ConfigurationElements = " + configArray2.length);
                int j = 0;
                while (j < configArray2.length) {
                    IConfigurationElement element = configArray2[j];
                    String plugin_id = element.getDeclaringExtension().getNamespaceIdentifier();
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "            element.name  = " + element.getName());
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "            element.value = " + element.getValue());
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "            pluginId = " + plugin_id);
                    String categoryId = element.getAttribute("categoryId");
                    String subcategoryName = element.getAttribute("subcategoryName");
                    String subcategoryId = element.getAttribute("subcategoryId");
                    String sequence = element.getAttribute("sequence");
                    String subhide = element.getAttribute("hide");
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "            categoryId = " + categoryId);
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "            subcategoryName = " + subcategoryName);
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "            subcategoryId = " + subcategoryId);
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "            sequence = " + sequence);
                    ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "            subhide = " + subhide);
                    String className = null;
                    String extensionValue = element.getAttribute("class");
                    int indexOfForwardSlash = extensionValue.indexOf("/");
                    className = indexOfForwardSlash == -1 ? extensionValue : extensionValue.substring(indexOfForwardSlash + 1, extensionValue.length());
                    try {
                        Bundle classBundle = Platform.getBundle((String)plugin_id);
                        if (classBundle != null) {
                            IExplorerAbstractImportExport impexp = (IExplorerAbstractImportExport)classBundle.loadClass(className).newInstance();
                            if (impexp != null) {
                                this.addSubcategory(t, plugin_id, categoryId, subcategoryId, subcategoryName, sequence, impexp, Boolean.valueOf(subhide));
                            } else {
                                if (Trace.isTracing) {
                                    t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, "Unable to load the class '" + className + "' for pluginId '" + plugin_id + "'");
                                }
                                t.FFST(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 110, 50999, 0, 0, "Unable to load class specified in " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "class = '" + className + "'");
                            }
                        } else {
                            if (Trace.isTracing) {
                                t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, "Unable to get the bundle for plug-in id '" + plugin_id + "'");
                            }
                            t.FFST(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 120, 50999, 0, 0, "Invalid plugin_id specified in " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "");
                        }
                    }
                    catch (NullPointerException e) {
                        if (Trace.isTracing) {
                            t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, "NullPointerException trying to load extension:");
                            t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, e.getLocalizedMessage());
                        }
                        t.FFST(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 130, 50999, 0, 0, "NullPointerException loading " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "");
                    }
                    catch (InstantiationException e) {
                        if (Trace.isTracing) {
                            t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, "InstantiationException trying to load extension:");
                            t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, e.getLocalizedMessage());
                        }
                        t.FFST(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 140, 50999, 0, 0, "InstantiationException loading " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "");
                    }
                    catch (IllegalAccessException e) {
                        if (Trace.isTracing) {
                            t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, "IllegalAccessException trying to load extension:");
                            t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, e.getLocalizedMessage());
                        }
                        t.FFST(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 150, 50999, 0, 0, "IllegalAccessException loading " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "");
                    }
                    catch (ClassNotFoundException e) {
                        if (Trace.isTracing) {
                            t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, "ClassNotFoundException trying to load extension:");
                            t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, e.getLocalizedMessage());
                        }
                        t.FFST(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 160, 50999, 0, 0, "ClassNotFoundException loading " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "class = '" + className + "'");
                    }
                    catch (Throwable e) {
                        if (Trace.isTracing) {
                            t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, "Throwable trying to load extension:");
                            t.data(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 900, e.getLocalizedMessage());
                        }
                        t.FFST(67, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", 170, 50999, 0, 0, "Throwable loading " + extensionPointName + " extension point", "pluginId = '" + plugin_id + "'", "");
                    }
                    ++j;
                }
                ++i;
            }
        }
        ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "");
        ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.loadSubcategoryExtensionPoint", "");
    }

    private void addSubcategory(Trace t, String plugin_id, String categoryId, String subcategoryId, String subcategoryName, String sequence, IExplorerAbstractImportExport impexp, boolean hide) {
        ImportExportCategory cat = this.categories.get(categoryId);
        if (cat != null) {
            if (!cat.isSubcategoryIdInUse(t, subcategoryId)) {
                ImportExportCategoryManager.trace(t, "ImportExportCategoryManager.addSubcategory", "adding subcategory, catId='" + categoryId + "', subcatId = '" + subcategoryId + "', subcatName = '" + subcategoryName + "'");
                ImportExportSubcategory subcat = new ImportExportSubcategory(t, plugin_id, categoryId, subcategoryId, subcategoryName, sequence, impexp, hide);
                subcat.setParent(cat);
                cat.addSubcategory(t, subcat);
            } else {
                t.FFST(67, "ImportExportCategoryManager.addSubcategory", 180, 50999, 0, 0, "Unable to add subcategory, duplicate subcategoryId", "pluginId = '" + plugin_id + "'", "subcategoryId = '" + subcategoryId + "'");
            }
        } else {
            t.FFST(67, "ImportExportCategoryManager.addSubcategory", 190, 50999, 0, 0, "Unable to add subcategory, unknown categoryId", "pluginId = '" + plugin_id + "'", "categoryId = '" + categoryId + "'");
        }
    }

    private static void trace(Trace t, String fid, String msg) {
        if (Trace.isTracing) {
            t.data(67, fid, 300, msg);
        }
    }
}

