/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.importexport;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.internal.importexport.ImportExportSubcategory;
import java.util.ArrayList;

public class ImportExportCategory {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/importexport/ImportExportCategory.java";
    private String pluginId = null;
    private String categoryId = null;
    private String categoryName = null;
    private String sequence = null;
    private ArrayList<ImportExportSubcategory> subcategories = null;
    private Object parent = null;

    public ImportExportCategory(Trace t, String plugId, String catId, String catName, String seq) {
        this.pluginId = plugId;
        this.categoryId = catId;
        this.categoryName = catName;
        this.sequence = seq;
        this.subcategories = new ArrayList();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void addSubcategory(Trace t, ImportExportSubcategory sub) {
        if (!this.subcategories.contains(sub)) {
            int index = this.subcategories.size();
            try {
                int newSeq = Integer.parseInt(sub.getSequence());
                int i = 0;
                while (i < this.subcategories.size()) {
                    int curSeqInt = Integer.parseInt(this.subcategories.get(i).getSequence());
                    if (newSeq < curSeqInt) {
                        index = i;
                        break;
                    }
                    ++i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                t.data(67, "ImportExportCategory.addSubcategory", 900, "Sequence not a valid integer in Subcategory: " + sub.getCategoryId());
            }
            this.subcategories.add(index, sub);
        }
    }

    public boolean removeSubcategory(Trace t, ImportExportSubcategory sub) {
        boolean result = false;
        if (this.subcategories.contains(sub)) {
            this.subcategories.remove(sub);
            result = true;
        }
        return result;
    }

    public ArrayList<ImportExportSubcategory> getSubcategories(Trace t) {
        return this.subcategories;
    }

    public boolean isSubcategoryIdInUse(Trace t, String subcatId) {
        boolean result = false;
        int i = 0;
        while (i < this.subcategories.size()) {
            ImportExportSubcategory subcat = this.subcategories.get(i);
            if (subcat.getSubcategoryId().compareTo(subcatId) == 0) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        return this.categoryName;
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object prnt) {
        this.parent = prnt;
    }

    public Object[] getChildren() {
        Object[] children = this.subcategories.toArray(new ImportExportSubcategory[this.subcategories.size()]);
        return children;
    }
}

