/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.importexport;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.ui.extensions.IExplorerRuntimeImportExport;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.importexport.ExplorerImportExportPrefsGeneral;
import com.ibm.mq.explorer.ui.internal.plugins.PluginRegistrationManager;
import com.ibm.mq.explorer.ui.internal.plugins.RegisteredPlugin;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class ExplorerImportExportPrefsPlugins
implements IExplorerRuntimeImportExport,
IExecutableExtension {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/importexport/ExplorerImportExportPrefsPlugins.java";
    private static final String PLUGINS_NODE = "PluginRegistrations";
    private static final String APLUGIN_NODE_PREFIX = "Plugin_";
    private static final String PLUGINS_COUNT_KEY = "Count";
    private static final String PLUGIN_ID_KEY = "PluginId";
    private static final String PLUGIN_ENABLED_KEY = "Enabled";
    private IPreferenceStore preferenceStore = UiPlugin.getPrefStore();
    private PluginRegistrationManager pluginRegistrationManager = UiPlugin.getPluginRegistrationManager();

    @Override
    public boolean importData(String categoryId, String subcategoryId, IMemento rootRead) {
        IMemento child;
        boolean result = false;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.preferences") == 0 && subcategoryId.compareTo("com.ibm.mq.explorer.ui.subcategory.prefs.enableplugins") == 0 && (child = rootRead.getChild(PLUGINS_NODE)) != null) {
            Integer intCount = child.getInteger(PLUGINS_COUNT_KEY);
            int i = 0;
            while (i < intCount) {
                IMemento pluginChild = child.getChild(APLUGIN_NODE_PREFIX + i);
                if (pluginChild != null) {
                    String pluginId = pluginChild.getString(PLUGIN_ID_KEY);
                    Integer pluginEnabled = pluginChild.getInteger(PLUGIN_ENABLED_KEY);
                    boolean enabled = pluginEnabled == 1;
                    this.pluginRegistrationManager.enablePlugin(pluginId, enabled);
                    this.preferenceStore.setValue("EnablePlugin_" + pluginId, enabled);
                }
                ++i;
            }
            this.pluginRegistrationManager.enablementUpdateComplete();
            result = true;
        }
        return result;
    }

    @Override
    public IMemento exportData(String categoryId, String subcategoryId) {
        Trace t = Trace.getDefault();
        XMLMemento rootWrite = null;
        if (categoryId.compareTo("com.ibm.mq.explorer.ui.category.preferences") == 0 && subcategoryId.compareTo("com.ibm.mq.explorer.ui.subcategory.prefs.enableplugins") == 0) {
            rootWrite = XMLMemento.createWriteRoot((String)"Preferences");
            rootWrite.putString("FileVersion", "1.0.0");
            IMemento pluginsWrite = ExplorerImportExportPrefsGeneral.openChild(t, (IMemento)rootWrite, PLUGINS_NODE);
            ArrayList<RegisteredPlugin> registeredPlugins = this.pluginRegistrationManager.getRegisteredPlugins();
            pluginsWrite.putInteger(PLUGINS_COUNT_KEY, registeredPlugins.size());
            int i = 0;
            while (i < registeredPlugins.size()) {
                RegisteredPlugin registeredPlugin = registeredPlugins.get(i);
                IMemento pluginWrite = ExplorerImportExportPrefsGeneral.openChild(t, pluginsWrite, APLUGIN_NODE_PREFIX + i);
                pluginWrite.putString(PLUGIN_ID_KEY, registeredPlugin.getPlugin_id());
                int intSet = 0;
                if (registeredPlugin.isEnabled()) {
                    intSet = 1;
                }
                pluginWrite.putInteger(PLUGIN_ENABLED_KEY, intSet);
                ++i;
            }
        }
        return rootWrite;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    @Override
    public boolean persistData() {
        return true;
    }

    @Override
    public boolean isDestructiveImport() {
        return true;
    }
}

