/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.controls.ExtList;
import com.ibm.mq.explorer.ui.internal.filters.Filter;
import com.ibm.mq.explorer.ui.internal.filters.FilterManager;
import com.ibm.mq.explorer.ui.internal.filters.FilterProvider;
import com.ibm.mq.explorer.ui.internal.filters.ManageFiltersDialog;
import com.ibm.mq.explorer.ui.internal.utils.UiUtils;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SelectFilterDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/SelectFilterDialog.java";
    private static final int HORIZONTAL_INDENT = 20;
    private static final int LIST_WIDTH_HINT = 400;
    private static final int LIST_HEIGHT_HINT = 300;
    private static final int MODE_NO_FILTER = 0;
    private static final int MODE_APPLY_FILTER = 1;
    private int selectedMode = 0;
    private String filterId = "";
    private String instanceId = "";
    private Composite compositeButtons = null;
    private static final int NUM_COLS = 6;
    private Button radioNoFilter = null;
    private Label labelNoFilter = null;
    private Button radioApplyFilter = null;
    private ExtList listFilters = null;
    private Label labelSelFilter = null;
    private Text textSelFilter = null;
    private FilterManager filterManager = null;
    private ArrayList filterArray = null;
    private Filter selectedFilter = null;
    private Button buttonManage = null;
    private Message msgFile = null;
    private FilterProvider filterProvider = null;
    private Composite compositeControls = null;
    private Point preferredSize = null;

    public SelectFilterDialog(Shell parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Filters");
    }

    public void setValues(Trace t, FilterProvider filterProv, String filtId, String instId) {
        this.filterProvider = filterProv;
        this.filterId = filtId;
        this.instanceId = instId;
        this.filterManager = UiPlugin.getFilterManager();
        this.getAvailableFilters(t, this.filterId);
        this.selectedFilter = this.filterManager.getRegisteredCurrentFilter(t, this.filterId, this.instanceId);
    }

    private void getAvailableFilters(Trace t, String filtId) {
        this.filterArray = this.filterManager.getAvailableFilters(t, filtId);
    }

    private void manageFilters(Trace t) {
        ManageFiltersDialog manageFiltersDlg = new ManageFiltersDialog(this.getShell(), 0);
        manageFiltersDlg.setSelectedFilter(this.selectedFilter);
        manageFiltersDlg.setValues(t, this.filterProvider, this.filterId, this.instanceId);
        manageFiltersDlg.create(t);
        if (manageFiltersDlg.open(t)) {
            this.getAvailableFilters(t, this.filterId);
            this.populateFilterList(t);
            Filter selFilter = manageFiltersDlg.getSelectedFilter();
            if (selFilter == null) {
                this.listFilters.select(0);
            } else {
                int index = this.listFilters.indexOfObject(selFilter);
                this.listFilters.select(index);
            }
            this.listFilters.showSelection();
            this.filterSelectionChanged(t);
        }
    }

    private void filterSelectionChanged(Trace t) {
        String text = "";
        if (this.textSelFilter != null) {
            this.textSelFilter.setText("");
            int selectedIndex = this.listFilters.getSelectionIndex();
            if (selectedIndex != -1) {
                this.selectedFilter = (Filter)this.listFilters.getObject(selectedIndex);
                String[] details = this.selectedFilter.getFilterAsTextArray(t, this.filterProvider);
                int i = 0;
                while (i < details.length) {
                    text = String.valueOf(text) + details[i];
                    text = String.valueOf(text) + "\n";
                    ++i;
                }
            }
            this.textSelFilter.setText(text);
        }
    }

    private void populateFilterList(Trace t) {
        Filter selFilter = null;
        this.listFilters.removeAll();
        int i = 0;
        while (i < this.filterArray.size()) {
            Filter filter = (Filter)this.filterArray.get(i);
            this.listFilters.add(filter);
            if (filter.compareTo(this.selectedFilter) == 0) {
                selFilter = filter;
            }
            ++i;
        }
        this.listFilters.sort();
        if (selFilter != null) {
            this.listFilters.select(this.listFilters.indexOfObject(selFilter));
        } else {
            this.listFilters.select(0);
        }
        this.listFilters.showSelection();
        this.filterSelectionChanged(t);
    }

    private void enableControls() {
        boolean enableNoFilterControls = false;
        boolean enableApplyFilterControls = false;
        if (this.selectedMode == 0) {
            enableNoFilterControls = true;
        } else {
            enableApplyFilterControls = true;
        }
        this.labelNoFilter.setEnabled(enableNoFilterControls);
        this.listFilters.setEnabled(enableApplyFilterControls);
        this.labelSelFilter.setEnabled(enableApplyFilterControls);
        this.textSelFilter.setEnabled(enableApplyFilterControls);
        this.buttonManage.setEnabled(enableApplyFilterControls);
    }

    @Override
    public String getTitle(Trace t) {
        return this.msgFile.getMessage(t, "UI.FILTERS.Dialog.SelectFilter");
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_FilterSelectDialog";
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return true;
    }

    @Override
    public void packDialog(Trace t) {
        this.preferredSize = this.compositeControls.computeSize(-1, -1);
        this.populateFilterList(t);
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        this.compositeControls = composite;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 6;
        gridLayout.marginWidth *= 2;
        gridLayout.marginHeight *= 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 0);
        label.setVisible(false);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.radioNoFilter = new Button(composite, 16);
        this.radioNoFilter.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.NoFilter"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.radioNoFilter.setLayoutData((Object)gridData);
        this.radioNoFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectFilterDialog.this.selectedMode = 0;
                SelectFilterDialog.this.enableControls();
            }
        });
        this.labelNoFilter = new Label(composite, 0);
        this.labelNoFilter.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.IncludeAll"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.horizontalIndent = 20;
        this.labelNoFilter.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.radioApplyFilter = new Button(composite, 16);
        this.radioApplyFilter.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.ApplyFilter"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        this.radioApplyFilter.setLayoutData((Object)gridData);
        this.radioApplyFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectFilterDialog.this.selectedMode = 1;
                SelectFilterDialog.this.enableControls();
            }
        });
        this.listFilters = new ExtList(composite, 2816);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalSpan = 2;
        gridData.widthHint = 400;
        gridData.heightHint = 300;
        gridData.horizontalIndent = 20;
        this.listFilters.setLayoutData(gridData);
        this.listFilters.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                SelectFilterDialog.this.filterSelectionChanged(tr);
            }
        });
        this.labelSelFilter = new Label(composite, 0);
        this.labelSelFilter.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.SelectedFilter"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 10;
        this.labelSelFilter.setLayoutData((Object)gridData);
        this.textSelFilter = new Text(composite, 2818);
        UiUtils.makeTextControlReadOnly(t, this.textSelFilter, true);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        gridData.horizontalIndent = 10;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = this.textSelFilter.getLineHeight() * 8;
        gridData.widthHint = 400;
        this.textSelFilter.setLayoutData((Object)gridData);
        this.buttonManage = new Button(composite, 8);
        this.buttonManage.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.ManageFilters"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalIndent = 20;
        this.buttonManage.setLayoutData((Object)gridData);
        this.buttonManage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                SelectFilterDialog.this.manageFilters(tr);
            }
        });
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label(composite, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        label.setLayoutData((Object)gridData);
        this.compositeButtons = new Composite(composite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        this.compositeButtons.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 6;
        gridData.grabExcessHorizontalSpace = true;
        this.compositeButtons.setLayoutData((Object)gridData);
        label = new Label(this.compositeButtons, 0);
        label.setVisible(false);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.selectedMode = this.selectedFilter.isNullFilter() ? 0 : 1;
        if (this.selectedMode == 0) {
            this.radioNoFilter.setSelection(true);
        } else {
            this.radioApplyFilter.setSelection(true);
        }
        this.enableControls();
    }

    @Override
    public boolean okPressed(Trace t) {
        Filter selFilter = null;
        selFilter = this.selectedMode == 1 ? (Filter)this.listFilters.getObject(this.listFilters.getSelectionIndex()) : this.filterManager.getFilterRegistration(t, this.filterId).getNullFilter();
        this.filterManager.setSelectedFilter(t, this.filterId, this.instanceId, selFilter, true);
        return true;
    }

    @Override
    public void cancelPressed(Trace t) {
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        return true;
    }
}

