/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import java.text.Collator;
import java.util.Locale;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class SelectAttributeTableViewerSorter
extends ViewerSorter {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/SelectAttributeTableViewerSorter.java";
    private boolean sortAscending = true;
    private int sortColumn = 0;

    public int compare(Viewer viewer, Object o1, Object o2) {
        Trace t = Trace.getDefault();
        int retValue = 0;
        AttrType attrType1 = (AttrType)o1;
        AttrType attrType2 = (AttrType)o2;
        retValue = attrType1 == null && attrType2 == null ? 0 : (attrType1 == null ? (this.sortAscending ? -1 : 1) : (attrType2 == null ? (this.sortAscending ? 1 : -1) : this.compareObjects(t, attrType1, attrType2)));
        if (Trace.isTracing) {
            t.data(67, "SelectAttributeTableViewerSorter.compare", 300, "retValue = " + retValue);
        }
        return retValue;
    }

    private int compareObjects(Trace t, AttrType attrType1, AttrType attrType2) {
        int retValue = 0;
        String value1 = "";
        String value2 = "";
        if (this.sortColumn == 0) {
            value1 = attrType1.getDisplayTitle();
            value2 = attrType2.getDisplayTitle();
            Collator coll = Collator.getInstance(Locale.getDefault());
            retValue = this.sortAscending ? coll.compare(value1, value2) : coll.compare(value2, value1);
        } else {
            int intValue1 = attrType1.getDisplayGroup().getSequence();
            int intValue2 = attrType2.getDisplayGroup().getSequence();
            retValue = this.sortAscending ? intValue1 - intValue2 : intValue2 - intValue1;
            if (retValue == 0) {
                intValue1 = attrType1.getDisplayGroupSequence();
                intValue2 = attrType2.getDisplayGroupSequence();
                retValue = this.sortAscending ? intValue1 - intValue2 : intValue2 - intValue1;
            }
        }
        return retValue;
    }

    public void setColumn(int col) {
        this.sortColumn = col;
    }

    public void setSortAscending(boolean b) {
        this.sortAscending = b;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }
}

