/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.ui.internal.filters;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.attrs.AttrType;
import com.ibm.mq.explorer.ui.Icons;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.controls.ExtDialog;
import com.ibm.mq.explorer.ui.internal.filters.SelectAttributeTableContentProvider;
import com.ibm.mq.explorer.ui.internal.filters.SelectAttributeTableLabelProvider;
import com.ibm.mq.explorer.ui.internal.filters.SelectAttributeTableViewerSorter;
import java.util.Hashtable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class SelectAttributeDialog
extends ExtDialog {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.ui/src/com/ibm/mq/explorer/ui/internal/filters/SelectAttributeDialog.java";
    private static final int TABLE_WIDTH_HINT = 400;
    private static final int TABLE_HEIGHT_HINT = 150;
    private Message msgFile = null;
    private TableViewer tableViewer = null;
    protected TableColumn tabcolName = null;
    protected TableColumn tabcolGroup = null;
    protected SelectAttributeTableViewerSorter viewerSorter = null;
    private TableColumn lastSortTableColumn = null;
    private AttrType selAttrType = null;
    private Hashtable attrTypes = null;
    private AttrType localSelAttrType = null;
    private Point preferredSize = null;

    public SelectAttributeDialog(Shell parent, int style) {
        super(parent, style);
        Trace t = Trace.getDefault();
        this.msgFile = UiPlugin.getUIMessages(t, "KEY_Filters");
    }

    public void setValues(Trace t, Hashtable attTypes, AttrType localSelAttType) {
        this.attrTypes = attTypes;
        this.localSelAttrType = localSelAttType;
    }

    private void columnSelected(Event e) {
        TableColumn tabcol = (TableColumn)e.widget;
        if (this.lastSortTableColumn != null) {
            this.lastSortTableColumn.setImage(null);
        }
        this.viewerSorter.setColumn((Integer)tabcol.getData());
        if (tabcol.equals(this.lastSortTableColumn)) {
            this.viewerSorter.setSortAscending(!this.viewerSorter.isSortAscending());
        } else {
            this.viewerSorter.setSortAscending(true);
        }
        this.tableViewer.refresh();
        if (this.viewerSorter.isSortAscending()) {
            tabcol.setImage(Icons.get(Icons.iconkeySortAscending));
        } else {
            tabcol.setImage(Icons.get(Icons.iconkeySortDescending));
        }
        this.lastSortTableColumn = tabcol;
    }

    private void addTableSelectionListeners(Trace t) {
        this.tableViewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Trace tr = Trace.getDefault();
                SelectAttributeDialog.this.tableItemSelected(tr);
            }
        });
    }

    public AttrType getSelectedAttrType() {
        return this.selAttrType;
    }

    private void checkIfEnableOK(Trace t) {
        this.enableOK(t, this.isEnableOK(t));
    }

    @Override
    public String getTitle(Trace t) {
        return this.msgFile.getMessage(t, "UI.FILTERS.Dialog.SelectAttributeTitle");
    }

    @Override
    public Image getImage(Trace t) {
        return Icons.get(Icons.iconkeyExplorerSmall);
    }

    @Override
    public String getHelpId(Trace t) {
        return "com.ibm.mq.explorer.ui.infopop.UI_FilterSelectAttrsDialog";
    }

    @Override
    public boolean isPackDialog(Trace t) {
        return false;
    }

    @Override
    public void packDialog(Trace t) {
    }

    @Override
    public void createContent(Trace t, Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)gridLayout);
        this.tableViewer = new TableViewer(composite, 68356);
        this.tableViewer.setContentProvider((IContentProvider)new SelectAttributeTableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SelectAttributeTableLabelProvider());
        this.viewerSorter = new SelectAttributeTableViewerSorter();
        this.tableViewer.setSorter((ViewerSorter)this.viewerSorter);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        this.addTableSelectionListeners(t);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.widthHint = 400;
        gridData.heightHint = 150;
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        this.tableViewer.getTable().setLayoutData((Object)gridData);
        this.tabcolName = new TableColumn(this.tableViewer.getTable(), 0);
        this.tabcolName.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.Name"));
        this.tabcolName.setData((Object)0);
        this.tabcolName.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectAttributeDialog.this.columnSelected(e);
            }
        });
        if (this.viewerSorter.isSortAscending()) {
            this.tabcolName.setImage(Icons.get(Icons.iconkeySortAscending));
        } else {
            this.tabcolName.setImage(Icons.get(Icons.iconkeySortDescending));
        }
        this.tabcolGroup = new TableColumn(this.tableViewer.getTable(), 0);
        this.tabcolGroup.setText(this.msgFile.getMessage(t, "UI.FILTERS.Dialog.Group"));
        this.tabcolGroup.setData((Object)1);
        this.tabcolGroup.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectAttributeDialog.this.columnSelected(e);
            }
        });
        this.lastSortTableColumn = this.tabcolName;
        this.tableViewer.setInput((Object)this.attrTypes);
        this.tableViewer.getTable().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int tableWidth = ((SelectAttributeDialog)SelectAttributeDialog.this).tableViewer.getTable().getClientArea().width;
                if (tableWidth > 0) {
                    int colWidth = (tableWidth - 2 * SelectAttributeDialog.this.tableViewer.getTable().getGridLineWidth()) / 2;
                    SelectAttributeDialog.this.tabcolName.setWidth(colWidth);
                    SelectAttributeDialog.this.tabcolGroup.setWidth(colWidth);
                }
            }
        });
        composite.pack();
        this.preferredSize = composite.getSize();
        if (this.localSelAttrType != null) {
            StructuredSelection selection = new StructuredSelection((Object)this.localSelAttrType);
            this.tableViewer.setSelection((ISelection)selection, true);
        }
        this.checkIfEnableOK(t);
    }

    @Override
    public boolean okPressed(Trace t) {
        return true;
    }

    @Override
    public void cancelPressed(Trace t) {
    }

    private void tableItemSelected(Trace t) {
        Object object;
        int selIndex = this.tableViewer.getTable().getSelectionIndex();
        if (selIndex != -1 && (object = this.tableViewer.getTable().getItem(selIndex).getData()) instanceof AttrType) {
            this.selAttrType = (AttrType)object;
        }
        this.checkIfEnableOK(t);
    }

    @Override
    public boolean isUserButtons(Trace t) {
        return false;
    }

    @Override
    public void createUserButtons(Trace t, Composite composite) {
    }

    @Override
    public Point getPreferredSize(Trace t) {
        return this.preferredSize;
    }

    @Override
    public boolean isEnableOK(Trace t) {
        return this.selAttrType != null;
    }
}

